/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.collector.Collectors2;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.values.storable.Value;

abstract class IndexTransactionStateWithApplyChangesTestBase
extends KernelAPIWriteTestBase<WriteTestSupport> {
    static final String INDEX_NAME = "myIndex";
    static final String PROP1 = "prop1";
    static final String PROP2 = "prop2";

    IndexTransactionStateWithApplyChangesTestBase() {
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyChangesShouldAddPropertiesToIndexTxState(IndexType indexType, boolean needsValues) throws Exception {
        this.createIndex(indexType);
        HashSet<EntityWithProps> expected = new HashSet<EntityWithProps>();
        try (KernelTransaction tx = this.beginTransaction();){
            EntityWithProps entityWithProps = this.entityWithProps(tx, "books", "looks");
            expected.add(entityWithProps);
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.assertEntityAndValueForScan(expected, tx, index, needsValues, "something", "else");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyChangesShouldChangePropertiesInIndexTxState(IndexType indexType, boolean needsValues) throws Exception {
        EntityWithProps entityWithProps;
        this.createIndex(indexType);
        try (KernelTransaction tx = this.beginTransaction();){
            entityWithProps = this.entityWithProps(tx, "books", "looks");
            tx.commit();
        }
        HashSet<EntityWithProps> expected = new HashSet<EntityWithProps>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.setProperties(tx, entityWithProps.entityId, "val1", "val2"));
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.assertEntityAndValueForScan(expected, tx, index, needsValues, "something", "else");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyChangesShouldRemovePropertiesInIndexTxState(IndexType indexType, boolean needsValues) throws Exception {
        EntityWithProps entityWithProps;
        this.createIndex(indexType);
        try (KernelTransaction tx = this.beginTransaction();){
            entityWithProps = this.entityWithProps(tx, "books", "looks");
            tx.commit();
        }
        HashSet<EntityWithProps> expected = new HashSet<EntityWithProps>();
        try (KernelTransaction tx = this.beginTransaction();){
            this.removeProperties(tx, entityWithProps.entityId);
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.assertEntityAndValueForScan(expected, tx, index, needsValues, "something", "else");
        }
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    void assertEntityAndValue(Set<EntityWithProps> expected, KernelTransaction tx, boolean needsValues, Object anotherValueFoundByQuery, Object anotherValueFoundByQuery2, EntityValueIndexCursor entities) throws Exception {
        for (EntityWithProps entityWithProps : expected) {
            this.deleteEntity(tx, entityWithProps.entityId);
        }
        this.entityWithProps(tx, anotherValueFoundByQuery, anotherValueFoundByQuery2);
        if (needsValues) {
            HashSet<EntityWithProps> found = new HashSet<EntityWithProps>();
            while (entities.next()) {
                found.add(new EntityWithProps(entities.entityReference(), entities.propertyValue(0), entities.propertyValue(1)));
            }
            Assertions.assertThat(found).isEqualTo(expected);
        } else {
            HashSet<Long> foundIds = new HashSet<Long>();
            while (entities.next()) {
                foundIds.add(entities.entityReference());
            }
            ImmutableSet expectedIds = (ImmutableSet)expected.stream().map(EntityWithProps::entityId).collect(Collectors2.toImmutableSet());
            Assertions.assertThat(foundIds).isEqualTo((Object)expectedIds);
        }
    }

    abstract EntityWithProps entityWithProps(KernelTransaction var1, Object var2, Object var3) throws Exception;

    abstract void createIndex(IndexType var1);

    abstract void deleteEntity(KernelTransaction var1, long var2) throws Exception;

    abstract void removeProperties(KernelTransaction var1, long var2) throws Exception;

    abstract EntityWithProps setProperties(KernelTransaction var1, long var2, Object var4, Object var5) throws Exception;

    abstract void assertEntityAndValueForScan(Set<EntityWithProps> var1, KernelTransaction var2, IndexDescriptor var3, boolean var4, Object var5, Object var6) throws Exception;

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{IndexType.RANGE, true}), Arguments.of((Object[])new Object[]{IndexType.RANGE, false}));
    }

    record EntityWithProps(long entityId, Value propValue1, Value propValue2) {
    }

    static interface EntityValueIndexCursor {
        public boolean next();

        public Value propertyValue(int var1);

        public long entityReference();
    }
}

