/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.storageengine.api.RelationshipSelection;

public class NodeCursorDegreeTest
extends KernelAPIReadTestBase<ReadTestSupport> {
    @Test
    void degreeWithRelationshipDeletedInTx() throws Exception {
        long r1;
        long n2;
        try (KernelTransaction tx = this.beginTransaction();){
            long n1 = tx.dataWrite().nodeCreate();
            n2 = tx.dataWrite().nodeCreate();
            long n3 = tx.dataWrite().nodeCreate();
            int relType = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            r1 = tx.dataWrite().relationshipCreate(n1, relType, n2);
            long r2 = tx.dataWrite().relationshipCreate(n3, relType, n2);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().relationshipDelete(r1);
            try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);){
                tx.dataRead().singleNode(n2, nodeCursor);
                Assertions.assertTrue((boolean)nodeCursor.next());
                int degree = nodeCursor.degree(RelationshipSelection.selection((Direction)Direction.INCOMING));
                int maxDegree = 1;
                int degreeWithMax = nodeCursor.degreeWithMax(maxDegree, RelationshipSelection.selection((Direction)Direction.INCOMING));
                Assertions.assertEquals((int)1, (int)degree);
                Assertions.assertEquals((int)Math.min(degree, maxDegree), (int)degreeWithMax);
            }
            tx.rollback();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    public ReadTestSupport newTestSupport() {
        return new ReadTestSupport();
    }

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
    }
}

