/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.parallel;

import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.api.parallel.ParallelAccessCheck;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class ParallelAccessCheckTest {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private JobScheduler jobScheduler;
    private CallableExecutor executor;

    ParallelAccessCheckTest() {
    }

    @BeforeAll
    static void beforeAll() {
        Assumptions.assumeTrue((boolean)ParallelAccessCheck.shouldPerformCheck());
    }

    @BeforeEach
    void beforeEach() {
        this.executor = this.jobScheduler.executor(Group.CYPHER_WORKER);
    }

    @Test
    void testAllStoreHolderAccess() {
        try (Transaction tx = this.databaseAPI.beginTx();){
            Future future = this.executor.submit(() -> ((InternalTransaction)tx).kernelTransaction().dataRead().nodeExists(1L));
            Assertions.assertThatThrownBy(future::get).hasRootCauseInstanceOf(IllegalStateException.class).hasMessageContaining("A resource that does not support parallel access is being accessed by a Cypher worker thread");
        }
    }

    @Test
    void testLockClient() {
        try (Transaction tx = this.databaseAPI.beginTx();){
            Future future = this.executor.submit(() -> {
                ((InternalTransaction)tx).kernelTransaction().locks().acquireExclusiveNodeLock(new long[]{1L});
                return null;
            });
            Assertions.assertThatThrownBy(future::get).hasRootCauseInstanceOf(IllegalStateException.class).hasMessageContaining("A resource that does not support parallel access is being accessed by a Cypher worker thread");
        }
    }
}

