/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.format.aligned.PageAligned;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.tags.RecordFormatOverrideTag;

@RecordFormatOverrideTag
@PageCacheExtension
@Neo4jLayoutExtension
class StoreIdTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private RecordDatabaseLayout databaseLayout;

    StoreIdTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"standard,record-standard-1.1", "aligned,record-aligned-1.1"})
    void testRetrievalOfStoreId(String format, String expectedStoreVersion) throws IOException {
        Assertions.assertNull((Object)StoreId.retrieveFromStore((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout, (PageCache)this.pageCache, (CursorContext)CursorContext.NULL_CONTEXT));
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder((DatabaseLayout)this.databaseLayout).setFileSystem(this.fileSystem).setConfig(GraphDatabaseSettings.db_format, (Object)format).build();
        dbms.shutdown();
        StoreId storeId = StoreId.retrieveFromStore((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout, (PageCache)this.pageCache, (CursorContext)CursorContext.NULL_CONTEXT);
        Assertions.assertNotNull((Object)storeId);
        Assertions.assertEquals((Object)expectedStoreVersion, (Object)storeId.getStoreVersionUserString());
    }

    @ParameterizedTest
    @MethodSource(value={"versionCheckParams"})
    void testStoreVersionFullySupportedLocallyCheck(StoreId storeId, boolean supported) {
        Assertions.assertEquals((Object)supported, (Object)storeId.isStoreVersionFullySupportedLocally());
    }

    private static Stream<Arguments> versionCheckParams() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new StoreId(1L, 1L, "some-engine", "some-format", 1, 1), false}), Arguments.arguments((Object[])new Object[]{new StoreId(1L, 1L, "record", "some-format", 1, 1), false}), Arguments.arguments((Object[])new Object[]{new StoreId(1L, 1L, "record", PageAligned.LATEST_RECORD_FORMATS.getFormatFamily().name(), PageAligned.LATEST_RECORD_FORMATS.majorVersion() + 10, PageAligned.LATEST_RECORD_FORMATS.minorVersion()), false}), Arguments.arguments((Object[])new Object[]{new StoreId(1L, 1L, "record", PageAligned.LATEST_RECORD_FORMATS.getFormatFamily().name(), PageAligned.LATEST_RECORD_FORMATS.majorVersion(), PageAligned.LATEST_RECORD_FORMATS.minorVersion()), true}));
    }
}

