/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class CheckPointerIntegrationTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private TestDatabaseManagementServiceBuilder builder;

    CheckPointerIntegrationTest() {
    }

    @BeforeEach
    void setup() {
        this.builder = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fs);
    }

    @Test
    void databaseShutdownDuringConstantCheckPointing() throws InterruptedException {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(0L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        Thread.sleep(10L);
        managementService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void latestKernelVersionInCheckpointByDefault() throws Exception {
        DatabaseManagementService managementService = this.builder.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            CheckPointerIntegrationTest.getCheckPointer(db).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
            List<CheckpointInfo> checkpointInfos = CheckPointerIntegrationTest.checkPointsInTxLog((GraphDatabaseService)db);
            org.junit.jupiter.api.Assertions.assertEquals((Object)LatestVersions.LATEST_KERNEL_VERSION, (Object)checkpointInfos.getLast().kernelVersion());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCheckPointBasedOnTime() throws Throwable {
        long millis = 200L;
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(millis)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (CheckPointerIntegrationTest.checkPointsInTxLog(db).isEmpty()) {
            Thread.sleep(millis);
            org.junit.jupiter.api.Assertions.assertTrue((System.currentTimeMillis() < endTime ? 1 : 0) != 0, (String)"Took too long to produce a checkpoint");
        }
        managementService.shutdown();
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkPoints = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            org.junit.jupiter.api.Assertions.assertTrue((checkPoints.size() >= 2 ? 1 : 0) != 0, (String)("Expected at least two (at least one for time interval and one for shutdown), was " + String.valueOf(checkPoints)));
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCheckPointBasedOnTxCount() throws Throwable {
        int counter;
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(300L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        try {
            GraphDatabaseService db = managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.createNode();
                tx.commit();
            }
            CheckPointerIntegrationTest.triggerCheckPointAttempt(db);
            List<CheckpointInfo> checkpoints = CheckPointerIntegrationTest.checkPointsInTxLog(db);
            Assertions.assertThat(checkpoints).isNotEmpty();
            counter = checkpoints.size();
        }
        finally {
            managementService.shutdown();
        }
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkpointInfos = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            Assertions.assertThat((int)checkpointInfos.size()).isGreaterThanOrEqualTo(counter + 1);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotCheckPointWhenThereAreNoCommits() throws Throwable {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofSeconds(1L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)managementService.database("neo4j");
        CheckPointerIntegrationTest.getCheckPointer(databaseAPI).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("given"));
        int checkPointsBefore = CheckPointerIntegrationTest.checkPointsInTxLog(db).size();
        CheckPointerIntegrationTest.triggerCheckPointAttempt(db);
        Assertions.assertThat(CheckPointerIntegrationTest.checkPointsInTxLog(db)).hasSize(checkPointsBefore);
        managementService.shutdown();
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkPoints = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            org.junit.jupiter.api.Assertions.assertEquals((int)(checkPointsBefore + 1), (int)checkPoints.size());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToStartAndShutdownMultipleTimesTheDBWithoutCommittingTransactions() throws Throwable {
        TestDatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMinutes(300L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L));
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        managementService.shutdown();
        managementService = databaseManagementServiceBuilder.build();
        managementService.shutdown();
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkpoints = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)checkpoints.size());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void readTransactionInfoFromCheckpointRecord() throws IOException {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(0L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        try {
            GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)managementService.database("neo4j");
            for (int i = 0; i < 10; ++i) {
                try (Transaction transaction = databaseAPI.beginTx();){
                    transaction.createNode();
                    transaction.commit();
                    continue;
                }
            }
            ClosedTransactionMetadata closedTxMetadata = this.getMetadataProvider(databaseAPI).getLastClosedTransaction();
            TransactionId lastClosedTxId = closedTxMetadata.transactionId();
            CheckPointerIntegrationTest.getCheckPointer(databaseAPI).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
            List<CheckpointInfo> checkpointInfos = CheckPointerIntegrationTest.checkPointsInTxLog((GraphDatabaseService)databaseAPI);
            TransactionId lastCheckpointTxId = checkpointInfos.getLast().transactionId();
            org.junit.jupiter.api.Assertions.assertEquals((Object)lastClosedTxId, (Object)lastCheckpointTxId);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void oldestNotVisibleTransactionIsTheSameAsTransactionPositionOnTheDatabaseWithoutExplicitTransactions() throws IOException {
        DatabaseManagementService managementService = this.builder.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            CheckPointerIntegrationTest.getCheckPointer(db).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
            List<CheckpointInfo> checkpointInfos = CheckPointerIntegrationTest.checkPointsInTxLog((GraphDatabaseService)db);
            CheckpointInfo lastCheckpoint = checkpointInfos.getLast();
            org.junit.jupiter.api.Assertions.assertEquals((Object)lastCheckpoint.oldestNotVisibleTransactionLogPosition(), (Object)lastCheckpoint.transactionLogPosition());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void oldestNotVisibleTransactionIsTheSameAsTransactionPositionOnTheDatabaseAfterTransactions() throws IOException {
        DatabaseManagementService managementService = this.builder.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            for (int i = 0; i < 17; ++i) {
                try (Transaction transaction = db.beginTx();){
                    Node startNode = transaction.createNode();
                    Node endNode = transaction.createNode();
                    startNode.createRelationshipTo(endNode, RelationshipType.withName((String)("foo" + i)));
                    transaction.commit();
                    continue;
                }
            }
            List<CheckpointInfo> checkpointInfos = CheckPointerIntegrationTest.checkPointsInTxLog((GraphDatabaseService)db);
            CheckpointInfo lastCheckpoint = checkpointInfos.getLast();
            org.junit.jupiter.api.Assertions.assertEquals((Object)lastCheckpoint.oldestNotVisibleTransactionLogPosition(), (Object)lastCheckpoint.transactionLogPosition());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void tracePageCacheAccessOnCheckpoint() throws Exception {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(0L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        try {
            GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)managementService.database("neo4j");
            PageCacheTracer cacheTracer = (PageCacheTracer)databaseAPI.getDependencyResolver().resolveDependency(PageCacheTracer.class);
            long initialFlushes = cacheTracer.flushes();
            long initialBytesWritten = cacheTracer.bytesWritten();
            long initialPins = cacheTracer.pins();
            CheckPointerIntegrationTest.getCheckPointer(databaseAPI).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("tracing"));
            Assertions.assertThat((long)cacheTracer.flushes()).isGreaterThan(initialFlushes);
            Assertions.assertThat((long)cacheTracer.bytesWritten()).isGreaterThan(initialBytesWritten);
            Assertions.assertThat((long)cacheTracer.pins()).isGreaterThan(initialPins);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void checkpointMessageWithNotConfiguredIOController() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofHours(7L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).setInternalLogProvider((InternalLogProvider)logProvider).build();
        try {
            GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)managementService.database("neo4j");
            PageCacheTracer cacheTracer = (PageCacheTracer)databaseAPI.getDependencyResolver().resolveDependency(PageCacheTracer.class);
            long initialFlushes = cacheTracer.flushes();
            long initialBytesWritten = cacheTracer.bytesWritten();
            long initialPins = cacheTracer.pins();
            CheckPointerIntegrationTest.getCheckPointer(databaseAPI).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("tracing"));
            Assertions.assertThat((long)cacheTracer.flushes()).isGreaterThan(initialFlushes);
            Assertions.assertThat((long)cacheTracer.bytesWritten()).isGreaterThan(initialBytesWritten);
            Assertions.assertThat((long)cacheTracer.pins()).isGreaterThan(initialPins);
            LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(CheckPointerImpl.class).containsMessages(Pattern.compile("Checkpoint flushed (\\d+) pages \\(\\d+% of total available pages\\), in \\d+ IOs. Checkpoint performed with IO limit: unlimited, paused in total"), new Predicate[]{LogAssertions.greaterThan((int)25), LogAssertions.greaterThan((int)1), LogAssertions.greaterThan((int)25)});
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void checkpointMessageWithDifferentNumberOfIOsWithNotConfiguredIOController() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofHours(7L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).setInternalLogProvider((InternalLogProvider)logProvider).build();
        try {
            GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)managementService.database("neo4j");
            PageCacheTracer cacheTracer = (PageCacheTracer)databaseAPI.getDependencyResolver().resolveDependency(PageCacheTracer.class);
            String property = RandomStringUtils.insecure().nextAscii((int)ByteUnit.kibiBytes((long)2L));
            for (int i = 0; i < 100; ++i) {
                try (Transaction transaction = databaseAPI.beginTx();){
                    Node nodeA = transaction.createNode();
                    Node nodeB = transaction.createNode();
                    nodeA.setProperty("a", (Object)property);
                    nodeA.createRelationshipTo(nodeB, RelationshipType.withName((String)"foo"));
                    transaction.commit();
                    continue;
                }
            }
            long initialFlushes = cacheTracer.flushes();
            long initialBytesWritten = cacheTracer.bytesWritten();
            long initialPins = cacheTracer.pins();
            CheckPointerIntegrationTest.getCheckPointer(databaseAPI).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("tracing"));
            Assertions.assertThat((long)cacheTracer.flushes()).isGreaterThan(initialFlushes);
            Assertions.assertThat((long)cacheTracer.bytesWritten()).isGreaterThan(initialBytesWritten);
            Assertions.assertThat((long)cacheTracer.pins()).isGreaterThan(initialPins);
            LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(CheckPointerImpl.class).containsMessages(Pattern.compile("Checkpoint flushed (\\d+) pages \\((\\d+)% of total available pages\\), in (\\d+) IOs. Checkpoint performed with IO limit: unlimited, paused in total"), new Predicate[]{LogAssertions.greaterThan((int)40), LogAssertions.greaterThan((int)3), LogAssertions.greaterThan((int)40)});
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldUpdateLowestAvailableCommittedTransactionIdOnPruning() throws IOException {
        int minNumTransactionsToKeep = 50;
        DatabaseManagementService dbms = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.kibiBytes((long)128L)).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)(minNumTransactionsToKeep + " txs")).build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            MetadataProvider metadataProvider = (MetadataProvider)db.getDependencyResolver().resolveDependency(MetadataProvider.class);
            CheckPointer checkPointer = (CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class);
            long prevLowestTxId = metadataProvider.getLowestAvailableCommittedTransactionId();
            Assertions.assertThat((long)prevLowestTxId).isGreaterThan(0L);
            int numLowestTxIdBumps = 0;
            for (int i = 0; i < 100; ++i) {
                long lowestTxId;
                try (Transaction tx = db.beginTx();){
                    Node node = tx.createNode();
                    node.setProperty("foo", (Object)"bar".repeat(10000));
                    tx.commit();
                }
                if (checkPointer.checkPointIfNeeded((TriggerInfo)new SimpleTriggerInfo("Test")) == -1L || (lowestTxId = metadataProvider.getLowestAvailableCommittedTransactionId()) == prevLowestTxId) continue;
                Assertions.assertThat((long)lowestTxId).isGreaterThan(prevLowestTxId);
                int numAvailableTransactions = Math.toIntExact(metadataProvider.getLastCommittedTransactionId() - lowestTxId + 1L);
                Assertions.assertThat((int)numAvailableTransactions).isGreaterThanOrEqualTo(minNumTransactionsToKeep);
                prevLowestTxId = lowestTxId;
                ++numLowestTxIdBumps;
            }
            Assertions.assertThat((int)numLowestTxIdBumps).isGreaterThan(0);
        }
        finally {
            dbms.shutdown();
        }
    }

    private static void triggerCheckPointAttempt(GraphDatabaseService db) throws Exception {
        CheckPointerIntegrationTest.getCheckPointer((GraphDatabaseAPI)db).checkPointIfNeeded((TriggerInfo)new SimpleTriggerInfo("Test"));
    }

    private MetadataProvider getMetadataProvider(GraphDatabaseAPI databaseAPI) {
        return (MetadataProvider)databaseAPI.getDependencyResolver().resolveDependency(MetadataProvider.class);
    }

    private static CheckPointer getCheckPointer(GraphDatabaseAPI db) {
        return (CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class);
    }

    private static List<CheckpointInfo> checkPointsInTxLog(GraphDatabaseService db) throws IOException {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        LogFiles logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        return logFiles.getCheckpointFile().reachableCheckpoints();
    }
}

