/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class CheckpointerShutdownRaceIT {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @RepeatedTest(value=5)
    void databaseShutdownDuringConstantCheckPointing() {
        try (ExecutorService executor = Executors.newSingleThreadExecutor();
             DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fs).setInternalLogProvider((InternalLogProvider)this.logProvider).build();){
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.createNode();
                tx.commit();
            }
            CheckPointer checkPointer = (CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class);
            Future<?> asyncCheckpointer = executor.submit(() -> {
                try {
                    TimeUnit.MILLISECONDS.sleep(ThreadLocalRandom.current().nextInt(100));
                    checkPointer.tryCheckPointNoWait((TriggerInfo)new SimpleTriggerInfo("test"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Assertions.assertThat(asyncCheckpointer).succeedsWithin(Duration.ofMinutes(1L));
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Checkpoint was requested on already shutdown checkpointer.");
        }
    }

    @RepeatedTest(value=5)
    void databaseShutdownDuringContinuousCheckpointing() {
        try (ExecutorService executor = Executors.newSingleThreadExecutor();
             DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fs).setInternalLogProvider((InternalLogProvider)this.logProvider).setConfig(GraphDatabaseSettings.check_point_policy, (Object)GraphDatabaseSettings.CheckpointPolicy.CONTINUOUS).build();){
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.createNode();
                tx.commit();
            }
            CheckPointer checkPointer = (CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class);
            Future<?> asyncCheckpointer = executor.submit(() -> {
                try {
                    TimeUnit.MILLISECONDS.sleep(ThreadLocalRandom.current().nextInt(200));
                    checkPointer.tryCheckPointNoWait((TriggerInfo)new SimpleTriggerInfo("test"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Assertions.assertThat(asyncCheckpointer).succeedsWithin(Duration.ofMinutes(1L));
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Checkpoint was requested on already shutdown checkpointer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void warnAboutCheckpointOnShutdownCheckpointer() throws IOException {
        DatabaseManagementService managementService = null;
        try {
            managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fs).setInternalLogProvider((InternalLogProvider)this.logProvider).build();
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.createNode();
                tx.commit();
            }
            CheckPointer checkPointer = (CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class);
            managementService.shutdown();
            checkPointer.tryCheckPointNoWait((TriggerInfo)new SimpleTriggerInfo("test"));
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Checkpoint was requested on already shutdown checkpointer."});
        }
        finally {
            if (managementService != null) {
                managementService.shutdown();
            }
        }
    }
}

