/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.nativeimpl.AbsentNativeAccess;
import org.neo4j.internal.nativeimpl.ErrorTranslator;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.utils.TestDirectory;

@DbmsExtension(configurationCallback="configure")
class DynamicReadOnlyFailoverIT {
    private static final String TEST_SCOPE = "preallocation test";
    private static final int NUMBER_OF_NODES = 100;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private Config config;
    @Inject
    private Monitors monitors;
    private FailingNativeAccess nativeAccess;

    DynamicReadOnlyFailoverIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        this.nativeAccess = new FailingNativeAccess();
        builder.setExternalDependencies((DependencyResolver)Dependencies.dependenciesOf((Object)((Object)this.nativeAccess)));
    }

    @Test
    void switchDatabaseToReadOnlyModeOnPreallocationFailure() {
        long initialRotationThreshold = ByteUnit.kibiBytes((long)256L);
        Label marker = Label.label((String)"marker");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 100; ++i) {
                transaction.createNode(new Label[]{marker});
            }
            transaction.commit();
        }
        this.config.setDynamic(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)initialRotationThreshold, TEST_SCOPE);
        this.monitors.addMonitorListener((Object)new LogRotationMonitorAdapter(){

            public void startRotation(LogRotationMonitor.LogType type, long currentLogVersion) {
                DynamicReadOnlyFailoverIT.this.config.setDynamic(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)DynamicReadOnlyFailoverIT.this.getUnavailableBytes(), DynamicReadOnlyFailoverIT.TEST_SCOPE);
                DynamicReadOnlyFailoverIT.this.nativeAccess.startFailing();
                super.startRotation(type, currentLogVersion);
            }
        }, new String[0]);
        transaction = this.database.beginTx();
        try {
            Node node = transaction.createNode();
            node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)((int)(initialRotationThreshold + 100L))));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertThatThrownBy(() -> {
            try (Transaction transaction = this.database.beginTx();){
                transaction.createNode();
                transaction.commit();
            }
        }).hasMessageContaining("read-only");
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
            try (Transaction transaction = this.database.beginTx();){
                org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)Iterators.count((Iterator)transaction.findNodes(marker)));
            }
        });
        Assertions.assertThatThrownBy(() -> {
            try (Transaction transaction = this.database.beginTx();){
                transaction.createNode();
                transaction.commit();
            }
        }).hasMessageContaining("read-only");
    }

    @Test
    void doNotSwitchDatabaseToReadOnlyModeWhenFailoverIsDisabled() {
        long initialRotationThreshold = ByteUnit.kibiBytes((long)128L);
        Label marker = Label.label((String)"marker");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 100; ++i) {
                transaction.createNode(new Label[]{marker});
            }
            transaction.commit();
        }
        this.config.setDynamic(GraphDatabaseInternalSettings.dynamic_read_only_failover, (Object)false, TEST_SCOPE);
        this.config.setDynamic(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)initialRotationThreshold, TEST_SCOPE);
        this.monitors.addMonitorListener((Object)new LogRotationMonitorAdapter(){

            public void startRotation(LogRotationMonitor.LogType type, long currentLogVersion) {
                DynamicReadOnlyFailoverIT.this.config.setDynamic(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)DynamicReadOnlyFailoverIT.this.getUnavailableBytes(), DynamicReadOnlyFailoverIT.TEST_SCOPE);
                super.startRotation(type, currentLogVersion);
            }
        }, new String[0]);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
            try (Transaction transaction = this.database.beginTx();){
                Node node = transaction.createNode();
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)((int)(initialRotationThreshold + 100L))));
                transaction.commit();
            }
        });
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
            try (Transaction transaction = this.database.beginTx();){
                org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)Iterators.count((Iterator)transaction.findNodes(marker)));
            }
        });
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
            try (Transaction transaction = this.database.beginTx();){
                transaction.createNode();
                transaction.commit();
            }
        });
    }

    private long getUnavailableBytes() {
        try {
            return Files.getFileStore(this.testDirectory.homePath()).getUsableSpace() + ByteUnit.gibiBytes((long)10L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class FailingNativeAccess
    extends AbsentNativeAccess {
        private static final int ERROR_CODE = 28;
        private final AtomicBoolean fail = new AtomicBoolean();

        private FailingNativeAccess() {
        }

        public ErrorTranslator errorTranslator() {
            return callResult -> callResult.getErrorCode() == 28;
        }

        public NativeCallResult tryPreallocateSpace(int fd, long bytes) {
            if (this.fail.get()) {
                return new NativeCallResult(28, "20 minutes adventure");
            }
            return super.tryPreallocateSpace(fd, bytes);
        }

        public void startFailing() {
            this.fail.set(true);
        }
    }
}

