/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class LogFileHeaderAppendIndexIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private LogFiles logFiles;
    @Inject
    private MetadataProvider metadataProvider;

    @Test
    void logFileHeaderContainsLastIndex() throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)logFile.extractHeader(logFile.getCurrentLogVersion()).getLastAppendIndex());
        RelationshipType relationshipType = RelationshipType.withName((String)"marker");
        for (int round = 0; round < 5; ++round) {
            for (int i = 0; i < 42; ++i) {
                try (Transaction transaction = this.databaseAPI.beginTx();){
                    Node start = transaction.createNode();
                    Node end = transaction.createNode();
                    start.createRelationshipTo(end, relationshipType);
                    transaction.commit();
                    continue;
                }
            }
            logFile.rotate();
            long currentHeaderLastAppendIndex = logFile.extractHeader(logFile.getCurrentLogVersion()).getLastAppendIndex();
            Assertions.assertThat((long)currentHeaderLastAppendIndex).isGreaterThan(1L).isEqualTo(this.metadataProvider.getLastAppendIndex());
        }
    }
}

