/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
class ForwardRecoveryIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private Monitors monitors;
    private RecoveryMonitorListener recoveryMonitorListener;

    ForwardRecoveryIT() {
    }

    @BeforeEach
    void setUp() {
        this.databaseLayout = this.neo4jLayout.databaseLayout("neo4j");
        this.monitors = new Monitors();
        this.recoveryMonitorListener = new RecoveryMonitorListener(this.logProvider);
        this.monitors.addMonitorListener((Object)new LoggingLogFileMonitor(this.logProvider.getLog(this.getClass())), new String[0]);
        this.monitors.addMonitorListener((Object)this.recoveryMonitorListener, new String[0]);
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void forwardModeRecovery() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        ForwardRecoveryIT.generateData((GraphDatabaseService)database);
        ((CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        Path copyPath = this.copyStoreFiles();
        for (int i = 0; i < 10; ++i) {
            ForwardRecoveryIT.generateData((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.restoreStoreFiles(copyPath);
        this.logProvider.clear();
        this.recoverDatabase();
        GraphDatabaseAPI restartedDb = this.createDatabase();
        try (Transaction transaction = restartedDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertEquals((long)220L, (long)transaction.getAllNodes().stream().count());
        }
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery in 'forward' mode completed."}).containsMessages(new String[]{"100 transactions applied, 0 not completed transactions rolled back, skipped applying 0 previously rolled back transactions."});
    }

    @Test
    void forwardModeRecoveryProgress() throws Exception {
        GraphDatabaseAPI database = this.createDatabase();
        ForwardRecoveryIT.generateData((GraphDatabaseService)database);
        ((CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        Path copyPath = this.copyStoreFiles();
        for (int i = 0; i < 10; ++i) {
            ForwardRecoveryIT.generateData((GraphDatabaseService)database);
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.restoreStoreFiles(copyPath);
        this.logProvider.clear();
        this.recoverDatabase();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.recoveryMonitorListener.isReverseCompletionCalled());
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)this.recoveryMonitorListener.getObservedBatches());
        Assertions.assertThat((String)this.recoveryMonitorListener.getAfterTwentyBatchesMessage()).contains(new CharSequence[]{"20% completed"});
    }

    private void restoreStoreFiles(Path copyPath) throws IOException {
        this.fileSystem.copyRecursively(copyPath, this.databaseLayout.databaseDirectory());
    }

    private Path copyStoreFiles() throws IOException {
        Path storeCopy = this.testDirectory.directory("storeCopy");
        this.fileSystem.copyRecursively(this.databaseLayout.databaseDirectory(), storeCopy);
        return storeCopy;
    }

    private void recoverDatabase() throws Exception {
        Config config = Config.newBuilder().build();
        LogFiles logFiles = this.buildLogFiles(DatabaseTracers.EMPTY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isRecoveryRequired(this.databaseLayout, config, logFiles, DatabaseTracers.EMPTY));
        Recovery.performRecovery((Recovery.Context)Recovery.context((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)config, (DatabaseLayout)this.databaseLayout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)this.logProvider, (LogTailMetadata)logFiles.getTailMetadata()).recoveryMode(RecoveryMode.FORWARD).monitors(this.monitors).extensionFactories(Iterables.cast((Iterable)Services.loadAll(ExtensionFactory.class))).startupChecker(RecoveryStartupChecker.EMPTY_CHECKER));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isRecoveryRequired(this.databaseLayout, config, this.buildLogFiles(), DatabaseTracers.EMPTY));
    }

    private boolean isRecoveryRequired(DatabaseLayout layout, Config config, LogFiles logFiles, DatabaseTracers tracers) throws Exception {
        return Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache, (DatabaseLayout)layout, (Config)config, Optional.of(logFiles.getTailMetadata()), (MemoryTracker)EmptyMemoryTracker.INSTANCE, (DatabaseTracers)tracers);
    }

    private LogFiles buildLogFiles() throws IOException {
        return this.buildLogFiles(DatabaseTracers.EMPTY);
    }

    private LogFiles buildLogFiles(DatabaseTracers databaseTracers) throws IOException {
        return LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER, (LogFormatVersionProvider)LatestVersions.LATEST_LOG_FORMAT_PROVIDER).withCommandReaderFactory(StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout, null).commandReaderFactory()).withDatabaseTracers(databaseTracers).build();
    }

    private GraphDatabaseAPI createDatabase() {
        return this.createDatabase((Long)GraphDatabaseSettings.logical_log_rotation_threshold.defaultValue());
    }

    protected GraphDatabaseAPI createDatabase(long logThreshold) {
        TestDatabaseManagementServiceBuilder builder = this.createBuilder(logThreshold);
        this.managementService = builder.build();
        return (GraphDatabaseAPI)this.managementService.database(this.databaseLayout.getDatabaseName());
    }

    private TestDatabaseManagementServiceBuilder createBuilder(long logThreshold) {
        return new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setInternalLogProvider((InternalLogProvider)this.logProvider).setMonitors(this.monitors).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)logThreshold);
    }

    private static void generateData(GraphDatabaseService database) {
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node1 = transaction.createNode();
                Node node2 = transaction.createNode();
                node1.createRelationshipTo(node2, RelationshipType.withName((String)("Type" + i)));
                node2.setProperty("a", (Object)RandomStringUtils.randomAlphanumeric((int)5));
                transaction.commit();
                continue;
            }
        }
    }

    private static class RecoveryMonitorListener
    implements RecoveryMonitor {
        private final AssertableLogProvider monitorLog;
        private volatile boolean reverseCompletionCalled;
        private volatile String afterTwentyBatchesMessage;
        private final AtomicInteger batchesCounter = new AtomicInteger();

        public RecoveryMonitorListener(AssertableLogProvider logProvider) {
            this.monitorLog = logProvider;
        }

        public void batchRecovered(CommittedCommandBatchRepresentation committedBatch) {
            this.batchesCounter.incrementAndGet();
            if (this.batchesCounter.get() == 21) {
                this.afterTwentyBatchesMessage = this.monitorLog.serialize().lines().toList().toString();
            }
        }

        public void reverseStoreRecoveryCompleted(long lowestRecoveredAppendIndex) {
            this.reverseCompletionCalled = true;
        }

        public boolean isReverseCompletionCalled() {
            return this.reverseCompletionCalled;
        }

        public String getAfterTwentyBatchesMessage() {
            return this.afterTwentyBatchesMessage;
        }

        public int getObservedBatches() {
            return this.batchesCounter.get();
        }
    }
}

