/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public abstract class AbstractMandatoryTransactionsTest<T> {
    @Inject
    public GraphDatabaseService db;

    public T obtainEntity() {
        try (Transaction tx = this.db.beginTx();){
            T result = this.obtainEntityInTransaction(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public void obtainEntityInTerminatedTransaction(Consumer<T> f) {
        try (Transaction tx = this.db.beginTx();){
            T result = this.obtainEntityInTransaction(tx);
            tx.terminate();
            f.accept(result);
        }
    }

    protected abstract T obtainEntityInTransaction(Transaction var1);

    public static <T> void assertFacadeMethodsThrowNotInTransaction(T entity, Consumer<T>[] methods) {
        for (Consumer method : methods) {
            Assertions.assertThrows(NotInTransactionException.class, () -> method.accept(entity), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(method));
        }
    }

    public void assertFacadeMethodsThrowAfterTerminate(Consumer<T>[] methods) {
        for (Consumer method : methods) {
            this.obtainEntityInTerminatedTransaction(entity -> Assertions.assertThrows(TransactionTerminatedException.class, () -> method.accept(entity), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Consumer)method)));
        }
    }
}

