/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class FailingTransactionEventListenerIT {
    public static final TransactionEventListenerAdapter<Object> FAILING_BEFORE_COMMIT = new TransactionEventListenerAdapter<Object>(){

        public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            Result result = transaction.execute("return 1 / 0");
            return result.stream().count();
        }
    };
    @Inject
    private GraphDatabaseService db;
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private KernelTransactions kernelTransactions;

    @Test
    void shouldNotReturnTxToPoolTwiceWhenFailingInBeforeCommitEventListener() {
        this.managementService.registerTransactionEventListener("neo4j", FAILING_BEFORE_COMMIT);
        AssertionsForClassTypes.assertThatThrownBy(() -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CREATE (n:Something)");
                tx.commit();
            }
        });
        int numberOfActiveTransactions = this.kernelTransactions.getNumberOfActiveTransactions();
        AssertionsForClassTypes.assertThat((int)numberOfActiveTransactions).isEqualTo(0);
    }
}

