/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.factory.module.ModularDatabaseCreationContext;
import org.neo4j.internal.id.BufferedIdController;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
class CommunityEditionModuleIntegrationTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private RecordDatabaseLayout databaseLayout;

    CommunityEditionModuleIntegrationTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void createBufferedIdComponentsByDefault() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            IdController idController = (IdController)dependencyResolver.resolveDependency(IdController.class);
            IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)dependencyResolver.resolveDependency(IdGeneratorFactory.class);
            Assertions.assertThat((Object)idController).isInstanceOf(BufferedIdController.class);
            Assertions.assertThat((Object)idGeneratorFactory).isInstanceOf(BufferingIdGeneratorFactory.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void fileWatcherFileNameFilter() {
        Predicate filter = ModularDatabaseCreationContext.defaultFileWatcherFilter();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.test(this.databaseLayout.metadataStore().getFileName().toString()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.test(this.databaseLayout.nodeStore().getFileName().toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.test("neostore.transaction.db.1"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.test("checkpoint.1"));
    }

    @Test
    void ignoresTmpFiles() {
        Predicate filter = ModularDatabaseCreationContext.defaultFileWatcherFilter();
        Assertions.assertThat((boolean)filter.test(".tmp")).isTrue();
        Assertions.assertThat((boolean)filter.test("some-file.tmp")).isTrue();
    }
}

