/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.Iterator;
import org.assertj.core.util.Streams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProviders;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class DropBrokenUniquenessConstraintIT {
    private final Label label = Label.label((String)"Label");
    private final String key = "key";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RecordStorageEngine storageEngine;
    private long initialConstraintCount;
    private long initialIndexCount;
    private SchemaStore schemaStore;

    DropBrokenUniquenessConstraintIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.db_format, (Object)FormatFamily.ALIGNED.name());
    }

    @BeforeEach
    void getInitialCounts() {
        try (Transaction tx = this.db.beginTx();){
            this.initialConstraintCount = Streams.stream((Iterable)tx.schema().getConstraints()).count();
            this.initialIndexCount = Streams.stream((Iterable)tx.schema().getIndexes()).count();
        }
        this.schemaStore = this.storageEngine.testAccessNeoStores().getSchemaStore();
    }

    @AfterEach
    void assertNoAdditionalConstraintsOrIndexes() {
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertEquals((long)this.initialConstraintCount, (long)Streams.stream((Iterable)tx.schema().getConstraints()).count());
            Assertions.assertEquals((long)this.initialIndexCount, (long)Streams.stream((Iterable)tx.schema().getIndexes()).count());
        }
    }

    @Test
    void shouldDropUniquenessConstraintWithBackingIndexNotInUse() {
        String backingIndexName;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            backingIndexName = ((IndexDefinition)Iterators.single(tx.schema().getIndexes(this.label).iterator())).getName();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        try (StoreCursors storeCursors = this.storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            this.deleteSchemaRule((SchemaRule)schemaRules.indexGetForName(backingIndexName, storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE), CursorContext.NULL_CONTEXT, storeCursors);
        }
        this.storageEngine.loadSchemaCache(false);
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(tx.schema().getConstraints(this.label).iterator())).drop();
            tx.commit();
        }
    }

    @Test
    void shouldDropUniquenessConstraintWithBackingIndexHavingNoOwner() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        try (StoreCursors storeCursors = this.storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            DropBrokenUniquenessConstraintIT.writeSchemaRulesWithoutConstraint(schemaRules, DynamicAllocatorProviders.nonTransactionalAllocator((NeoStores)this.storageEngine.testAccessNeoStores()), storeCursors);
        }
        this.storageEngine.loadSchemaCache(false);
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(tx.schema().getConstraints(this.label).iterator())).drop();
            tx.commit();
        }
    }

    @Test
    void shouldDropUniquenessConstraintWhereConstraintRecordIsMissing() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        try (StoreCursors storeCursors = this.storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            schemaRules.constraintsGetAllIgnoreMalformed(storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE).forEachRemaining(rule -> this.deleteSchemaRule((SchemaRule)rule, CursorContext.NULL_CONTEXT, storeCursors));
        }
        this.storageEngine.loadSchemaCache(false);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            tx.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    @Test
    void shouldDropUniquenessConstraintWhereConstraintRecordIsMissingAndIndexHasNoOwner() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        try (StoreCursors storeCursors = this.storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            schemaRules.constraintsGetAllIgnoreMalformed(storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE).forEachRemaining(rule -> this.deleteSchemaRule((SchemaRule)rule, CursorContext.NULL_CONTEXT, storeCursors));
            DropBrokenUniquenessConstraintIT.writeSchemaRulesWithoutConstraint(schemaRules, DynamicAllocatorProviders.nonTransactionalAllocator((NeoStores)this.storageEngine.testAccessNeoStores()), storeCursors);
        }
        this.storageEngine.loadSchemaCache(false);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            tx.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    private void deleteSchemaRule(SchemaRule rule, CursorContext cursorContext, StoreCursors storeCursors) {
        SchemaRecord record = (SchemaRecord)this.schemaStore.getRecordByCursor(rule.getId(), (AbstractBaseRecord)((SchemaRecord)this.schemaStore.newRecord()), RecordLoad.NORMAL, storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        if (record.inUse()) {
            long nextProp = record.getNextProp();
            record.setInUse(false);
            try (PageCursor writeCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR);){
                this.schemaStore.updateRecord((AbstractBaseRecord)record, writeCursor, cursorContext, storeCursors);
            }
            PropertyStore propertyStore = this.schemaStore.propertyStore();
            PropertyRecord props = propertyStore.newRecord();
            PageCursor propertyReadCursor = storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);
            while (nextProp != Record.NO_NEXT_PROPERTY.longValue() && ((PropertyRecord)propertyStore.getRecordByCursor(nextProp, (AbstractBaseRecord)props, RecordLoad.NORMAL, propertyReadCursor, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).inUse()) {
                nextProp = props.getNextProp();
                props.setInUse(false);
                PageCursor writeCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);
                try {
                    propertyStore.updateRecord((AbstractBaseRecord)props, writeCursor, cursorContext, storeCursors);
                }
                finally {
                    if (writeCursor == null) continue;
                    writeCursor.close();
                }
            }
        }
    }

    private static void writeSchemaRulesWithoutConstraint(SchemaRuleAccess schemaRules, DynamicAllocatorProvider allocatorProvider, StoreCursors storeCursors) throws KernelException {
        for (IndexDescriptor rule : Iterators.loop((Iterator)schemaRules.indexesGetAll(storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE))) {
            schemaRules.writeSchemaRule((SchemaRule)rule, IdUpdateListener.DIRECT, allocatorProvider, CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE, storeCursors);
        }
    }
}

