/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Random;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.internal.batchimport.input.Groups;

public class IdGroupDistribution {
    private final long[] groupCounts;
    private final Groups groups;

    public IdGroupDistribution(long nodeCount, int numberOfGroups, Random random, Groups groups) {
        this.groups = groups;
        this.groupCounts = new long[numberOfGroups];
        long total = 0L;
        long partSize = nodeCount / (long)numberOfGroups;
        float debt = 1.0f;
        for (int i = 0; i < numberOfGroups - 1; ++i) {
            float part = random.nextFloat() * debt;
            this.assignGroup(i, (long)((float)partSize * part));
            total += this.groupCounts[i];
            debt = debt + 1.0f - part;
        }
        this.assignGroup(numberOfGroups - 1, nodeCount - total);
    }

    private void assignGroup(int i, long count) {
        this.groupCounts[i] = count;
        this.groups.getOrCreate("Group" + i);
    }

    public Group groupOf(long nodeInOrder) {
        long at = 0L;
        for (int i = 0; i < this.groupCounts.length; ++i) {
            if (nodeInOrder >= (at += this.groupCounts[i])) continue;
            return this.groups.get("Group" + i);
        }
        throw new IllegalArgumentException("Strange, couldn't find group for node (import order) " + nodeInOrder + ", counted to " + at + " as total number of " + at);
    }
}

