/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesMatcher;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class LogFileMatcherIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LogFiles logFiles;
    @Inject
    private FileSystemAbstraction fs;

    @Test
    void logFileMatching() throws IOException {
        Path logsDirectory = this.database.databaseLayout().getTransactionLogsDirectory();
        LogFilesMatcher logFilesMatcher = new LogFilesMatcher(this.fs, logsDirectory);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logFilesMatcher.hasAnyLogFiles());
        Assertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).isEqualTo((Object)logFilesMatcher.getCheckpointLogFiles());
        Assertions.assertThat((Object[])this.logFiles.getLogFile().getMatchedFiles()).isEqualTo((Object)logFilesMatcher.getTransactionLogFiles());
    }

    @Test
    void wrongDirectoryLogFileMatching() throws IOException {
        Path logsDirectory = this.fs.createTempDirectory(this.database.databaseLayout().getTransactionLogsDirectory(), "other");
        LogFilesMatcher logFilesMatcher = new LogFilesMatcher(this.fs, logsDirectory);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)logFilesMatcher.hasAnyLogFiles());
        Assertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).isNotEqualTo((Object)logFilesMatcher.getCheckpointLogFiles());
        Assertions.assertThat((Object[])this.logFiles.getLogFile().getMatchedFiles()).isNotEqualTo((Object)logFilesMatcher.getTransactionLogFiles());
    }

    @Test
    void individualFileMatching() throws IOException {
        Path logsDirectory = this.database.databaseLayout().getTransactionLogsDirectory();
        LogFilesMatcher logFilesMatcher = new LogFilesMatcher(this.fs, logsDirectory);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)logFilesMatcher.isLogFile(Path.of("foo", new String[0])));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)logFilesMatcher.isLogFile(logsDirectory));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logFilesMatcher.isLogFile(this.logFiles.getCheckpointFile().getCurrentFile()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)logFilesMatcher.isLogFile(this.logFiles.getLogFile().getLogRangeInfo().highestFile()));
    }
}

