/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.cli.CommandTestUtils;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.importer.ImportCommand;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.storemigration.StoreMigrationTestUtils;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.SkipOnSpd;
import org.neo4j.test.utils.TestDirectory;
import picocli.CommandLine;

@Neo4jLayoutExtension
class LogFormatSelectionIT {
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    TestDirectory testDirectory;
    @Inject
    FileSystemAbstraction fs;
    private TestDatabaseManagementServiceBuilder builder;
    private DatabaseManagementService managementService;

    LogFormatSelectionIT() {
    }

    public static Stream<Arguments> formatSwitchAllowedAndDbName() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"neo4j", true}), Arguments.arguments((Object[])new Object[]{"neo4j", false}), Arguments.arguments((Object[])new Object[]{"system", true}), Arguments.arguments((Object[])new Object[]{"system", false}));
    }

    @AfterEach
    void shutdown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void logFormatProviderShouldBeUpdatedOnUpgrade(String dbName) throws Throwable {
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        this.createBuilderNoAutomaticUpgrade();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersionAndLogFormat(db, KernelVersion.V5_0);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)db, (KernelVersion)KernelVersion.V5_0, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.assertKernelVersionAndLogFormat(db, LatestVersions.LATEST_KERNEL_VERSION);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, LatestVersions.LATEST_KERNEL_VERSION);
    }

    @ParameterizedTest
    @MethodSource(value={"formatSwitchAllowedAndDbName"})
    void upgradeToFuture(String dbName, boolean allowFormatSwitchOnUpgrade) throws IOException {
        LogFormat expectedFormat = allowFormatSwitchOnUpgrade ? LogFormat.fromKernelVersion((KernelVersion)KernelVersion.GLORIOUS_FUTURE) : LogFormat.fromKernelVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.createBuilder();
        this.builder.setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)false);
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.shutdown();
        this.createBuilderNoAutomaticUpgrade();
        this.builder.setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)allowFormatSwitchOnUpgrade);
        this.managementService = this.configureGloriousFutureAsLatest(this.builder).build();
        db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersionAndLogFormat(db, LatestVersions.LATEST_KERNEL_VERSION);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)db, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        LogFormatSelectionIT.assertLogFormat(db, expectedFormat);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, expectedFormat);
    }

    @ParameterizedTest
    @MethodSource(value={"formatSwitchAllowedAndDbName"})
    void formatOnNewDb(String dbName, boolean allowFormatSwitchOnUpgrade) throws IOException {
        LogFormat expectedFormat = allowFormatSwitchOnUpgrade ? LogFormat.V10 : LogFormat.fromKernelVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.createBuilder();
        this.builder.setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)allowFormatSwitchOnUpgrade);
        this.managementService = this.configureGloriousFutureAsLatest(this.builder).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        LogFormatSelectionIT.assertLogFormat(db, expectedFormat);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, expectedFormat);
    }

    @ParameterizedTest
    @MethodSource(value={"formatSwitchAllowedAndDbName"})
    void startUpWithoutLogFiles(String dbName, boolean allowFormatSwitchOnUpgrade) throws IOException {
        LogFormat expectedFormat = allowFormatSwitchOnUpgrade ? LogFormat.fromKernelVersion((KernelVersion)KernelVersion.GLORIOUS_FUTURE) : LogFormat.fromKernelVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.createBuilder();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.shutdown();
        this.fs.deleteRecursively(this.neo4jLayout.databaseLayout(dbName).getTransactionLogsDirectory());
        this.createBuilderNoAutomaticUpgrade();
        this.builder.setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)allowFormatSwitchOnUpgrade);
        this.builder.setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false);
        this.managementService = this.configureGloriousFutureAsLatest(this.builder).build();
        db = (GraphDatabaseAPI)this.managementService.database(dbName);
        if (!"system".equals(dbName)) {
            UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
            LogFormatSelectionIT.assertLogFormat(db, expectedFormat);
            UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)db, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        }
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        LogFormatSelectionIT.assertLogFormat(db, expectedFormat);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, expectedFormat);
    }

    @ParameterizedTest
    @MethodSource(value={"formatSwitchAllowedAndDbName"})
    void recoveryOverUpgradeTransaction(String dbName, boolean allowFormatSwitchOnUpgrade) throws Throwable {
        LogFormat expectedFormat = LogFormatSelectionIT.newFormatExpected(allowFormatSwitchOnUpgrade) ? LogFormat.fromKernelVersion((KernelVersion)KernelVersion.GLORIOUS_FUTURE) : LogFormat.fromKernelVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.createBuilder();
        this.managementService = this.builder.build();
        this.shutdown();
        this.builder = this.configureGloriousFutureAsLatest(this.builder).setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)allowFormatSwitchOnUpgrade);
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        DatabaseLayout dbLayout = db.databaseLayout();
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)db, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        this.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fs, (Config)Config.defaults((Setting)GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()));
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fs).kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
        this.managementService = this.builder.setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)true).build();
        db = (GraphDatabaseAPI)this.managementService.database(dbName);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, expectedFormat);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @SkipOnSpd(reason="Can't migrate spd databases")
    void migrate(boolean allowFormatSwitchOnUpgrade) throws Throwable {
        LogFormat expectedFormat = allowFormatSwitchOnUpgrade ? LogFormat.fromKernelVersion((KernelVersion)KernelVersion.GLORIOUS_FUTURE) : LogFormat.fromKernelVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.createBuilder();
        this.builder.setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)false);
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database("neo4j");
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        Path config = this.neo4jLayout.homeDirectory().resolve("migration-config.conf");
        MapUtil.store(Map.of(GraphDatabaseInternalSettings.latest_kernel_version.name(), "" + KernelVersion.GLORIOUS_FUTURE.version(), GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create.name(), Boolean.toString(allowFormatSwitchOnUpgrade)), (Path)config);
        String[] args = new String[]{"--verbose", "--additional-config", config.toString(), "neo4j"};
        StoreMigrationTestUtils.Result result = StoreMigrationTestUtils.runStoreMigrationCommandFromSameJvm((Neo4jLayout)this.neo4jLayout, (String[])args);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.exitCode()).withFailMessage(result.err(), new Object[0])).isEqualTo(0);
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, expectedFormat);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void importSelectsLogFormatBasedOnSetting(boolean allowNewFormat) throws Exception {
        LogFormat expectedFormat = allowNewFormat ? LogFormat.V10 : LogFormat.fromKernelVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        Path dbConfig = this.testDirectory.file("neo4j.properties");
        MapUtil.store(Map.of(GraphDatabaseSettings.neo4j_home.name(), this.testDirectory.absolutePath().toString(), GraphDatabaseSettings.preallocate_logical_logs.name(), "false", GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create.name(), Boolean.toString(allowNewFormat), GraphDatabaseInternalSettings.latest_kernel_version.name(), "" + KernelVersion.GLORIOUS_FUTURE.version(), GraphDatabaseInternalSettings.latest_runtime_version.name(), "" + DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion()), (Path)dbConfig);
        CommandTestUtils.CapturingExecutionContext ctx = CommandTestUtils.capturingExecutionContext((Path)this.testDirectory.absolutePath(), (Path)this.testDirectory.absolutePath().resolve("conf"), (FileSystemAbstraction)this.testDirectory.getFileSystem());
        this.runImport((ExecutionContext)ctx, "--report-file", this.testDirectory.file("import.report").toAbsolutePath().toString(), "--additional-config", dbConfig.toAbsolutePath().toString(), "--nodes", this.nodeData().toAbsolutePath().toString());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ctx.outAsString().contains("IMPORT DONE"));
        LogFiles logFiles = LogFilesBuilder.readOnlyBuilder((DatabaseLayout)this.neo4jLayout.databaseLayout("neo4j"), (FileSystemAbstraction)this.fs, (KernelVersionProvider)KernelVersionProvider.THROWING_PROVIDER, (LogFormatVersionProvider)LogFormatVersionProvider.THROWING_PROVIDER).build();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, expectedFormat);
    }

    private static boolean newFormatExpected(boolean allowFormatSwitchOnUpgrade) {
        return allowFormatSwitchOnUpgrade || LatestVersions.LATEST_LOG_FORMAT.equals((Object)LogFormat.V10);
    }

    private void runImport(ExecutionContext ctx, String ... arguments) throws Exception {
        ImportCommand.Full cmd = new ImportCommand.Full(ctx);
        new CommandLine((Object)cmd).setUseSimplifiedAtFiles(true).parseArgs(arguments);
        cmd.execute();
    }

    private Path nodeData() throws Exception {
        Path file = this.testDirectory.file("nodes.csv");
        try (PrintStream writer = new PrintStream(Files.newOutputStream(file, new OpenOption[0]), false, StandardCharsets.UTF_8);){
            LogFormatSelectionIT.writeNodeHeader(writer);
            writer.println("NODE1" + Configuration.COMMAS.delimiter() + "name" + Configuration.COMMAS.delimiter() + "LabelName");
        }
        return file;
    }

    private static void writeNodeHeader(PrintStream writer) {
        writer.println("id:" + Type.ID.name() + Configuration.COMMAS.delimiter() + "name" + Configuration.COMMAS.delimiter() + "labels:LABEL");
    }

    private static void checkLogFormatOfLatestFiles(LogFiles logFiles, KernelVersion kernelVersion) throws IOException {
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, LogFormat.fromKernelVersion((KernelVersion)kernelVersion));
    }

    private static void checkLogFormatOfLatestFiles(LogFiles logFiles, LogFormat expectedFormat) throws IOException {
        Assertions.assertThat((Comparable)logFiles.getLogFile().extractHeader(logFiles.getLogFile().getLogRangeInfo().highestVersion()).getLogFormatVersion()).isEqualTo((Object)expectedFormat);
        Assertions.assertThat((Comparable)logFiles.getCheckpointFile().extractHeader(logFiles.getCheckpointFile().getLogRangeInfo().highestVersion()).getLogFormatVersion()).isEqualTo((Object)expectedFormat);
    }

    private TestDatabaseManagementServiceBuilder configureGloriousFutureAsLatest(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version());
    }

    void assertKernelVersionAndLogFormat(GraphDatabaseAPI db, KernelVersion expectedKernelVersion) {
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)expectedKernelVersion);
        LogFormatSelectionIT.assertLogFormat(db, LogFormat.fromKernelVersion((KernelVersion)expectedKernelVersion));
    }

    private static void assertLogFormat(GraphDatabaseAPI db, LogFormat expectedFormat) {
        Assertions.assertThat((Comparable)((LogFormatVersionProvider)db.getDependencyResolver().resolveDependency(LogFormatVersionProvider.class)).getCurrentLogFormat()).isEqualTo((Object)expectedFormat);
    }

    private void createBuilder() {
        this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all");
    }

    private void createBuilderNoAutomaticUpgrade() {
        this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false);
    }
}

