/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.version.VersionStorageTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.database.transaction.LogChannel;
import org.neo4j.kernel.api.database.transaction.TransactionLogChannels;
import org.neo4j.kernel.api.database.transaction.TransactionLogService;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.tracer.DefaultDatabaseTracer;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogRangeInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogFile;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.concurrent.BinaryLatch;

@DbmsExtension(configurationCallback="configure")
class TransactionLogServiceIT {
    private static final long THRESHOLD = ByteUnit.kibiBytes((long)256L);
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private TransactionLogService logService;
    @Inject
    private LogFiles logFiles;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private LogicalTransactionStore transactionStore;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private MetadataProvider metadataProvider;
    @Inject
    private DatabaseAvailabilityGuard availabilityGuard;

    TransactionLogServiceIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        InjectableBeforeApplyTracers tracers = new InjectableBeforeApplyTracers();
        builder.setExternalDependencies((DependencyResolver)Dependencies.dependenciesOf((Object)tracers));
        builder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)THRESHOLD).setConfig(GraphDatabaseSettings.check_point_policy, (Object)GraphDatabaseSettings.CheckpointPolicy.PERIODIC).setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofDays(10L)).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"2 files");
    }

    @Test
    void rotationDuringTransactionLogReadingKeepNonAffectedChannelsOpen() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        this.createNodeInIsolatedTransaction("any");
        int numberOfTransactions = 30;
        long lastAppendIndexBeforeWorkload = this.metadataProvider.getLastAppendIndex();
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(lastAppendIndexBeforeWorkload + 30L);){
            List logFileChannels = logReaders.getChannels();
            int expectedLogChannelsSize = (Boolean)Config.defaults().get(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create) != false ? 3 : 1;
            Assertions.assertThat((List)logFileChannels).hasSize(expectedLogChannelsSize);
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test checkpoint"));
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSize(4);
            for (LogChannel logChannel : logFileChannels) {
                StoreChannel channel = logChannel.channel();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
                org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> channel.size());
            }
        }
    }

    @Test
    void rotationDuringTransactionLogReading() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        int numberOfTransactions = 30;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            StoreChannel channel;
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test checkpoint"));
            int txLogsAfterCheckpoint = 3;
            int visibleTxLogsAfterCheckpoints = (Boolean)Config.defaults().get(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create) != false ? txLogsAfterCheckpoint : txLogsAfterCheckpoint - 1;
            int checkpointLogs = 1;
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSize(txLogsAfterCheckpoint + checkpointLogs);
            List closedChannels = logFileChannels.subList(0, logFileChannels.size() - visibleTxLogsAfterCheckpoints);
            List openChannels = logFileChannels.subList(logFileChannels.size() - visibleTxLogsAfterCheckpoints, logFileChannels.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)(closedChannels.size() + openChannels.size()), (int)logFileChannels.size());
            for (LogChannel logChannel : closedChannels) {
                channel = logChannel.channel();
                org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.isOpen());
                org.junit.jupiter.api.Assertions.assertThrows(ClosedChannelException.class, () -> channel.size());
            }
            for (LogChannel logChannel : openChannels) {
                channel = logChannel.channel();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
                org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> channel.size());
            }
        }
    }

    @Test
    void closingReadersDoesAutomaticCleanup() throws Exception {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        int numberOfTransactions = 30;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            Assertions.assertThat((Object[])this.logFiles.logFiles()).hasSizeGreaterThanOrEqualTo(numberOfTransactions);
            Assertions.assertThat((Map)((TransactionLogFile)this.logFiles.getLogFile()).getExternalFileReaders()).isNotEmpty();
        }
        Assertions.assertThat((Map)((TransactionLogFile)this.logFiles.getLogFile()).getExternalFileReaders()).isEmpty();
    }

    @Test
    void requestLogFileChannelsOfInvalidTransactions() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.logService.logFilesChannels(-1L));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.logService.logFilesChannels(100L));
    }

    @Test
    void requireDirectByteBufferForLogFileAppending() {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.logService.append(ByteBuffer.allocate(5), OptionalLong.empty(), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte())));
    }

    @Test
    void failBulkAppendOnNonAvailableDatabase() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.logService.append(ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}), OptionalLong.empty(), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendToTransactionLogsDoesNotChangeLastCommittedTransactionOffset() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        ClosedTransactionMetadata metadataBefore = this.metadataProvider.getLastClosedTransaction();
        ByteBuffer buffer = TransactionLogServiceIT.createBuffer().put(new byte[]{1, 2, 3, 4, 5});
        try {
            for (int i = 0; i < 100; ++i) {
                buffer.rewind();
                this.logService.append(buffer, OptionalLong.empty(), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)metadataBefore, (Object)this.metadataProvider.getLastClosedTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendWithRotationDoesNotChangeLastClosedMetadata() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        ClosedTransactionMetadata metadataBefore = this.metadataProvider.getLastClosedTransaction();
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(i + 7), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)metadataBefore, (Object)this.metadataProvider.getLastClosedTransaction());
        Object[] matchedFiles = this.logFiles.getLogFile().getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize((int)(logVersionBefore + (long)appendIterations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendWithRotationUpdatesMetadataProviderLogVersion() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(i + 7), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        long logVersionAfter = this.metadataProvider.getCurrentLogVersion();
        Assertions.assertThat((long)logVersionAfter).isEqualTo(logVersionBefore + (long)appendIterations - 1L).isNotEqualTo(logVersionBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendRotatedLogFilesHaveCorrectSupplierTransactionsFromHeader() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        int indexShift = 10;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(indexShift + i), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        LogFile logFile = this.logFiles.getLogFile();
        TransactionLogFileInformation logFileInformation = logFile.getLogFileInformation();
        int version = (int)logVersionBefore + 1;
        while ((long)version < logVersionBefore + (long)appendIterations) {
            org.junit.jupiter.api.Assertions.assertEquals((long)(indexShift - 1 + version), (long)logFileInformation.getPreviousAppendIndexFromHeader((long)version));
            org.junit.jupiter.api.Assertions.assertEquals((long)(indexShift - 1 + version), (long)logFile.extractHeader((long)version).getLastAppendIndex());
            ++version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendForEnvelopesRotatesOnNewFileOnSender() throws IOException {
        Assumptions.assumeTrue((boolean)LatestVersions.LATEST_LOG_FORMAT.usesSegments());
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        LogFile logFile = this.logFiles.getLogFile();
        LogPosition startPosition = logFile.getTransactionLogWriter().getCurrentPosition();
        int dataSize = LogSegments.DEFAULT_LOG_SEGMENT_SIZE / 2;
        ByteBuffer appendData = ByteBuffers.allocateDirect((int)dataSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE).put(RandomStringUtils.randomAscii((int)dataSize).getBytes(StandardCharsets.UTF_8)).rewind();
        try {
            this.logService.append(appendData, OptionalLong.of(1L), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
            appendData.rewind();
            this.logService.append(appendData, OptionalLong.of(2L), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, (long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        LogRangeInfo logRangeInfo = logFile.getLogRangeInfo();
        Assertions.assertThat((long)logRangeInfo.highestVersion()).isEqualTo(logRangeInfo.lowestVersion() + 1L);
        Assertions.assertThat((long)Files.size(logFile.getLogFileForVersion(logRangeInfo.lowestVersion()))).isEqualTo(startPosition.getByteOffset() + (long)dataSize);
        Assertions.assertThat((Comparable)logFile.getTransactionLogWriter().getCurrentPosition()).isEqualTo((Object)new LogPosition(logRangeInfo.highestVersion(), (long)(LogSegments.DEFAULT_LOG_SEGMENT_SIZE + dataSize)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendForEnvelopesDoesntRotateOnNewFileOnSenderIfAlreadyRotated() throws IOException {
        Assumptions.assumeTrue((boolean)LatestVersions.LATEST_LOG_FORMAT.usesSegments());
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        LogFile logFile = this.logFiles.getLogFile();
        logFile.rotate();
        LogRangeInfo logRangeInfo = logFile.getLogRangeInfo();
        Assertions.assertThat((long)logRangeInfo.highestVersion()).isEqualTo(logRangeInfo.lowestVersion() + 1L);
        int dataSize = LogSegments.DEFAULT_LOG_SEGMENT_SIZE / 2;
        ByteBuffer appendData = ByteBuffers.allocateDirect((int)dataSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE).put(RandomStringUtils.randomAscii((int)dataSize).getBytes(StandardCharsets.UTF_8)).rewind();
        try {
            this.logService.append(appendData, OptionalLong.of(1L), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, (long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        logRangeInfo = logFile.getLogRangeInfo();
        Assertions.assertThat((long)logRangeInfo.highestVersion()).isEqualTo(logRangeInfo.lowestVersion() + 1L);
        Assertions.assertThat((Comparable)logFile.getTransactionLogWriter().getCurrentPosition()).isEqualTo((Object)new LogPosition(logRangeInfo.highestVersion(), (long)(LogSegments.DEFAULT_LOG_SEGMENT_SIZE + dataSize)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendRotatedLogFilesMonitorEvents() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        BulkAppendLogRotationMonitor monitorListener = new BulkAppendLogRotationMonitor();
        ((Monitors)this.databaseAPI.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)monitorListener, new String[0]);
        int appendIterations = 100;
        int transactionalShift = 10;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(transactionalShift + i), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        List<Long> observedVersions = monitorListener.getObservedVersions();
        ((ListAssert)Assertions.assertThat(observedVersions).hasSize(99)).containsExactlyElementsOf((Iterable)LongStream.range(0L, 99L).boxed().collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bulkAppendRotatedLogFilesTracingEvents() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        DatabaseTracers databaseTracers = (DatabaseTracers)this.databaseAPI.getDependencyResolver().resolveDependency(DatabaseTracers.class);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)databaseTracers.getDatabaseTracer().numberOfLogRotations());
        int appendIterations = 100;
        int transactionalShift = 10;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                this.logService.append(appendData, OptionalLong.of(transactionalShift + i), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        int expectedRotations = appendIterations - 1;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedRotations, (long)databaseTracers.getDatabaseTracer().numberOfLogRotations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void restoreOnCurrentLogVersion() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        int appendIterations = 100;
        LogPosition previousPosition = null;
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            for (int i = 0; i < appendIterations; ++i) {
                LogPosition position = this.logService.append(appendData, OptionalLong.empty(), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
                if (previousPosition != null) {
                    org.junit.jupiter.api.Assertions.assertEquals(previousPosition, (Object)position);
                }
                this.logService.restore(position);
                previousPosition = position;
                appendData.rewind();
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)logVersionBefore, (long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void restoreInitialLogVersionAndAppend() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        long logVersionBefore = this.metadataProvider.getCurrentLogVersion();
        ByteBuffer appendData = TransactionLogServiceIT.createBuffer().put(RandomStringUtils.randomAscii((int)((int)(THRESHOLD + 1L))).getBytes(StandardCharsets.UTF_8));
        try {
            int appendIterations = 100;
            LogPosition firstPosition = null;
            for (int i = 0; i < appendIterations; ++i) {
                LogPosition position = this.logService.append(appendData, OptionalLong.of(i + 5), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte()));
                if (firstPosition == null) {
                    firstPosition = position;
                }
                appendData.rewind();
            }
            Assertions.assertThat((long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion()).isGreaterThanOrEqualTo(firstPosition.getLogVersion());
            this.logService.restore(firstPosition);
            org.junit.jupiter.api.Assertions.assertEquals((Object)firstPosition, (Object)this.logService.append(appendData, OptionalLong.of(5L), Optional.of(LatestVersions.LATEST_KERNEL_VERSION.version()), -559063315, -1L, Optional.of(LatestVersions.LATEST_LOG_FORMAT.getVersionByte())));
            org.junit.jupiter.api.Assertions.assertEquals((long)logVersionBefore, (long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion());
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)appendData, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }

    @Test
    void logFileChannelsAreNonWritable() throws IOException {
        this.createNodeInIsolatedTransaction("a");
        this.createNodeInIsolatedTransaction("b");
        this.createNodeInIsolatedTransaction("c");
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSize(1);
            LogChannel channel = (LogChannel)logFileChannels.get(0);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)channel.startAppendIndex());
            StoreChannel storeChannel = channel.channel();
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.writeAll(ByteBuffers.allocate((int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE)));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.writeAll(ByteBuffers.allocate((int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE), 1L));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.truncate(1L));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.write(ByteBuffers.allocate((int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE)));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.write(new ByteBuffer[0], 1, 1));
            org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> storeChannel.write(new ByteBuffer[0]));
        }
    }

    @Test
    void setsStartingTransactionIdCorrectlyForAllFiles() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD / 2));
        int numberOfTransactions = 40;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        int initialAppendIndex = 17;
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels((long)initialAppendIndex);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSizeGreaterThanOrEqualTo(14);
            TransactionLogServiceIT.checkChannelsCoverage(logFileChannels, initialAppendIndex, ((TransactionIdStore)this.databaseAPI.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId());
            long prevLastTxId = -1L;
            for (LogChannel logChannel : logFileChannels) {
                if (prevLastTxId != -1L) {
                    Assertions.assertThat((long)logChannel.startAppendIndex()).isEqualTo(prevLastTxId + 1L);
                }
                prevLastTxId = logChannel.lastAppendIndex();
            }
        }
    }

    @Test
    void setsLastTransactionIdCorrectlyForAllFiles() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD / 2));
        int numberOfTransactions = 40;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        int initialAppendIndex = 17;
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels((long)initialAppendIndex);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSizeGreaterThanOrEqualTo(14);
            TransactionLogServiceIT.checkChannelsCoverage(logFileChannels, initialAppendIndex, ((TransactionIdStore)this.databaseAPI.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId());
            long prevLastTxId = -1L;
            for (LogChannel logChannel : logFileChannels) {
                if (prevLastTxId != -1L) {
                    Assertions.assertThat((long)prevLastTxId).isEqualTo(logChannel.startAppendIndex() - 1L);
                }
                prevLastTxId = logChannel.lastAppendIndex();
            }
        }
    }

    @Test
    void endOffsetPositionedToEndOfFile() throws IOException {
        String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD));
        int numberOfTransactions = 30;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction(propertyValue);
        }
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels(2L);){
            List channels = logReaders.getChannels();
            List fullChannels = channels.subList(0, channels.size() - 1);
            for (LogChannel fullChannel : fullChannels) {
                Assertions.assertThat((long)fullChannel.endOffset()).isEqualTo(fullChannel.channel().size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void endOffsetPositionedToLastCommittedTransaction() throws Exception {
        this.createNodeInIsolatedTransaction("some prop value");
        BinaryLatch txIsCommitted = new BinaryLatch();
        BinaryLatch canCloseTx = new BinaryLatch();
        try (OtherThreadExecutor e1 = new OtherThreadExecutor("tx taking a long time to apply");){
            InjectableBeforeApplyTracers.InjectableBeforeApplyTxWriteEvent.INSTANCE.beforeStoreApply.set(() -> {
                txIsCommitted.release();
                canCloseTx.await();
            });
            long initialLastCommittedTx = this.metadataProvider.getLastCommittedTransactionId();
            long initialLastClosedTx = this.metadataProvider.getLastClosedTransactionId();
            Future hasAppliedTx = e1.executeDontWait(() -> {
                try (Transaction tx = this.databaseAPI.beginTx();){
                    tx.createNode();
                    tx.commit();
                }
                return null;
            });
            try {
                txIsCommitted.await();
                this.createNodeInIsolatedTransaction("some prop value");
                long lastCommittedTransaction = this.metadataProvider.getLastCommittedTransactionId();
                long lastAppendIndex = this.metadataProvider.getLastAppendIndex();
                long lastClosedTx = this.metadataProvider.getLastClosedTransactionId();
                Assertions.assertThat((long)lastClosedTx).isEqualTo(initialLastClosedTx);
                Assertions.assertThat((long)lastAppendIndex).isEqualTo(initialLastCommittedTx + 2L);
                try (TransactionLogChannels logReaders = this.logService.logFilesChannels(lastAppendIndex);){
                    List channels = logReaders.getChannels();
                    Assertions.assertThat((List)channels).hasSize(1);
                    LogChannel channel = (LogChannel)channels.get(0);
                    Assertions.assertThat((long)channel.lastAppendIndex()).isEqualTo(lastCommittedTransaction);
                    Assertions.assertThat((long)channel.startAppendIndex()).isEqualTo(lastCommittedTransaction);
                    Assertions.assertThat((long)channel.endOffset()).isEqualTo(this.getTxEndOffset(lastCommittedTransaction));
                }
            }
            finally {
                canCloseTx.release();
                hasAppliedTx.get(1L, TimeUnit.MINUTES);
            }
        }
    }

    @Test
    void firstLogChannelIsProperlyPositionedToInitialTransaction() throws IOException {
        int numberOfTransactions = 20;
        for (int i = 0; i < numberOfTransactions; ++i) {
            this.createNodeInIsolatedTransaction("abc");
        }
        this.verifyReportedPositions(2, this.getTxStartOffset(2L));
        this.verifyReportedPositions(3, this.getTxStartOffset(3L));
        this.verifyReportedPositions(4, this.getTxStartOffset(4L));
        this.verifyReportedPositions(5, this.getTxStartOffset(5L));
        this.verifyReportedPositions(15, this.getTxStartOffset(15L));
    }

    @Test
    void setsPreviousChecksumCorrectlyForEnvelopedLogs() throws IOException {
        Path directory = this.testDirectory.directory("home-dir");
        try (DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(directory).setConfig(Map.of(GraphDatabaseInternalSettings.latest_kernel_version, KernelVersion.GLORIOUS_FUTURE.version(), GraphDatabaseInternalSettings.latest_runtime_version, DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion(), GraphDatabaseInternalSettings.envelope_log_format_on_future, true)).build();){
            GraphDatabaseAPI database = (GraphDatabaseAPI)dbms.database("neo4j");
            String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD / 16));
            int numberOfTransactions = 32;
            for (int i = 0; i < numberOfTransactions; ++i) {
                try (Transaction tx = database.beginTx();){
                    Node node = tx.createNode();
                    node.setProperty("a", (Object)propertyValue);
                    tx.commit();
                    continue;
                }
            }
            TransactionLogService logService = (TransactionLogService)database.getDependencyResolver().resolveDependency(TransactionLogService.class);
            LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
            TransactionMetadataCache metadataCache = (TransactionMetadataCache)database.getDependencyResolver().resolveDependency(TransactionMetadataCache.class);
            int initialAppendIndex = 17;
            TransactionMetadataCache.TransactionMetadata transactionMetadata = metadataCache.getTransactionMetadata((long)initialAppendIndex);
            LogPosition logPosition = transactionMetadata.startPosition();
            long logVersion = logPosition.getLogVersion();
            try (TransactionLogChannels logReaders = logService.logFilesChannels((long)initialAppendIndex);){
                List logFileChannels = logReaders.getChannels();
                Assertions.assertThat((List)logFileChannels).hasSize(4);
                for (LogChannel logChannel : logFileChannels) {
                    LogHeader logHeader = logFiles.getLogFile().extractHeader(logVersion);
                    int expectedChecksum = logVersion != logPosition.getLogVersion() ? logHeader.getPreviousLogFileChecksum() : this.getPrevChecksumFromPosition(logPosition, logFiles);
                    Assertions.assertThat((int)logChannel.previousChecksum()).isEqualTo(expectedChecksum);
                    Assertions.assertThat((Comparable)logChannel.kernelVersion()).isEqualTo((Object)logHeader.getKernelVersion());
                    ++logVersion;
                }
            }
        }
    }

    @Test
    void setsPreviousChecksumCorrectlyForNonEnvelopedLogs() throws IOException {
        Path directory = this.testDirectory.directory("home-dir2");
        try (DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(directory).setConfig(Map.of(GraphDatabaseInternalSettings.latest_kernel_version, LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES.version(), GraphDatabaseInternalSettings.latest_runtime_version, LatestVersions.LATEST_RUNTIME_VERSION_WITHOUT_ENVELOPES.getVersion(), GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, false)).build();){
            GraphDatabaseAPI database = (GraphDatabaseAPI)dbms.database("neo4j");
            String propertyValue = RandomStringUtils.randomAscii((int)((int)THRESHOLD / 16));
            int numberOfTransactions = 35;
            for (int i = 0; i < numberOfTransactions; ++i) {
                try (Transaction tx = database.beginTx();){
                    Node node = tx.createNode();
                    node.setProperty("a", (Object)propertyValue);
                    tx.commit();
                    continue;
                }
            }
            TransactionLogService logService = (TransactionLogService)database.getDependencyResolver().resolveDependency(TransactionLogService.class);
            int initialAppendIndex = 17;
            try (TransactionLogChannels logReaders = logService.logFilesChannels((long)initialAppendIndex);){
                List logFileChannels = logReaders.getChannels();
                Assertions.assertThat((List)logFileChannels).hasSize(3);
                boolean first = true;
                for (LogChannel logChannel : logFileChannels) {
                    int expectedChecksum = first ? 1 : -559063315;
                    Assertions.assertThat((int)logChannel.previousChecksum()).isEqualTo(expectedChecksum);
                    first = false;
                }
            }
        }
    }

    int getPrevChecksumFromPosition(LogPosition logPosition, LogFiles logFiles) throws IOException {
        try (ReadableLogChannel reader = logFiles.getLogFile().getReader(logPosition);){
            int n = reader.getChecksum();
            return n;
        }
    }

    @Test
    void restoreRequireNonAvailableDatabase() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.logService.restore(LogPosition.UNSPECIFIED));
    }

    @Test
    void failToRestoreWithLogPositionInHigherLogFile() {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.logService.restore(new LogPosition(this.metadataProvider.getCurrentLogVersion() + 5L, 100L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Log position requested for restore points to the log file that is higher than existing available highest log file. Requested restore position: LogPosition{logVersion=5, byteOffset=100}, current log file version: 0.");
    }

    @Test
    void failToRestoreWithLogPositionInCommittedFile() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        LogFile logFile = this.logFiles.getLogFile();
        logFile.rotate();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.logService.restore(new LogPosition(this.metadataProvider.getCurrentLogVersion() - 1L, 100L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Log position requested to be used for restore belongs to the log file that was already appended by transaction and cannot be restored.").hasMessageContaining("requested restore: LogPosition{logVersion=0, byteOffset=100}");
    }

    @Test
    void failToAppendCheckpointOnAvailableDatabase() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.logService.appendCheckpoint(TransactionIdStore.UNKNOWN_TRANSACTION_ID, 0L, "Test"));
    }

    @Test
    void checkpointAtEndOfFileWhenAppendingToLastAvailableTransaction() throws IOException {
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        TransactionId lastTransactionId = this.metadataProvider.getLastCommittedTransaction();
        String testReason = "Should checkpoint at end of file";
        LogPosition eofPosition = this.findEndOfFile(lastTransactionId.id());
        this.logService.appendCheckpoint(lastTransactionId, lastTransactionId.appendIndex(), testReason);
        CheckpointInfo checkpointInfo = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        Assertions.assertThat((String)checkpointInfo.reason()).contains(new CharSequence[]{testReason});
        LogTailInformation freshTail = this.getFreshLogTail();
        Assertions.assertThat((Object)lastTransactionId).isEqualTo((Object)freshTail.getLastCommittedTransaction());
        Assertions.assertThat((Comparable)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow()).transactionLogPosition()).isEqualTo((Object)eofPosition);
        Assertions.assertThat((Object)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow())).isEqualTo((Object)checkpointInfo);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)freshTail.hasRecordsToRecover()).describedAs("There should not be any commits after the checkpoint." + String.valueOf(freshTail), new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)freshTail.isRecoveryRequired()).describedAs("Recovery should not be required. " + String.valueOf(freshTail), new Object[0])).isFalse();
    }

    @Test
    void appendCheckpointForNotTheLastAvailableTransaction() throws IOException {
        TransactionId lastTransactionId = this.metadataProvider.getLastCommittedTransaction();
        this.createNodeInIsolatedTransaction("foo");
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        String testReason = "My unique last checkpoint2.";
        this.logService.appendCheckpoint(lastTransactionId, lastTransactionId.appendIndex(), testReason);
        CheckpointInfo checkpointInfo = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        Assertions.assertThat((String)checkpointInfo.reason()).contains(new CharSequence[]{testReason});
        LogTailInformation freshTail = this.getFreshLogTail();
        Assertions.assertThat((Object)lastTransactionId).isEqualTo((Object)freshTail.getLastCommittedTransaction());
        Assertions.assertThat((Object)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow())).isEqualTo((Object)checkpointInfo);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)freshTail.hasRecordsToRecover()).describedAs("There should be new commits after the checkpoint." + String.valueOf(freshTail), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)freshTail.isRecoveryRequired()).describedAs("Recovery should be required. " + String.valueOf(freshTail), new Object[0])).isTrue();
        ((AbstractLongAssert)Assertions.assertThat((long)freshTail.firstAppendIndexAfterLastCheckPoint).describedAs("Transaction id after should be right after checkpointed tx id.", new Object[0])).isEqualTo(lastTransactionId.id() + 1L);
    }

    @Test
    void checkpointAtEndOfFileWhenLogFileIsEmpty() throws IOException {
        for (int i = 0; i < 10; ++i) {
            this.createNodeInIsolatedTransaction("foo");
        }
        TransactionId lastTransactionId = this.metadataProvider.getLastCommittedTransaction();
        LogFile logFile = this.logFiles.getLogFile();
        long logVersion = logFile.getCurrentLogVersion();
        logFile.rotate();
        while (logFile.versionExists(logVersion)) {
            Path file = logFile.getLogFileForVersion(logVersion);
            this.fs.deleteFile(file);
            --logVersion;
        }
        long highestVersion = logFile.getLogRangeInfo().highestVersion();
        LogPosition eofPosition = new LogPosition(highestVersion, logFile.extractHeader(highestVersion).getStartPosition().getByteOffset());
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        String testReason = "Checkpoint on empty log files should work since its full story copy.";
        this.logService.appendCheckpoint(lastTransactionId, lastTransactionId.appendIndex(), testReason);
        LogTailInformation freshTail = this.getFreshLogTail();
        Assertions.assertThat((Object)lastTransactionId).isEqualTo((Object)freshTail.getLastCommittedTransaction());
        Assertions.assertThat((Comparable)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow()).transactionLogPosition()).isEqualTo((Object)eofPosition);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)freshTail.hasRecordsToRecover()).describedAs("There should not be any commits after the checkpoint." + String.valueOf(freshTail), new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)freshTail.isRecoveryRequired()).describedAs("Recovery should not be required. " + String.valueOf(freshTail), new Object[0])).isFalse();
    }

    @Test
    void checkpointAtEndOfFileWhenTransactionIsRotatedOut() throws IOException {
        for (int i = 0; i < 10; ++i) {
            this.createNodeInIsolatedTransaction("foo");
        }
        TransactionId lastTransactionId = this.metadataProvider.getLastCommittedTransaction();
        LogFile logFile = this.logFiles.getLogFile();
        long logVersion = logFile.getCurrentLogVersion();
        logFile.rotate();
        logFile.rotate();
        while (logFile.versionExists(logVersion)) {
            Path file = logFile.getLogFileForVersion(logVersion);
            this.fs.deleteFile(file);
            --logVersion;
        }
        long highestVersion = logFile.getLogRangeInfo().highestVersion();
        LogPosition eofPosition = new LogPosition(highestVersion, logFile.extractHeader(highestVersion).getStartPosition().getByteOffset());
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        String testReason = "Checkpoint at EOF when tx is rotated out";
        this.logService.appendCheckpoint(lastTransactionId, lastTransactionId.appendIndex(), testReason);
        CheckpointInfo checkpointInfo = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        Assertions.assertThat((String)checkpointInfo.reason()).contains(new CharSequence[]{testReason});
        LogTailInformation freshTail = this.getFreshLogTail();
        Assertions.assertThat((Object)lastTransactionId).isEqualTo((Object)freshTail.getLastCommittedTransaction());
        Assertions.assertThat((Object)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow())).isEqualTo((Object)checkpointInfo);
        Assertions.assertThat((Comparable)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow()).transactionLogPosition()).isEqualTo((Object)eofPosition);
    }

    @Test
    void findTransactionPositionWhenInPreviousLogFile() throws IOException {
        for (int i = 0; i < 10; ++i) {
            this.createNodeInIsolatedTransaction("foo");
        }
        TransactionId lastTransactionId = this.metadataProvider.getLastCommittedTransaction();
        LogFile logFile = this.logFiles.getLogFile();
        logFile.rotate();
        for (int i = 0; i < 10; ++i) {
            this.createNodeInIsolatedTransaction("foo");
        }
        logFile.rotate();
        LogPosition expectedPosition = this.findEndOfTransaction(lastTransactionId.id());
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        String testReason = "Find position for tx even when it has been rotated";
        this.logService.appendCheckpoint(lastTransactionId, lastTransactionId.appendIndex(), testReason);
        CheckpointInfo checkpointInfo = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        Assertions.assertThat((String)checkpointInfo.reason()).contains(new CharSequence[]{testReason});
        LogTailInformation freshTail = this.getFreshLogTail();
        Assertions.assertThat((Object)lastTransactionId).isEqualTo((Object)freshTail.getLastCommittedTransaction());
        Assertions.assertThat((Object)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow())).isEqualTo((Object)checkpointInfo);
        Assertions.assertThat((Comparable)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow()).transactionLogPosition()).isEqualTo((Object)expectedPosition);
    }

    @Test
    void checkpointAtEndOfFileWhenTransactionDoesntExist() throws IOException {
        for (int i = 0; i < 10; ++i) {
            this.createNodeInIsolatedTransaction("foo");
        }
        TransactionId lastTransactionId = this.metadataProvider.getLastCommittedTransaction();
        LogPosition eofPosition = this.findEndOfFile(lastTransactionId.id());
        this.availabilityGuard.require((AvailabilityRequirement)new DescriptiveAvailabilityRequirement("Database unavailable"));
        String testReason = "Checkpoint at end of file when tx doesn't exist";
        TransactionId transactionId = new TransactionId(789L, 798L, LatestVersions.LATEST_KERNEL_VERSION, 7, 8L, 9L);
        this.logService.appendCheckpoint(transactionId, transactionId.appendIndex(), testReason);
        CheckpointInfo checkpointInfo = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        Assertions.assertThat((String)checkpointInfo.reason()).contains(new CharSequence[]{testReason});
        LogTailInformation freshTail = this.getFreshLogTail();
        Assertions.assertThat((Object)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow())).isEqualTo((Object)checkpointInfo);
        Assertions.assertThat((Comparable)((CheckpointInfo)freshTail.getLastCheckPoint().orElseThrow()).transactionLogPosition()).isEqualTo((Object)eofPosition);
    }

    private static ByteBuffer createBuffer() {
        return ByteBuffers.allocateDirect((int)((int)(THRESHOLD << 1)), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private LogPosition findEndOfTransaction(long txId) throws IOException {
        try (CommandBatchCursor cursor = this.transactionStore.getCommandBatches(txId + 1L);){
            LogPosition logPosition = cursor.position();
            return logPosition;
        }
    }

    private LogPosition findEndOfFile(long txId) throws IOException {
        try (CommandBatchCursor cursor = this.transactionStore.getCommandBatches(txId);){
            while (cursor.next()) {
            }
            LogPosition logPosition = cursor.position();
            return logPosition;
        }
    }

    private LogTailInformation getFreshLogTail() {
        return ((CheckpointLogFile)this.logFiles.getCheckpointFile()).getLogTailScanner().findLogTail();
    }

    private long getTxStartOffset(long txId) throws IOException {
        try (CommandBatchCursor commandBatches = this.transactionStore.getCommandBatches(txId);){
            long l = commandBatches.position().getByteOffset();
            return l;
        }
    }

    private long getTxEndOffset(long txId) throws IOException {
        try (CommandBatchCursor commandBatches = this.transactionStore.getCommandBatches(txId);){
            commandBatches.next();
            long l = commandBatches.position().getByteOffset();
            return l;
        }
    }

    private void verifyReportedPositions(int txId, long expectedOffset) throws IOException {
        try (TransactionLogChannels logReaders = this.logService.logFilesChannels((long)txId);){
            List logFileChannels = logReaders.getChannels();
            Assertions.assertThat((List)logFileChannels).hasSize(1);
            org.junit.jupiter.api.Assertions.assertEquals((long)expectedOffset, (long)((LogChannel)logFileChannels.get(0)).channel().position());
        }
    }

    private void createNodeInIsolatedTransaction(String propertyValue) {
        try (Transaction tx = this.databaseAPI.beginTx();){
            Node node = tx.createNode();
            node.setProperty("a", (Object)propertyValue);
            tx.commit();
        }
    }

    private static void checkChannelsCoverage(List<LogChannel> channels, long expectedFirstIndex, long expectedLastAppendIndex) {
        LongRange totalRange = null;
        for (LogChannel channel : channels) {
            LongRange channelRange = LongRange.range((long)channel.startAppendIndex(), (long)channel.lastAppendIndex());
            if (totalRange == null) {
                totalRange = channelRange;
                continue;
            }
            if (channelRange == LongRange.EMPTY_RANGE) {
                Assertions.assertThat((Object)channel).isNotEqualTo((Object)channels.getFirst());
                Assertions.assertThat((long)channel.startAppendIndex()).isEqualTo(channel.lastAppendIndex() + 1L);
                continue;
            }
            totalRange = LongRange.join((LongRange)totalRange, (LongRange)channelRange);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedFirstIndex, (long)totalRange.from());
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedLastAppendIndex, (long)totalRange.to());
    }

    public static class InjectableBeforeApplyTracers
    implements Tracers {
        public PageCacheTracer getPageCacheTracer() {
            return PageCacheTracer.NULL;
        }

        public LockTracer getLockTracer() {
            return LockTracer.NONE;
        }

        public DatabaseTracer getDatabaseTracer(NamedDatabaseId namedDatabaseId) {
            return new InjectableBeforeApplyDatabaseTracer();
        }

        public VersionStorageTracer getVersionStorageTracer(NamedDatabaseId namedDatabaseId) {
            return VersionStorageTracer.NULL;
        }

        private static class InjectableBeforeApplyDatabaseTracer
        extends DefaultDatabaseTracer {
            public InjectableBeforeApplyDatabaseTracer() {
                super(PageCacheTracer.NULL);
            }

            public TransactionEvent beginTransaction(CursorContext cursorContext, long transactionSequenceNumber) {
                return new InjectableBeforeApplyTransactionEvent();
            }
        }

        private static class InjectableBeforeApplyTransactionEvent
        implements TransactionEvent {
            private InjectableBeforeApplyTransactionEvent() {
            }

            public void setCommit(boolean commit) {
            }

            public void setRollback(boolean rollback) {
            }

            public TransactionWriteEvent beginCommitEvent() {
                return InjectableBeforeApplyTxWriteEvent.INSTANCE;
            }

            public TransactionWriteEvent beginChunkWriteEvent() {
                return InjectableBeforeApplyTxWriteEvent.INSTANCE;
            }

            public TransactionRollbackEvent beginRollback() {
                return TransactionRollbackEvent.NULL;
            }

            public void close() {
            }

            public void setTransactionWriteState(String transactionWriteState) {
            }

            public void setReadOnly(boolean wasReadOnly) {
            }

            public void refreshVisibilityBoundary() {
            }
        }

        private static class InjectableBeforeApplyTxWriteEvent
        implements TransactionWriteEvent {
            public static final InjectableBeforeApplyTxWriteEvent INSTANCE = new InjectableBeforeApplyTxWriteEvent();
            private final AtomicReference<Runnable> beforeStoreApply = new AtomicReference();

            private InjectableBeforeApplyTxWriteEvent() {
            }

            public void close() {
            }

            public LogAppendEvent beginLogAppend() {
                return LogAppendEvent.NULL;
            }

            public StoreApplyEvent beginStoreApply() {
                Runnable beforeStoreApplyRunnable = this.beforeStoreApply.getAndSet(null);
                if (beforeStoreApplyRunnable != null) {
                    beforeStoreApplyRunnable.run();
                }
                return StoreApplyEvent.NULL;
            }

            public void chunkAppended(int chunkNumber, long transactionSequenceNumber, long transactionId) {
            }
        }
    }

    private static class BulkAppendLogRotationMonitor
    extends LogRotationMonitorAdapter {
        private final List<Long> versions = new CopyOnWriteArrayList<Long>();

        private BulkAppendLogRotationMonitor() {
        }

        public void finishLogRotation(Path logFile, LogRotationMonitor.LogType type, long logVersion, LogHeader logHeader, long lastAppendIndex, long rotationMillis, long millisSinceLastRotation) {
            this.versions.add(logVersion);
        }

        public List<Long> getObservedVersions() {
            return this.versions;
        }
    }
}

