/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import org.mockito.Mockito;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EmptyDependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.DefaultReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.SpecialisedIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.index.schema.TokenIndexProviderFactory;
import org.neo4j.monitoring.Monitors;

class TokenIndexProviderCompatibilitySuiteTest
extends SpecialisedIndexProviderCompatibilityTestSuite {
    TokenIndexProviderCompatibilitySuiteTest() {
    }

    @Override
    IndexPrototype indexPrototype() {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR);
    }

    @Override
    IndexType indexType() {
        return IndexType.LOOKUP;
    }

    @Override
    IndexProvider createIndexProvider(PageCache pageCache, FileSystemAbstraction fs, Path graphDbDir, Config config) {
        Monitors monitors = new Monitors();
        String monitorTag = "";
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)graphDbDir);
        NamedDatabaseId defaultDatabaseId = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
        ConfigBasedLookupFactory.DatabaseIdResolver databaseIdResolver = (ConfigBasedLookupFactory.DatabaseIdResolver)Mockito.mock(ConfigBasedLookupFactory.DatabaseIdResolver.class);
        Mockito.when((Object)databaseIdResolver.resolve("neo4j")).thenReturn(Optional.of(defaultDatabaseId.databaseId()));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdResolver);
        DefaultReadOnlyDatabases readOnlyDatabases = new DefaultReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        DatabaseReadOnlyChecker readOnlyChecker = readOnlyDatabases.forDatabase(defaultDatabaseId);
        return TokenIndexProviderFactory.create((PageCache)pageCache, (Path)graphDbDir, (FileSystemAbstraction)fs, (Monitors)monitors, (String)monitorTag, (DatabaseReadOnlyChecker)readOnlyChecker, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector, (DatabaseLayout)databaseLayout, (CursorContextFactory)CursorContextFactory.NULL_CONTEXT_FACTORY, (PageCacheTracer)PageCacheTracer.NULL, (DependencyResolver)EmptyDependencyResolver.EMPTY_RESOLVER);
    }
}

