/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class ListComponentsProcedureIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private final String kernelVersion = "5.27.0";

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.custom_kernel_version, (Object)"5.27.0");
    }

    @ExtensionCallback
    void configureEnableCypherVersions(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.custom_kernel_version, (Object)"5.27.0");
        builder.setConfig(GraphDatabaseInternalSettings.enable_experimental_cypher_versions, (Object)true);
    }

    @Test
    void shouldReturnConfiguredKernelVersion() {
        List components;
        try (Transaction tx = this.databaseAPI.beginTx();){
            Result result = tx.execute("CALL dbms.components()");
            components = result.stream().toList();
            tx.commit();
        }
        Assertions.assertThat(components).isNotEmpty();
        Optional<Map> kernelComponent = components.stream().filter(this::isKernelComponent).findAny();
        Assertions.assertThat(kernelComponent).isPresent();
        Object version = kernelComponent.get().get("versions");
        Assertions.assertThat(version).isEqualTo(List.of("5.27.0"));
    }

    @Test
    void shouldReturnCypherVersions5Only() {
        List components;
        try (Transaction tx = this.databaseAPI.beginTx();){
            Result result = tx.execute("CALL dbms.components()");
            components = result.stream().toList();
            tx.commit();
        }
        Assertions.assertThat(components).isNotEmpty();
        Optional<Map> cypherComponent = components.stream().filter(this::isCypherComponent).findAny();
        Assertions.assertThat(cypherComponent).isPresent();
        Object version = cypherComponent.get().get("versions");
        Assertions.assertThat(version).isEqualTo(List.of("5", "25"));
    }

    @DbmsExtension(configurationCallback="configureEnableCypherVersions")
    @Test
    void shouldReturnCypherVersions5And25() {
        List components;
        try (Transaction tx = this.databaseAPI.beginTx();){
            Result result = tx.execute("CALL dbms.components()");
            components = result.stream().toList();
            tx.commit();
        }
        Assertions.assertThat(components).isNotEmpty();
        Optional<Map> cypherComponent = components.stream().filter(this::isCypherComponent).findAny();
        Assertions.assertThat(cypherComponent).isPresent();
        Object version = cypherComponent.get().get("versions");
        Assertions.assertThat(version).isEqualTo(List.of("5", "25"));
    }

    private boolean isKernelComponent(Map<String, Object> component) {
        return component.get("name").equals("Neo4j Kernel");
    }

    private boolean isCypherComponent(Map<String, Object> component) {
        return component.get("name").equals("Cypher");
    }
}

