/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SkipOnSpd;

@DbmsExtension
public class DatabaseMemoryPoolsIT {
    @Inject
    private MemoryPools memoryPools;
    @Inject
    private GraphDatabaseService db;

    @SkipOnSpd(reason="Page cache tracing works differently in SPD")
    @Test
    void trackDatabaseNativeByteBuffersUsage() {
        GlobalMemoryGroupTracker otherGlobalPool = this.memoryPools.getPools().stream().filter(pool -> MemoryGroup.OTHER == pool.group()).findFirst().orElseThrow();
        Assertions.assertThat((long)otherGlobalPool.usedNative()).isGreaterThan(0L);
        List databasePools = otherGlobalPool.getDatabasePools();
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)databasePools).hasSize(2)).anyMatch(pool -> "system".equals(pool.databaseName()))).anyMatch(pool -> this.db.databaseName().equals(pool.databaseName()))).allMatch(pool -> pool.usedNative() > 0L);
    }
}

