/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionFailureHelper;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.TxLogValidationUtils;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.Barrier;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class TransactionLogsUpgradeIT {
    @Inject
    protected DefaultFileSystemAbstraction fileSystem;
    @Inject
    private Neo4jLayout neo4jLayout;
    protected DatabaseManagementService managementService;
    protected GraphDatabaseAPI testDb;
    protected CommandReaderFactory commandReaderFactory;
    private static final KernelVersion EXPECTED_HEADER_VERSION_LATEST_FORMAT = LatestVersions.LATEST_KERNEL_VERSION.isAtLeast(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_GUARANTEED) ? LatestVersions.LATEST_KERNEL_VERSION : null;

    TransactionLogsUpgradeIT() {
    }

    protected TestDatabaseManagementServiceBuilder configureStartUp(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)((long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 3L));
        builder.setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)false);
        return builder;
    }

    protected KernelVersion headerVersionForStartingVersion() {
        return EXPECTED_HEADER_VERSION_LATEST_FORMAT;
    }

    protected KernelVersion startingKernelVersion() {
        return LatestVersions.LATEST_KERNEL_VERSION;
    }

    @BeforeEach
    void setUp() {
        this.startDbms(this::configureStartUp);
        this.commandReaderFactory = ((StorageEngineFactory)((GraphDatabaseAPI)this.managementService.database("neo4j")).getDependencyResolver().resolveDependency(StorageEngineFactory.class)).commandReaderFactory();
    }

    @AfterEach
    void tearDown() {
        this.shutdownDbms();
    }

    protected TestDatabaseManagementServiceBuilder configureGloriousFutureAsLatest(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()).setConfig(GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, (Object)true);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldRotateOnKernelVersionChangeAndGetCorrectInfoInLogHeader(boolean useQueueAppender) throws Exception {
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)this.startingKernelVersion());
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)this.testDb, (KernelVersion)this.startingKernelVersion(), (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        long firstNewTransaction = ((TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)0L, (KernelVersion)this.headerVersionForStartingVersion(), (long)1L);
        AtomicInteger latestChecksum = new AtomicInteger();
        TxLogValidationUtils.assertWholeTransactionsIn((LogFile)logFiles.getLogFile(), (long)0L, startEntry -> {}, commitEntry -> latestChecksum.set(commitEntry.getChecksum()), (CommandReaderFactory)this.commandReaderFactory);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)logFiles.getLogFile().getLogRangeInfo().highestVersion(), (KernelVersion)KernelVersion.GLORIOUS_FUTURE, (long)(firstNewTransaction - 1L), (int)latestChecksum.get());
        TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)0L, (KernelVersion)this.startingKernelVersion(), (int)((int)(firstNewTransaction - 1L - 1L)), (CommandReaderFactory)this.commandReaderFactory);
        TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)1L, (KernelVersion)KernelVersion.GLORIOUS_FUTURE, (int)1, (CommandReaderFactory)this.commandReaderFactory);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldRotateToNewFileWhenUpgradeTxIsLastOnStartup(boolean useQueueAppender) throws Exception {
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        TransactionIdStore transactionIdStore = (TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        long lastClosedTransactionIdBeforeUpgrade = transactionIdStore.getLastClosedTransactionId();
        long numNodesBefore = this.getNodeCount(this.testDb);
        this.managementService.registerTransactionEventListener("neo4j", (TransactionEventListener)new InternalTransactionEventListener.Adapter<Object>(this){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
                if (data.metaData().containsKey("triggerTx")) {
                    throw TransactionFailureHelper.internalError((String)"Transaction log upgrade", (String)"Failed because you asked for it", (Status)Status.Transaction.TransactionHookFailed);
                }
                return null;
            }
        });
        UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.managementService);
        GraphDatabaseAPI finalTestDb = this.testDb;
        Assertions.assertThatThrownBy(() -> {
            try (TransactionImpl tx = (TransactionImpl)finalTestDb.beginTx();){
                tx.setMetaData(Map.of("triggerTx", "something"));
                tx.createNode();
                tx.commit();
            }
        }).isInstanceOf(TransactionFailureException.class);
        ((AbstractLongAssert)Assertions.assertThat((long)this.getNodeCount(this.testDb)).as("Triggering transaction succeeded when it should fail", new Object[0])).isEqualTo(numNodesBefore);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        LogPosition positionAfterUpgrade = transactionIdStore.getLastClosedTransaction().logPosition();
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)0L, (KernelVersion)this.headerVersionForStartingVersion(), (long)1L);
        AtomicInteger latestChecksum = new AtomicInteger();
        int nbrTxs = TxLogValidationUtils.assertWholeTransactionsIn((LogFile)logFiles.getLogFile(), (long)0L, startEntry -> Assertions.assertThat((Comparable)startEntry.kernelVersion()).isEqualTo((Object)this.startingKernelVersion()), commitEntry -> latestChecksum.set(commitEntry.getChecksum()), (CommandReaderFactory)this.commandReaderFactory);
        Assertions.assertThat((int)nbrTxs).isEqualTo((int)(lastClosedTransactionIdBeforeUpgrade - 1L + 1L));
        Assertions.assertThat((long)this.fileSystem.getFileSize(logFiles.getLogFile().getLogFileForVersion(0L))).isEqualTo(positionAfterUpgrade.getByteOffset());
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)1L, (KernelVersion)KernelVersion.GLORIOUS_FUTURE, (long)(lastClosedTransactionIdBeforeUpgrade + 1L), (int)latestChecksum.get());
        TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)1L, (KernelVersion)KernelVersion.GLORIOUS_FUTURE, (int)1, (CommandReaderFactory)this.commandReaderFactory);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void makeCleanRotationOnVersionChange(boolean useQueueAppender) throws Throwable {
        int nbrTxsPerContestant = 10;
        int nbrContestants = 5;
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        long txsBefore = ((TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId() - 1L;
        Barrier.Control atLeastOneTxDoneBeforeAfter = new Barrier.Control();
        Race race = new Race();
        race.addContestant(() -> {
            UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
            atLeastOneTxDoneBeforeAfter.reached();
            UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        }, 1);
        race.addContestants(nbrContestants, () -> {
            for (int i = 0; i < nbrTxsPerContestant; ++i) {
                UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
            }
        }, 1);
        race.addContestant(Race.throwing(() -> {
            atLeastOneTxDoneBeforeAfter.await();
            UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.managementService);
            atLeastOneTxDoneBeforeAfter.release();
        }), 1);
        race.go();
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)0L, (KernelVersion)this.headerVersionForStartingVersion(), (long)1L);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)logFiles.getLogFile().getLogRangeInfo().highestVersion(), (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        int nbrTxsIn0 = TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)0L, (KernelVersion)this.startingKernelVersion(), (CommandReaderFactory)this.commandReaderFactory);
        Assertions.assertThat((int)nbrTxsIn0).isGreaterThanOrEqualTo(2);
        int nbrTxsIn1 = TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)1L, (KernelVersion)KernelVersion.GLORIOUS_FUTURE, (CommandReaderFactory)this.commandReaderFactory);
        Assertions.assertThat((int)nbrTxsIn1).isGreaterThanOrEqualTo(1);
        Assertions.assertThat((int)(nbrTxsIn0 + nbrTxsIn1)).isEqualTo((long)(nbrContestants * nbrTxsPerContestant + 2 + 1) + txsBefore);
    }

    protected long getNodeCount(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            long l = Iterables.count((Iterable)tx.getAllNodes());
            return l;
        }
    }

    protected void startDbms(Configuration configuration) {
        this.managementService = configuration.configure(new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false)).build();
        this.testDb = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    protected void shutdownDbms() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    @FunctionalInterface
    static interface Configuration {
        public TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder var1);
    }
}

