/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectAssertions;
import org.neo4j.gqlstatus.GqlExceptionLikeAssert;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.util.concurrent.Futures;

@DbmsExtension(configurationCallback="configure")
public class KernelTransactionTimeoutMonitorIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private KernelTransactions kernelTransactions;
    private static final int NODE_ID = 0;
    private ExecutorService executor;

    @ExtensionCallback
    protected void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.transaction_monitor_check_interval, (Object)Duration.ofMillis(100L));
    }

    @BeforeEach
    void setUp() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @AfterEach
    void tearDown() {
        this.executor.shutdown();
    }

    @Test
    @Timeout(value=30L)
    void terminatingTransactionMustEagerlyReleaseTheirLocks() throws Exception {
        boolean proceed;
        long nodeId;
        AtomicBoolean nodeLockAcquired = new AtomicBoolean();
        AtomicBoolean lockerDone = new AtomicBoolean();
        BinaryLatch lockerPause = new BinaryLatch();
        try (Transaction tx = this.database.beginTx();){
            nodeId = tx.createNode().getId();
            tx.commit();
        }
        Future<?> locker = this.executor.submit(() -> {
            try (Transaction tx = this.database.beginTx();){
                Node node = tx.getNodeById(nodeId);
                tx.acquireReadLock((Entity)node);
                nodeLockAcquired.set(true);
                lockerPause.await();
            }
            lockerDone.set(true);
        });
        while (!(proceed = nodeLockAcquired.get())) {
        }
        this.terminateOngoingTransaction();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lockerDone.get());
        try (Transaction tx = this.database.beginTx();){
            tx.acquireWriteLock((Entity)tx.getNodeById(nodeId));
            tx.commit();
        }
        lockerPause.release();
        locker.get();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)lockerDone.get());
    }

    @Timeout(value=30L)
    @Test
    void terminateExpiredTransaction() {
        try (Transaction transaction = this.database.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
        Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction transaction = this.database.beginTx();){
                Node nodeById = transaction.getNodeById(0L);
                nodeById.setProperty("a", (Object)"b");
                this.executor.submit(this.startAnotherTransaction()).get();
            }
        });
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"The transaction has been terminated."});
        Assertions.assertThat((Throwable)exception.getCause()).isInstanceOf(LockClientStoppedException.class);
        LockClientStoppedException gqlException = (LockClientStoppedException)exception.getCause();
        ((GqlExceptionLikeAssert)ErrorGqlStatusObjectAssertions.assertThat((Exception)gqlException).hasGqlStatus(GqlStatusInfoCodes.STATUS_25N14)).hasStatusDescriptionContaining("error: invalid transaction state - transaction termination client error. The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Reason: The transaction has been terminated, so no more locks can be acquired. This can occur because the transaction ran longer than the configured transaction timeout, or because a human operator manually terminated the transaction, or because the database is shutting down.");
    }

    @Test
    void concurrentTransactionAndSnapshotCreation() throws ExecutionException, InterruptedException {
        int numberOfExecutors = 40;
        try (ExecutorService txExecutors = Executors.newFixedThreadPool(numberOfExecutors);
             ExecutorService monitorThread = Executors.newSingleThreadExecutor();){
            CountDownLatch startLatch = new CountDownLatch(1);
            ArrayList transactionFutures = new ArrayList(numberOfExecutors);
            TestTransactionMonitor transactionMonitor = new TestTransactionMonitor((KernelTransactions)this.database.getDependencyResolver().resolveDependency(KernelTransactions.class));
            Future<?> monitorFuture = monitorThread.submit(transactionMonitor);
            transactionFutures.add(txExecutors.submit(() -> {
                try {
                    startLatch.await();
                    for (int i = 0; i < 1000; ++i) {
                        try (Transaction transaction = this.database.beginTx();){
                            Node start = transaction.createNode();
                            Node end = transaction.createNode();
                            start.createRelationshipTo(end, RelationshipType.withName((String)"any"));
                            transaction.commit();
                            continue;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }));
            startLatch.countDown();
            Futures.getAll(transactionFutures);
            transactionMonitor.terminate();
            monitorFuture.get();
        }
    }

    private void terminateOngoingTransaction() {
        Set kernelTransactionHandles = this.kernelTransactions.activeTransactions();
        Assertions.assertThat((Collection)kernelTransactionHandles).hasSize(1);
        for (KernelTransactionHandle kernelTransactionHandle : kernelTransactionHandles) {
            kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated);
        }
    }

    private Runnable startAnotherTransaction() {
        return () -> {
            try (InternalTransaction tx = this.database.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 1L, TimeUnit.SECONDS);){
                Node node = tx.getNodeById(0L);
                node.setProperty("c", (Object)"d");
            }
        };
    }

    private static class TestTransactionMonitor
    implements Runnable {
        private final KernelTransactions transactions;
        private volatile boolean terminated;

        public TestTransactionMonitor(KernelTransactions transactions) {
            this.transactions = transactions;
        }

        @Override
        public void run() {
            while (!this.terminated) {
                Set activeTransactions = this.transactions.activeTransactions();
                for (KernelTransactionHandle activeTransaction : activeTransactions) {
                    Assertions.assertThat((long)activeTransaction.getTransactionHorizon()).isGreaterThan(1L);
                    Assertions.assertThat((long)activeTransaction.getLastClosedTxId()).isGreaterThan(1L);
                }
            }
        }

        public void terminate() {
            this.terminated = true;
        }
    }
}

