/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SkipOnSpd;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralNeo4jLayoutExtension
@SkipOnSpd
class IndexRecoveryIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private EphemeralFileSystemAbstraction fs;
    private GraphDatabaseAPI db;
    private final IndexProvider mockedIndexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final ExtensionFactory<?> mockedIndexProviderFactory = SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.getKey(), (IndexProvider)this.mockedIndexProvider);
    private final String key = "number_of_bananas_owned";
    private final Label myLabel = Label.label((String)"MyLabel");
    private final Monitors monitors = new Monitors();
    private DatabaseManagementService managementService;
    private ExecutorService executor;
    private final Object lock = new Object();

    IndexRecoveryIT() {
    }

    @BeforeEach
    void setUp() {
        this.executor = Executors.newSingleThreadExecutor();
        Mockito.when((Object)this.mockedIndexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.mockedIndexProvider.getMinimumRequiredVersion()).thenReturn((Object)KernelVersion.EARLIEST);
        Mockito.when((Object)this.mockedIndexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class), (PageCacheTracer)ArgumentMatchers.any(), (StorageEngineFactory)ArgumentMatchers.any(), (CursorContextFactory)ArgumentMatchers.any())).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Mockito.when((Object)this.mockedIndexProvider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).then(inv -> inv.getArgument(0));
        Mockito.when((Object)this.mockedIndexProvider.getIndexType()).thenReturn((Object)IndexType.LOOKUP);
        Mockito.when((Object)this.mockedIndexProvider.validatePrototype((IndexPrototype)ArgumentMatchers.any(IndexPrototype.class))).thenAnswer(i -> i.getArguments()[0]);
    }

    @AfterEach
    void after() {
        this.executor.shutdown();
        if (this.db != null) {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndexWhereLogHasRotated() throws Exception {
        Future<Void> killFuture;
        this.startDb();
        Semaphore populationSemaphore = new Semaphore(0);
        try {
            Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)IndexRecoveryIT.indexPopulatorWithControlledCompletionTiming(populationSemaphore));
            this.createSomeData();
            this.createIndex();
            killFuture = this.killDbInSeparateThread();
            this.rotateLogsAndCheckPoint();
        }
        finally {
            populationSemaphore.release();
        }
        killFuture.get();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        Semaphore recoverySemaphore = new Semaphore(0);
        try {
            Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)IndexRecoveryIT.indexPopulatorWithControlledCompletionTiming(recoverySemaphore));
            MinimalIndexAccessor minimalIndexAccessor = (MinimalIndexAccessor)Mockito.mock(MinimalIndexAccessor.class);
            Mockito.when((Object)this.mockedIndexProvider.getMinimalIndexAccessor((IndexDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)minimalIndexAccessor);
            boolean recoveryRequired = Recovery.isRecoveryRequired((FileSystemAbstraction)this.fs, (DatabaseLayout)this.databaseLayout, (Config)Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.monitors.addMonitorListener((Object)new MyRecoveryMonitor(recoverySemaphore), new String[0]);
            this.startDb();
            try (Transaction transaction = this.db.beginTx();){
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.POPULATING});
            }
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)(recoveryRequired ? 3 : 2)))).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.never())).getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)(recoveryRequired ? 2 : 1)))).getMinimalIndexAccessor((IndexDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
            ((MinimalIndexAccessor)Mockito.verify((Object)minimalIndexAccessor, (VerificationMode)Mockito.times((int)(recoveryRequired ? 2 : 1)))).drop();
        }
        finally {
            recoverySemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndex() throws Exception {
        this.startDb();
        Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)new IndexPopulator.Adapter(this){

            public void create() {
                throw new RuntimeException("Make sure index is not in online mode");
            }
        });
        this.createSomeData();
        this.createIndex();
        this.killDb();
        ((IndexProvider)Mockito.doReturn((Object)InternalIndexState.POPULATING).when((Object)this.mockedIndexProvider)).getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any());
        final Semaphore recoverySemaphore = new Semaphore(1);
        RecoveryMonitor drainingMonitor = new RecoveryMonitor(){

            public void recoveryCompleted() {
                recoverySemaphore.drainPermits();
            }
        };
        this.monitors.addMonitorListener((Object)drainingMonitor, new String[0]);
        try {
            ((IndexProvider)Mockito.doReturn((Object)IndexRecoveryIT.indexPopulatorWithControlledCompletionTiming(recoverySemaphore)).when((Object)this.mockedIndexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
            MinimalIndexAccessor minimalIndexAccessor = (MinimalIndexAccessor)Mockito.mock(MinimalIndexAccessor.class);
            ((IndexProvider)Mockito.doReturn((Object)minimalIndexAccessor).when((Object)this.mockedIndexProvider)).getMinimalIndexAccessor((IndexDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
            this.startDb();
            try (Transaction transaction = this.db.beginTx();){
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.POPULATING});
            }
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)3))).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.never())).getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)2))).getMinimalIndexAccessor((IndexDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
            ((MinimalIndexAccessor)Mockito.verify((Object)minimalIndexAccessor, (VerificationMode)Mockito.times((int)2))).drop();
        }
        finally {
            this.monitors.removeMonitorListener((Object)drainingMonitor);
            recoverySemaphore.release();
        }
    }

    @Test
    void shouldBeAbleToRecoverAndUpdateOnlineIndex() throws Exception {
        this.startDb();
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)populator);
        Mockito.when((Object)populator.sample((CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)new IndexSample());
        IndexAccessor mockedAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)mockedAccessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)SwallowingIndexUpdater.INSTANCE);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)mockedAccessor);
        IndexDescriptor index = this.createIndexAndAwaitPopulation();
        this.rotateLogsAndCheckPoint();
        Set<IndexEntryUpdate> expectedUpdates = this.createSomeBananas(this.myLabel, index);
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.ONLINE);
        GatheringIndexWriter writer = new GatheringIndexWriter();
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)writer);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.ONLINE});
        }
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
        int onlineAccessorInvocationCount = 3;
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)onlineAccessorInvocationCount))).getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
        org.junit.jupiter.api.Assertions.assertEquals(expectedUpdates, writer.batchedUpdates);
    }

    @Test
    void shouldKeepFailedIndexesAsFailedAfterRestart() throws Exception {
        IndexPopulator indexPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)indexPopulator);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).thenReturn((Object)indexAccessor);
        this.startDb();
        this.createIndex();
        this.rotateLogsAndCheckPoint();
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.FAILED);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.FAILED});
        }
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ElementIdMapper)ArgumentMatchers.any(ElementIdMapper.class), (ImmutableSet)ArgumentMatchers.any(), (StorageEngineIndexingBehaviour)ArgumentMatchers.any());
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider)).getMinimalIndexAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), ArgumentMatchers.anyBoolean());
    }

    private void startDb() throws IOException {
        if (this.db != null) {
            this.managementService.shutdown();
        }
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).addExtension(this.mockedIndexProviderFactory).noOpSystemGraphInitializer().setMonitors(this.monitors).setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofDays(1L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)Integer.MAX_VALUE).setConfig(GraphDatabaseInternalSettings.always_use_latest_index_provider, (Object)false).build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killDb() {
        if (this.db != null) {
            Path snapshotDir = this.testDirectory.directory("snapshot");
            Object object = this.lock;
            synchronized (object) {
                this.snapshotFs(snapshotDir);
            }
            this.managementService.shutdown();
            this.restoreSnapshot(snapshotDir);
        }
    }

    private void snapshotFs(Path snapshotDir) {
        try {
            DatabaseLayout layout = this.databaseLayout;
            this.fs.copyRecursively(layout.databaseDirectory(), snapshotDir.resolve("data"));
            this.fs.copyRecursively(layout.getTransactionLogsDirectory(), snapshotDir.resolve("transactions"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void restoreSnapshot(Path snapshotDir) {
        try {
            DatabaseLayout layout = this.databaseLayout;
            this.fs.deleteRecursively(layout.databaseDirectory());
            this.fs.deleteRecursively(layout.getTransactionLogsDirectory());
            this.fs.copyRecursively(snapshotDir.resolve("data"), layout.databaseDirectory());
            this.fs.copyRecursively(snapshotDir.resolve("transactions"), layout.getTransactionLogsDirectory());
            this.fs.deleteRecursively(snapshotDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Future<Void> killDbInSeparateThread() {
        return this.executor.submit(() -> {
            this.killDb();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateLogsAndCheckPoint() throws IOException {
        block5: {
            try {
                Object object = this.lock;
                synchronized (object) {
                    ((LogFiles)this.db.getDependencyResolver().resolveDependency(LogFiles.class)).getLogFile().getLogRotation().rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
                    ((CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
                }
            }
            catch (Exception e) {
                if (!this.db.isAvailable()) break block5;
                throw new RuntimeException(e);
            }
        }
    }

    private IndexDescriptor createIndexAndAwaitPopulation() throws KernelException {
        IndexDescriptor index = this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(index.getName(), 1L, TimeUnit.MINUTES);
            tx.commit();
        }
        return index;
    }

    private IndexDescriptor createIndex() throws KernelException {
        try (TransactionImpl tx = (TransactionImpl)this.db.beginTx();){
            IndexDescriptor index = IndexingTestUtil.createNodePropIndexWithSpecifiedProvider(tx, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, this.myLabel, "number_of_bananas_owned");
            tx.commit();
            IndexDescriptor indexDescriptor = index;
            return indexDescriptor;
        }
    }

    private Set<IndexEntryUpdate> createSomeBananas(Label label, IndexDescriptor index) {
        HashSet<IndexEntryUpdate> updates = new HashSet<IndexEntryUpdate>();
        try (Transaction tx = this.db.beginTx();){
            for (int number : new int[]{4, 10}) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("number_of_bananas_owned", (Object)number);
                updates.add((IndexEntryUpdate)ValueIndexEntryUpdate.add((long)node.getId(), (IndexDescriptor)index, (Value[])new Value[]{Values.of((Object)number)}));
            }
            tx.commit();
            HashSet<IndexEntryUpdate> hashSet = updates;
            return hashSet;
        }
    }

    private static IndexPopulator indexPopulatorWithControlledCompletionTiming(final Semaphore semaphore) {
        return new IndexPopulator.Adapter(){

            public void create() {
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw new RuntimeException("this is expected");
            }
        };
    }

    private void createSomeData() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    private record MyRecoveryMonitor(Semaphore recoverySemaphore) implements RecoveryMonitor
    {
        public void transactionLogRecoveryCompleted(long recoveryTimeInMilliseconds, RecoveryMode mode) {
            this.recoverySemaphore.release();
        }
    }

    public static class GatheringIndexWriter
    extends IndexAccessor.Adapter {
        private final Set<IndexEntryUpdate> regularUpdates = new HashSet<IndexEntryUpdate>();
        private final Set<IndexEntryUpdate> batchedUpdates = new HashSet<IndexEntryUpdate>();

        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
            return new CollectingIndexUpdater(CursorContext.NULL_CONTEXT, updates -> {
                switch (mode) {
                    case ONLINE: {
                        this.regularUpdates.addAll(updates.stream().map(CollectingIndexUpdater.VersionedUpdate::update).toList());
                        break;
                    }
                    case RECOVERY: {
                        this.batchedUpdates.addAll(updates.stream().map(CollectingIndexUpdater.VersionedUpdate::update).toList());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            });
        }
    }
}

