/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.IOException;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProviders;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.StoreIdGenerator;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;

@PageCacheExtension
@Neo4jLayoutExtension
class ManyPropertyKeysIT {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private PageCache pageCache;
    private DatabaseManagementService managementService;

    ManyPropertyKeysIT() {
    }

    @Test
    void creating_many_property_keys_should_have_all_loaded_the_next_restart() throws Exception {
        GraphDatabaseAPI db = this.databaseWithManyPropertyKeys(3000);
        int countBefore = ManyPropertyKeysIT.propertyKeyCount(db);
        this.managementService.shutdown();
        db = this.database();
        ManyPropertyKeysIT.createNodeWithProperty((GraphDatabaseService)db, ManyPropertyKeysIT.key(2800), true);
        Assertions.assertEquals((int)countBefore, (int)ManyPropertyKeysIT.propertyKeyCount(db));
        this.managementService.shutdown();
    }

    @Test
    void concurrently_creating_same_property_key_in_different_transactions_should_end_up_with_same_key_id() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        Worker worker1 = new Worker("w1", (GraphDatabaseService)db);
        Worker worker2 = new Worker("w2", (GraphDatabaseService)db);
        worker1.beginTx();
        worker2.beginTx();
        String key = "mykey";
        worker1.setProperty(key);
        worker2.setProperty(key);
        worker1.commit();
        worker2.commit();
        worker1.close();
        worker2.close();
        Assertions.assertEquals((int)1, (int)ManyPropertyKeysIT.propertyKeyCount(db));
        managementService.shutdown();
    }

    private GraphDatabaseAPI database() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private GraphDatabaseAPI databaseWithManyPropertyKeys(int propertyKeyCount) throws IOException {
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        CursorContextFactory contextFactory = new CursorContextFactory(cacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        CursorContext cursorContext = contextFactory.create("databaseWithManyPropertyKeys");
        StoreFactory storeFactory = new StoreFactory(this.databaseLayout, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate(), cacheTracer, this.databaseLayout.getDatabaseName()), this.pageCache, cacheTracer, this.fileSystem, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, false, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, StoreIdGenerator.UNIQUE_ID);
        NeoStores neoStores = storeFactory.openAllNeoStores();
        PropertyKeyTokenStore store = neoStores.getPropertyKeyTokenStore();
        DynamicAllocatorProvider allocatorProvider = DynamicAllocatorProviders.nonTransactionalAllocator((NeoStores)neoStores);
        try (CachedStoreCursors storeCursors = new CachedStoreCursors(neoStores, CursorContext.NULL_CONTEXT);
             PageCursor cursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR);){
            for (int i = 0; i < propertyKeyCount; ++i) {
                PropertyKeyTokenRecord record = new PropertyKeyTokenRecord((int)store.getIdGenerator().nextId(cursorContext));
                record.setInUse(true);
                Collection nameRecords = store.allocateNameRecords(PropertyStore.encodeString((String)ManyPropertyKeysIT.key(i)), allocatorProvider.allocator(StoreType.PROPERTY_KEY_TOKEN_NAME), cursorContext, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                record.addNameRecords((Iterable)nameRecords);
                record.setNameId((int)((DynamicRecord)Iterables.first((Iterable)nameRecords)).getId());
                store.updateRecord((AbstractBaseRecord)record, cursor, CursorContext.NULL_CONTEXT, (StoreCursors)storeCursors);
            }
        }
        neoStores.flush(DatabaseFlushEvent.NULL, cursorContext);
        neoStores.close();
        return this.database();
    }

    private static String key(int i) {
        return "key" + i;
    }

    private static void createNodeWithProperty(GraphDatabaseService db, String key, Object value) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(key, value);
            tx.commit();
        }
    }

    private static int propertyKeyCount(GraphDatabaseAPI db) throws TransactionFailureException {
        Kernel kernelAPI = (Kernel)db.getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx = kernelAPI.beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.read());){
            int n = tx.tokenRead().propertyKeyCount();
            return n;
        }
    }

    private static class Worker
    extends OtherThreadExecutor {
        private final GraphDatabaseService db;
        private Transaction tx;

        Worker(String name, GraphDatabaseService db) {
            super(name);
            this.db = db;
        }

        void beginTx() throws Exception {
            this.execute(() -> {
                this.tx = this.db.beginTx();
                return null;
            });
        }

        void setProperty(String key) throws Exception {
            this.execute(() -> {
                Node node = this.tx.createNode();
                node.setProperty(key, (Object)true);
                return null;
            });
        }

        void commit() throws Exception {
            this.execute(() -> {
                this.tx.commit();
                return null;
            });
        }
    }
}

