/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class RelationshipsIterationTest {
    private static final TestDatabaseManagementServiceBuilder BUILDER = new TestDatabaseManagementServiceBuilder();
    private static final int DENSE_NODE_THRESHOLD = 51;
    private static DatabaseManagementService DATABASE;
    private GraphDatabaseService db;
    private final RelationshipType typeA = RelationshipType.withName((String)"A");
    private final RelationshipType typeB = RelationshipType.withName((String)"B");
    private final RelationshipType typeC = RelationshipType.withName((String)"C");
    private final RelationshipType typeD = RelationshipType.withName((String)"D");
    private final RelationshipType typeX = RelationshipType.withName((String)"X");

    RelationshipsIterationTest() {
    }

    @BeforeAll
    static void setUp() {
        DATABASE = BUILDER.impermanent().build();
    }

    @AfterAll
    static void tearDown() {
        DATABASE.shutdown();
    }

    @BeforeEach
    void setUpEach() {
        this.db = DATABASE.database("neo4j");
        try (Transaction tx = this.db.beginTx();
             ResourceIterable allRelationships = tx.getAllRelationships();
             ResourceIterable allNodes = tx.getAllNodes();){
            allRelationships.forEach(Entity::delete);
            allNodes.forEach(Node::delete);
            tx.commit();
        }
    }

    private static interface Check {
        public void check(Node var1, Node var2, Node var3);
    }

    @Nested
    class WithDenseUnrelatedNode
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithDenseUnrelatedNode() {
        }

        @Override
        @BeforeEach
        void setUp() {
            super.setUp();
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node unrelated = tx.getNodeById(this.notMatching);
                for (int i = 0; i < 51; ++i) {
                    unrelated.createRelationshipTo(unrelated, RelationshipsIterationTest.this.typeX);
                }
                tx.commit();
            }
        }
    }

    @Nested
    class WithDenseSecondNode
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithDenseSecondNode() {
        }

        @Override
        @BeforeEach
        void setUp() {
            super.setUp();
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node second = tx.getNodeById(this.matchingSecond);
                for (int i = 0; i < 51; ++i) {
                    second.createRelationshipTo(second, RelationshipsIterationTest.this.typeX);
                }
                tx.commit();
            }
        }
    }

    @Nested
    class WithDenseFirstNode
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithDenseFirstNode() {
        }

        @Override
        @BeforeEach
        void setUp() {
            super.setUp();
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node first = tx.getNodeById(this.matchingFirst);
                for (int i = 0; i < 51; ++i) {
                    first.createRelationshipTo(first, RelationshipsIterationTest.this.typeX);
                }
                tx.commit();
            }
        }
    }

    @Nested
    class WithNoDenseNodes
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithNoDenseNodes(RelationshipsIterationTest this$0) {
        }
    }

    @Nested
    abstract class RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        long matchingFirst;
        long notMatching;
        long matchingSecond;

        RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships() {
        }

        @BeforeEach
        void setUp() {
            Node first;
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                first = tx.createNode();
                Node unrelated = tx.createNode();
                Node second = tx.createNode();
                this.matchingFirst = first.getId();
                this.notMatching = unrelated.getId();
                this.matchingSecond = second.getId();
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeA);
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeB);
                first.createRelationshipTo(unrelated, RelationshipsIterationTest.this.typeC);
                second.createRelationshipTo(unrelated, RelationshipsIterationTest.this.typeD);
                tx.commit();
            }
            tx = RelationshipsIterationTest.this.db.beginTx();
            try {
                first = tx.getNodeById(this.matchingFirst);
                Node second = tx.getNodeById(this.matchingSecond);
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeA);
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeB);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        @Test
        void matchNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMatch3() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeD}));
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMatch4() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMisdir1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)second.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMisdir2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void misdirNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void misdirNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)second.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void misdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void misdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)second.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchMisdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchMisdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchMisdirMatch3() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchMisdirMatch4() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchMisdirMatch5() {
            this.check((first, unrelated, second) -> {
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)second.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMisdir1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)unrelated.hasRelationship(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)second.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMisdir2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)unrelated.hasRelationship(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)first.hasRelationship(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMatchNot1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMatchNot2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assertions.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void countMatchNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMatch3() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeD, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeD})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMatch4() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMisdir1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMisdir2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMisdirNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMisdirNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMisdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMisdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchMisdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchMisdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchMisdirMatch3() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchMisdirMatch4() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchMisdirMatch5() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMisdir1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMisdir2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(Direction.BOTH, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMatchNot1() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMatchNot2() {
            this.check((first, unrelated, second) -> {
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)2, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assertions.assertEquals((int)0, (int)this.countTypes(RelationshipsIterationTest.this.typeA, (ResourceIterable<Relationship>)unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        private void check(Check check) {
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node first = tx.getNodeById(this.matchingFirst);
                Node unrelated = tx.getNodeById(this.notMatching);
                Node second = tx.getNodeById(this.matchingSecond);
                check.check(first, unrelated, second);
            }
        }

        private int countTypes(RelationshipType type, ResourceIterable<Relationship> iterable) {
            try (ResourceIterable<Relationship> resourceIterable = iterable;){
                int count = 0;
                for (Relationship relationship : iterable) {
                    Assertions.assertEquals((Object)type, (Object)relationship.getType());
                    ++count;
                }
                int n = count;
                return n;
            }
        }
    }
}

