/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.time.ZoneId;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.Value;

class TestCombinedPropertyTypes
extends AbstractNeo4jTestCase {
    private String node1Id;

    TestCombinedPropertyTypes() {
    }

    @BeforeEach
    void createInitialNode() {
        this.node1Id = this.createNode();
    }

    @AfterEach
    void deleteInitialNode() {
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeByElementId(this.node1Id).delete();
            transaction.commit();
        }
    }

    @Test
    void testDateTypeOrdinalDayWithPrecedingInLinedLong() {
        this.testDateTypeWithPrecedingInLinedLong((Value)DateValue.ordinalDate((int)4800, (int)1));
    }

    @Test
    void testDateTypeOrdinalDayWithPrecedingNotInLinedLong() {
        this.testDateTypeWithPrecedingNotInLinedLong((Value)DateValue.ordinalDate((int)4800, (int)1));
    }

    @Test
    void testLocalTimeWithPrecedingInLinedLong() {
        this.testDateTypeWithPrecedingInLinedLong((Value)LocalTimeValue.parse((CharSequence)"13:45:02"));
    }

    @Test
    void testLocalTimeWithPrecedingNotInLinedLong() {
        this.testDateTypeWithPrecedingNotInLinedLong((Value)LocalTimeValue.parse((CharSequence)"13:45:02"));
    }

    @Test
    void testDateTimeWithPrecedingInLinedLong() {
        this.testDateTypeWithPrecedingInLinedLong((Value)DateTimeValue.datetime((DateValue)DateValue.parse((CharSequence)"2018-04-01"), (LocalTimeValue)LocalTimeValue.parse((CharSequence)"01:02:03"), (ZoneId)ZoneId.of("Europe/Stockholm")));
    }

    @Test
    void testDateTimeWithPrecedingNotInLinedLong() {
        this.testDateTypeWithPrecedingNotInLinedLong((Value)DateTimeValue.datetime((DateValue)DateValue.parse((CharSequence)"2018-04-01"), (LocalTimeValue)LocalTimeValue.parse((CharSequence)"01:02:03"), (ZoneId)ZoneId.of("Europe/Stockholm")));
    }

    private void testDateTypeWithPrecedingInLinedLong(Value value) {
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(this.node1Id);
            node1.setProperty("l1", (Object)255);
            node1.setProperty(key, (Object)value);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeByElementId(this.node1Id).getProperty(key);
            Assertions.assertEquals((Object)value.asObjectCopy(), (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void testDateTypeWithPrecedingNotInLinedLong(Value value) {
        Node node1;
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            node1 = transaction.getNodeByElementId(this.node1Id);
            node1.setProperty("l1", (Object)Long.MAX_VALUE);
            node1.setProperty(key, (Object)value);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(this.node1Id);
            Object property = node1.getProperty(key);
            Assertions.assertEquals((Object)value.asObjectCopy(), (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

