/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.lock.ResourceType;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Threading;
import org.neo4j.util.concurrent.BinaryLatch;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ImpermanentDbmsExtension
class DetachDeleteIT {
    private static final ExecutorService executor = Executors.newFixedThreadPool(5);
    @Inject
    GraphDatabaseService db;

    DetachDeleteIT() {
    }

    @AfterAll
    static void tearDown() {
        executor.shutdown();
    }

    @Test
    void detachDeleteMustRemoveAllRelationships() throws Exception {
        long nodeId = this.makeSimpleNode();
        try (Transaction tx = this.db.beginTx();){
            Write write = DetachDeleteIT.getWrite(tx);
            Assertions.assertEquals((int)10, (int)write.nodeDetachDelete(nodeId));
            tx.commit();
        }
    }

    @Test
    void detachDeleteMustRemoveAllRelationshipsOfDenseNodes() throws Exception {
        long nodeId = this.makeDenseNode();
        try (Transaction tx = this.db.beginTx();){
            Write write = DetachDeleteIT.getWrite(tx);
            Assertions.assertEquals((int)100, (int)write.nodeDetachDelete(nodeId));
            tx.commit();
        }
    }

    @RepeatedTest(value=10)
    void detachDeleteMustRemoveAllRelationshipsWhenMoreAreConcurrentlyAdded() throws Exception {
        long nodeId = this.makeSimpleNode();
        this.verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(nodeId, 1);
    }

    @RepeatedTest(value=10)
    void detachDeleteMustRemoveAllRelationshipsWhenMoreAreConcurrentlyAddedToMakeNodeDense() throws Exception {
        long nodeId = this.makeSimpleNode();
        this.verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(nodeId, 10);
    }

    @RepeatedTest(value=10)
    void detachDeleteMustRemoveAllRelationshipsWhenMoreAreConcurrentlyAddedToAlreadyDenseNode() throws Exception {
        long nodeId = this.makeDenseNode();
        this.verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(nodeId, 10);
    }

    @Test
    void detachDeleteMustLockAllNeighboursIncludingThoseConcurrentlyAdded() throws Exception {
        long otherNodeId;
        Sequencer<Phases> sequencer = Sequencer.from(Phases.class);
        Thread main = Thread.currentThread();
        try (Transaction tx = this.db.beginTx();){
            otherNodeId = tx.createNode().getId();
            tx.commit();
        }
        long nodeId = this.makeDenseNode();
        AtomicLong otherRelId = new AtomicLong();
        Future<Object> relationshipAdder = executor.submit(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.getNodeById(nodeId);
                Node other = tx.getNodeById(otherNodeId);
                long id = node.createRelationshipTo(other, RelationshipType.withName((String)"R5")).getId();
                otherRelId.set(id);
                sequencer.release(Phases.OTHER_REL_CREATED);
                sequencer.await(Phases.DETACH_DELETE_HAS_STARTED);
                tx.commit();
            }
            return null;
        });
        Future<Object> lockVerifier = executor.submit(() -> {
            sequencer.await(Phases.OTHER_REL_CREATED);
            Predicate predicate = Threading.waitingWhileIn(ForsetiClient.class, (String[])new String[]{"waitFor"});
            do {
                Thread.sleep(100L);
            } while (!predicate.test(main));
            sequencer.release(Phases.DETACH_DELETE_HAS_STARTED);
            sequencer.await(Phases.DETACH_DELETE_HAS_FINISHED);
            try (Transaction ignore = this.db.beginTx();){
                LockManager.Client locksClient = DetachDeleteIT.getLocksClient(ignore);
                Assertions.assertFalse((boolean)locksClient.tryExclusiveLock(ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, otherNodeId));
                Assertions.assertFalse((boolean)locksClient.trySharedLock(ResourceType.RELATIONSHIP, otherRelId.get()));
            }
            finally {
                sequencer.release(Phases.LOCK_VERIFICATION_FINISHED);
            }
            return null;
        });
        sequencer.await(Phases.OTHER_REL_CREATED);
        try (Transaction tx = this.db.beginTx();){
            Write write = DetachDeleteIT.getWrite(tx);
            write.nodeDetachDelete(nodeId);
            ((TransactionImpl)tx).kernelTransaction().commit(KernelTransaction.Monitor.withBeforeApply(() -> {
                sequencer.release(Phases.DETACH_DELETE_HAS_FINISHED);
                sequencer.await(Phases.LOCK_VERIFICATION_FINISHED);
            }));
        }
        relationshipAdder.get();
        lockVerifier.get();
    }

    private void verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(long nodeId, int iterPerRelType) throws Exception {
        CountDownLatch latch = new CountDownLatch(5);
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (int i = 1; i < 10; ++i) {
            RelationshipType type = RelationshipType.withName((String)("R" + i));
            Callable<Object> callable = () -> {
                latch.countDown();
                latch.await();
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.getNodeById(nodeId);
                    node.createRelationshipTo(tx.createNode(), type);
                    tx.commit();
                }
                catch (NotFoundException | DeadlockDetectedException throwable) {
                    // empty catch block
                }
                return null;
            };
            for (int j = 0; j < iterPerRelType; ++j) {
                tasks.add(callable);
            }
        }
        tasks.add(() -> {
            latch.countDown();
            latch.await();
            boolean retry = true;
            while (retry) {
                try {
                    Transaction tx = this.db.beginTx();
                    try {
                        Write write = DetachDeleteIT.getWrite(tx);
                        write.nodeDetachDelete(nodeId);
                        tx.commit();
                        retry = false;
                    }
                    finally {
                        if (tx == null) continue;
                        tx.close();
                    }
                }
                catch (DeadlockDetectedException de) {
                    retry = false;
                }
            }
            return null;
        });
        Collections.shuffle(tasks);
        List futures = executor.invokeAll(tasks);
        for (Future future : futures) {
            future.get();
        }
    }

    private long makeSimpleNode() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getId();
            for (int i = 0; i < 10; ++i) {
                node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)("R" + i)));
            }
            tx.commit();
        }
        return nodeId;
    }

    private long makeDenseNode() {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getId();
            tx.commit();
        }
        for (int i = 0; i < 10; ++i) {
            RelationshipType type = RelationshipType.withName((String)("R" + i));
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.getNodeById(nodeId);
                for (int j = 0; j < 10; ++j) {
                    node.createRelationshipTo(tx.createNode(), type);
                }
                tx.commit();
                continue;
            }
        }
        return nodeId;
    }

    private static Write getWrite(Transaction tx) throws Exception {
        return DetachDeleteIT.getKernelTransaction(tx).dataWrite();
    }

    private static LockManager.Client getLocksClient(Transaction tx) {
        KernelTransactionImplementation kti = (KernelTransactionImplementation)DetachDeleteIT.getKernelTransaction(tx);
        return kti.lockClient();
    }

    private static KernelTransaction getKernelTransaction(Transaction tx) {
        InternalTransaction itx = (InternalTransaction)tx;
        return itx.kernelTransaction();
    }

    static enum Phases {
        OTHER_REL_CREATED,
        DETACH_DELETE_HAS_STARTED,
        DETACH_DELETE_HAS_FINISHED,
        LOCK_VERIFICATION_FINISHED;

    }

    private static class Sequencer<E extends Enum<E>> {
        private final EnumMap<E, BinaryLatch> map;

        private Sequencer(EnumMap<E, BinaryLatch> map) {
            this.map = map;
        }

        static <T extends Enum<T>> Sequencer<T> from(Class<T> cls) {
            EnumMap<T, BinaryLatch> map = new EnumMap<T, BinaryLatch>(cls);
            for (Enum phase : (Enum[])cls.getEnumConstants()) {
                map.put((T)phase, new BinaryLatch());
            }
            return new Sequencer<T>(map);
        }

        void await(E phase) {
            this.map.get(phase).await();
        }

        void release(E phase) {
            this.map.get(phase).release();
        }
    }
}

