/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.factory.primitive.LongObjectMaps;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.token.api.NonUniqueTokenException;
import org.neo4j.values.storable.RandomValuesUtils;
import org.neo4j.values.storable.Value;

@ExtendWith(value={RandomExtension.class})
class CreateWithSpecificIdKernelWriteTest
extends KernelAPIWriteTestBase<WriteTestSupport> {
    @Inject
    private RandomSupport random;
    private final AtomicInteger nextRelationshipTypeTokenId = new AtomicInteger(5);

    CreateWithSpecificIdKernelWriteTest() {
    }

    @BeforeEach
    void setup() {
        this.random.withConfiguration(RandomValuesUtils.selectStorageEngineDependentConfiguration((GraphDatabaseService)this.graphDb)).reset();
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    @Test
    void shouldCreateRelationshipTypeWithSpecificId() throws Exception {
        int id = this.nextRelationshipTypeTokenId.getAndIncrement();
        String name = "MY_TYPE" + id;
        try (KernelTransaction tx = this.beginTransaction();){
            TokenWrite tokenWrite = tx.tokenWrite();
            tokenWrite.relationshipTypeWithSpecificIdCreateForName(id, name);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertThat((String)tx.tokenRead().relationshipTypeName(id)).isEqualTo(name);
            Assertions.assertThat((int)tx.tokenRead().relationshipType(name)).isEqualTo(id);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            int otherId = tx.tokenWrite().relationshipTypeCreateForName("OTHER_TYPE", false);
            Assertions.assertThat((int)otherId).isNotEqualTo(id);
            tx.commit();
            this.nextRelationshipTypeTokenId.getAndIncrement();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldIdempotentlyCreateRelationshipTypeWithSpecificId() throws Exception {
        int id;
        TokenWrite tokenWrite;
        String name = "MY_TYPE" + this.nextRelationshipTypeTokenId.getAndIncrement();
        try (KernelTransaction tx = this.beginTransaction();){
            tokenWrite = tx.tokenWrite();
            id = tokenWrite.relationshipTypeCreateForName(name, false);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tokenWrite = tx.tokenWrite();
            tokenWrite.relationshipTypeWithSpecificIdCreateForName(id, name);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertThat((String)tx.tokenRead().relationshipTypeName(id)).isEqualTo(name);
            Assertions.assertThat((int)tx.tokenRead().relationshipType(name)).isEqualTo(id);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFailCreateRelationshipTypeWithSpecificIdOnExistingId() throws Exception {
        int id;
        TokenWrite tokenWrite;
        String name = "MY_TYPE" + this.nextRelationshipTypeTokenId.getAndIncrement();
        try (KernelTransaction tx = this.beginTransaction();){
            tokenWrite = tx.tokenWrite();
            id = tokenWrite.relationshipTypeCreateForName(name, false);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tokenWrite = tx.tokenWrite();
            Assertions.assertThatThrownBy(() -> tokenWrite.relationshipTypeWithSpecificIdCreateForName(id, name + "_OTHER")).isInstanceOf(NonUniqueTokenException.class);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFailCreateRelationshipTypeWithSpecificIdOnExistingName() throws Exception {
        int id;
        TokenWrite tokenWrite;
        String name = "MY_TYPE" + this.nextRelationshipTypeTokenId.getAndIncrement();
        try (KernelTransaction tx = this.beginTransaction();){
            tokenWrite = tx.tokenWrite();
            id = tokenWrite.relationshipTypeCreateForName(name, false);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tokenWrite = tx.tokenWrite();
            Assertions.assertThatThrownBy(() -> tokenWrite.relationshipTypeWithSpecificIdCreateForName(id + 1, name)).isInstanceOf(NonUniqueTokenException.class);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private MutableLongObjectMap<NodeData> readNodes() throws Exception {
        MutableLongObjectMap nodes = LongObjectMaps.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
             RelationshipTraversalCursor traversalCursor = tx.cursors().allocateRelationshipTraversalCursor(CursorContext.NULL_CONTEXT);){
            Read read = tx.dataRead();
            read.allNodesScan(nodeCursor);
            while (nodeCursor.next()) {
                MutableLongSet relationships = LongSets.mutable.empty();
                nodeCursor.relationships(traversalCursor, RelationshipSelection.ALL_RELATIONSHIPS);
                while (traversalCursor.next()) {
                    relationships.add(traversalCursor.reference());
                }
                nodes.put(nodeCursor.reference(), (Object)new NodeData((IntSet)IntSets.immutable.of(nodeCursor.labels().all()), this.properties((EntityCursor)nodeCursor, propertyCursor), relationships));
            }
        }
        return nodes;
    }

    private IntObjectMap<Value> properties(EntityCursor entityCursor, PropertyCursor propertyCursor) {
        MutableIntObjectMap properties = IntObjectMaps.mutable.empty();
        entityCursor.properties(propertyCursor);
        while (propertyCursor.next()) {
            properties.put(propertyCursor.propertyKey(), (Object)propertyCursor.propertyValue());
        }
        return properties.toImmutable();
    }

    private MutableLongObjectMap<RelationshipData> readRelationships() throws Exception {
        MutableLongObjectMap relationships = LongObjectMaps.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipScanCursor relationshipCursor = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Read read = tx.dataRead();
            read.allRelationshipsScan(relationshipCursor);
            while (relationshipCursor.next()) {
                relationships.put(relationshipCursor.reference(), (Object)new RelationshipData(relationshipCursor.sourceNodeReference(), relationshipCursor.type(), relationshipCursor.targetNodeReference(), this.properties((EntityCursor)relationshipCursor, propertyCursor)));
            }
        }
        return relationships;
    }

    private record NodeData(IntSet labels, IntObjectMap<Value> properties, MutableLongSet relationships) {
    }

    private record RelationshipData(long startNodeId, int type, long endNodeId, IntObjectMap<Value> properties) {
    }
}

