/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexScanPartitionedScanTestSuite;

abstract class NodePropertyIndexScanPartitionedScanTestSuite
extends PropertyIndexScanPartitionedScanTestSuite<NodeValueIndexCursor> {
    NodePropertyIndexScanPartitionedScanTestSuite(PropertyIndexPartitionedScanTestSuite.TestIndexType index) {
        super(index);
    }

    public final PartitionedScanFactories.NodePropertyIndexScan getFactory() {
        return PartitionedScanFactories.NodePropertyIndexScan.FACTORY;
    }

    @Nested
    class WithData
    extends PropertyIndexScanPartitionedScanTestSuite.WithData<NodeValueIndexCursor> {
        WithData() {
            super(NodePropertyIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> setupDatabase() {
            boolean numberOfLabels = true;
            int numberOfPropKeys = 2;
            int numberOfProperties = 4096;
            int labelId = this.createTokens(1, this.factory.getTokenSupplier())[0];
            int[] propKeyIds = this.createTokens(2, this.factory.getPropKeySupplier());
            PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> data = this.createData(4096, labelId, propKeyIds);
            this.createIndexes(NodePropertyIndexScanPartitionedScanTestSuite.this.createIndexPrototypes(labelId, propKeyIds));
            return data;
        }

        @Override
        protected PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> createData(int numberOfProperties, int labelId, int[] propKeyIds) {
            PartitionedScanTestSuite.EntityIdsMatchingQuery<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> nodesInIndex = new PartitionedScanTestSuite.EntityIdsMatchingQuery<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery>();
            PrimitiveIterator.OfInt propValues = this.random.ints((long)numberOfProperties).iterator();
            int numberOfCreatedProperties = 0;
            try (KernelTransaction tx = this.beginTx();){
                Write write = tx.dataWrite();
                while (propValues.hasNext()) {
                    PropertyIndexPartitionedScanTestSuite.PropertyRecord[] assignedProperties = new PropertyIndexPartitionedScanTestSuite.PropertyRecord[propKeyIds.length];
                    long nodeId = write.nodeCreate();
                    if (!write.nodeAddLabel(nodeId, labelId)) continue;
                    for (int i = 0; i < propKeyIds.length; ++i) {
                        if (!propValues.hasNext()) continue;
                        PropertyIndexPartitionedScanTestSuite.PropertyRecord prop = PropertyIndexPartitionedScanTestSuite.createRandomPropertyRecord(this.random, propKeyIds[i], propValues.next(), this.isBlockFormat());
                        write.nodeSetProperty(nodeId, prop.id(), prop.value());
                        ++numberOfCreatedProperties;
                        assignedProperties[i] = prop;
                        nodesInIndex.getOrCreate(new PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery(this.factory.getIndexName(labelId, prop.id()))).add(nodeId);
                    }
                    if (!Arrays.stream(assignedProperties).allMatch(Objects::nonNull)) continue;
                    nodesInIndex.getOrCreate(new PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery(this.factory.getIndexName(labelId, propKeyIds))).add(nodeId);
                }
                tx.commit();
            }
            catch (Exception e) {
                throw new AssertionError("failed to create database", e);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfCreatedProperties).as("node properties created", new Object[0])).isEqualTo(numberOfProperties);
            return new PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery>(nodesInIndex);
        }
    }

    @Nested
    class WithoutData
    extends PropertyIndexScanPartitionedScanTestSuite.WithoutData<NodeValueIndexCursor> {
        WithoutData() {
            super(NodePropertyIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> setupDatabase() {
            boolean numberOfLabels = true;
            int numberOfPropKeys = 2;
            int labelId = this.createTokens(1, this.factory.getTokenSupplier())[0];
            int[] propKeyIds = this.createTokens(2, this.factory.getPropKeySupplier());
            PartitionedScanTestSuite.Queries<PropertyIndexScanPartitionedScanTestSuite.PropertyKeyScanQuery> data = this.emptyQueries(labelId, propKeyIds);
            this.createIndexes(NodePropertyIndexScanPartitionedScanTestSuite.this.createIndexPrototypes(labelId, propKeyIds));
            return data;
        }
    }
}

