/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SkipOnSpd;
import org.neo4j.values.storable.Values;

@DbmsExtension
class ReadTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    private final Label label = Label.label((String)"marker");
    private final String property = "property";
    private final String testPropertyValue = "abc";
    private final String indexName = "indexName";
    private final RelationshipType type = RelationshipType.withName((String)"type");

    ReadTracingIT() {
    }

    @SkipOnSpd(reason="Index page pins will happen on property shards, not graph shard")
    @Test
    void tracePageCacheAccessOnNodeIndexSeek() throws KernelException {
        this.createNodeConstraint();
        this.createMatchingNode();
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            Read dataRead = kernelTransaction.dataRead();
            IndexDescriptor indexDescriptor = kernelTransaction.schemaRead().indexGetForName("indexName");
            CursorContext cursorContext = kernelTransaction.cursorContext();
            int propertyId = kernelTransaction.tokenRead().propertyKey("property");
            ReadTracingIT.assertZeroCursor(cursorContext);
            IndexReadSession indexSession = dataRead.indexReadSession(indexDescriptor);
            try (NodeValueIndexCursor cursor = kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());){
                dataRead.nodeIndexSeek(kernelTransaction.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyId, (Object)Values.stringValue((String)"abc"))});
                ReadTracingIT.consumeCursor((Cursor)cursor);
            }
            ReadTracingIT.assertOneCursor(cursorContext);
            Assertions.assertThat((long)cursorContext.getCursorTracer().faults()).isZero();
        }
    }

    @Test
    void noPageCacheTracingAvailableOnRelationshipIndexSeek() throws KernelException {
        this.createRelationshipIndex();
        try (Transaction tx = this.database.beginTx();){
            Node source = tx.createNode(new Label[]{this.label});
            Node target = tx.createNode(new Label[]{this.label});
            Relationship relationship = source.createRelationshipTo(target, this.type);
            relationship.setProperty("property", (Object)"abc");
            tx.commit();
        }
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            Read dataRead = kernelTransaction.dataRead();
            IndexDescriptor indexDescriptor = kernelTransaction.schemaRead().indexGetForName("indexName");
            IndexReadSession indexReadSession = kernelTransaction.dataRead().indexReadSession(indexDescriptor);
            CursorContext cursorContext = kernelTransaction.cursorContext();
            ReadTracingIT.assertZeroCursor(cursorContext);
            try (RelationshipValueIndexCursor cursor = kernelTransaction.cursors().allocateRelationshipValueIndexCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());){
                dataRead.relationshipIndexSeek(kernelTransaction.queryContext(), indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"abc")});
                ReadTracingIT.consumeCursor((Cursor)cursor);
            }
            ReadTracingIT.assertZeroCursor(cursorContext);
        }
    }

    @SkipOnSpd(reason="Index page pins will happen on property shards, not graph shard")
    @Test
    void tracePageCacheAccessOnNodeIndexScan() throws KernelException {
        this.createNodeConstraint();
        this.createMatchingNode();
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            Read dataRead = kernelTransaction.dataRead();
            IndexDescriptor indexDescriptor = kernelTransaction.schemaRead().indexGetForName("indexName");
            CursorContext cursorContext = kernelTransaction.cursorContext();
            ReadTracingIT.assertZeroCursor(cursorContext);
            IndexReadSession indexSession = dataRead.indexReadSession(indexDescriptor);
            try (NodeValueIndexCursor cursor = kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());){
                dataRead.nodeIndexScan(indexSession, cursor, IndexQueryConstraints.unconstrained());
                ReadTracingIT.consumeCursor((Cursor)cursor);
            }
            ReadTracingIT.assertOneCursor(cursorContext);
            Assertions.assertThat((long)cursorContext.getCursorTracer().faults()).isZero();
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCountByLabel() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            Read dataRead = kernelTransaction.dataRead();
            ReadTracingIT.assertZeroCursor(cursorContext);
            dataRead.countsForNode(0);
            ReadTracingIT.assertOneCursor(cursorContext);
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCount() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            Read dataRead = kernelTransaction.dataRead();
            ReadTracingIT.assertZeroCursor(cursorContext);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)dataRead.nodesGetCount());
            ReadTracingIT.assertOneCursor(cursorContext);
        }
    }

    @Test
    void tracePageCacheAccessOnRelationshipCount() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            Read dataRead = kernelTransaction.dataRead();
            ReadTracingIT.assertZeroCursor(cursorContext);
            dataRead.countsForRelationship(-1, -1, -1);
            ReadTracingIT.assertOneCursor(cursorContext);
        }
    }

    private static void consumeCursor(Cursor cursor) {
        while (cursor.next()) {
        }
    }

    private void createMatchingNode() {
        try (Transaction tx = this.database.beginTx();){
            Node node = tx.createNode(new Label[]{this.label});
            node.setProperty("property", (Object)"abc");
            tx.commit();
        }
    }

    private void createNodeConstraint() {
        try (Transaction tx = this.database.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("property").withName("indexName").create();
            tx.commit();
        }
    }

    private void createRelationshipIndex() {
        this.database.executeTransactionally("CREATE FULLTEXT INDEX indexName  FOR ()-[r:" + this.type.name() + "]-() ON EACH [r.property]");
        try (Transaction tx = this.database.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
        }
    }

    private static void assertOneCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isOne();
        Assertions.assertThat((long)cursorTracer.unpins()).isOne();
        Assertions.assertThat((long)cursorTracer.hits()).isOne();
    }

    private static void assertZeroCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.faults()).isZero();
    }
}

