/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;

@ImpermanentDbmsExtension
class SchemaStorageIT {
    private static final String LABEL1 = "Label1";
    private static final String LABEL2 = "Label2";
    private static final String TYPE1 = "Type1";
    private static final String PROP1 = "prop1";
    private static final String PROP2 = "prop2";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private StorageEngine storageEngine;
    @Inject
    private TokenHolders tokenHolders;

    SchemaStorageIT() {
    }

    @BeforeEach
    void initStorage() throws Exception {
        try (Transaction transaction = this.db.beginTx();){
            TokenWrite tokenWrite = ((InternalTransaction)transaction).kernelTransaction().tokenWrite();
            tokenWrite.propertyKeyGetOrCreateForName(PROP1);
            tokenWrite.propertyKeyGetOrCreateForName(PROP2);
            tokenWrite.labelGetOrCreateForName(LABEL1);
            tokenWrite.labelGetOrCreateForName(LABEL2);
            tokenWrite.relationshipTypeGetOrCreateForName(TYPE1);
            transaction.commit();
        }
    }

    @Test
    void shouldReturnIndexRuleForLabelAndProperty() {
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2), SchemaStorageIT.index(LABEL2, PROP1));
        IndexDescriptor rule = this.indexGetForSchema(LABEL1, PROP2);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP2, false);
    }

    @Test
    void shouldReturnIndexRuleForLabelAndPropertyComposite() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String f = "f";
        this.createSchema(tx -> tx.schema().indexFor(Label.label((String)LABEL1)).on(a).on(b).on(c).on(d).on(e).on(f).create());
        IndexDescriptor rule = this.indexGetForSchema(LABEL1, a, b, c, d, e, f);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(LABEL1)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(a)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(b)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(c)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(d)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(e)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(f)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)rule.isUnique());
    }

    @Test
    void shouldReturnIndexRuleForLabelAndVeryManyPropertiesComposite() {
        String[] props = "abcdefghijklmnopqrstuvwxyzABCDEFGHJILKMNOPQRSTUVWXYZ".split("\\B");
        this.createSchema(tx -> {
            IndexCreator indexCreator = tx.schema().indexFor(Label.label((String)LABEL1));
            for (String prop : props) {
                indexCreator = indexCreator.on(prop);
            }
            indexCreator.create();
        });
        IndexDescriptor rule = this.indexGetForSchema(LABEL1, props);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(LABEL1)));
        for (String prop : props) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(prop)));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)rule.isUnique());
    }

    @Test
    void shouldReturnEmptyArrayIfIndexRuleForLabelAndPropertyDoesNotExist() {
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1));
        IndexDescriptor rule = this.indexGetForSchema(LABEL1, PROP2);
        Assertions.assertThat((Object)rule).isNull();
    }

    @Test
    void shouldListIndexRulesForLabelPropertyAndKind() {
        this.createSchema(SchemaStorageIT.uniquenessConstraint(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2));
        IndexDescriptor rule = this.indexGetForSchema(LABEL1, PROP1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, true);
    }

    @Test
    void shouldListAllIndexRules() {
        IndexingTestUtil.dropAllIndexes((GraphDatabaseService)this.db);
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2), SchemaStorageIT.uniquenessConstraint(LABEL2, PROP1));
        HashSet listedSchema = new HashSet();
        try (StorageReader reader = this.storageEngine.newReader();){
            reader.indexesGetAll().forEachRemaining(rule -> listedSchema.add(rule.schema()));
        }
        HashSet<LabelSchemaDescriptor> expectedSchema = new HashSet<LabelSchemaDescriptor>();
        expectedSchema.add(SchemaDescriptors.forLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
        expectedSchema.add(SchemaDescriptors.forLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(PROP2)}));
        expectedSchema.add(SchemaDescriptors.forLabel((int)this.labelId(LABEL2), (int[])new int[]{this.propId(PROP1)}));
        org.junit.jupiter.api.Assertions.assertEquals(expectedSchema, listedSchema);
    }

    @Test
    void shouldReturnCorrectUniquenessRuleForLabelAndProperty() {
        this.createSchema(SchemaStorageIT.uniquenessConstraint(LABEL1, PROP1), SchemaStorageIT.uniquenessConstraint(LABEL2, PROP1));
        try (StorageReader reader = this.storageEngine.newReader();){
            ConstraintDescriptor rule = (ConstraintDescriptor)Iterators.single((Iterator)reader.constraintsGetForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)})));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)rule);
            this.assertRule(rule, LABEL1, PROP1, ConstraintType.UNIQUE);
        }
    }

    private IndexDescriptor indexGetForSchema(String label, String ... propertyKeys) {
        return this.indexGetForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId(label), (int[])Arrays.stream(propertyKeys).mapToInt(this::propId).toArray()));
    }

    private IndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        try (StorageReader reader = this.storageEngine.newReader();){
            IndexDescriptor indexDescriptor = (IndexDescriptor)Iterators.singleOrNull((Iterator)reader.indexGetForSchema(descriptor));
            return indexDescriptor;
        }
    }

    private void assertRule(IndexDescriptor rule, String label, String propertyKey, boolean isUnique) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(label)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(propertyKey)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)isUnique, (Object)rule.isUnique());
    }

    private void assertRule(ConstraintDescriptor constraint, String label, String propertyKey, ConstraintType type) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)constraint, (int)this.labelId(label)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)constraint, (int)this.propId(propertyKey)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)type, (Object)constraint.type());
    }

    private int labelId(String labelName) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().nodeLabel(labelName);
            return n;
        }
    }

    private int propId(String propName) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().propertyKey(propName);
            return n;
        }
    }

    private static Consumer<Transaction> index(String label, String prop) {
        return tx -> tx.schema().indexFor(Label.label((String)label)).on(prop).create();
    }

    private static Consumer<Transaction> uniquenessConstraint(String label, String prop) {
        return tx -> tx.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(prop).create();
    }

    @SafeVarargs
    private void createSchema(Consumer<Transaction> ... creators) {
        try (Transaction tx = this.db.beginTx();){
            for (Consumer<Transaction> rule : creators) {
                rule.accept(tx);
            }
            tx.commit();
        }
        this.awaitIndexes();
    }

    private void awaitIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
    }
}

