/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogTracers;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadUtils;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryStartV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryStartV5_20;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.arguments.KernelVersionSource;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class LogEntrySerializerDispatcherTest {
    private final CommandReaderFactory commandReader = TestCommandReaderFactory.INSTANCE;
    private final LogPositionMarker marker = new LogPositionMarker();
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;

    LogEntrySerializerDispatcherTest() {
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="5.7")
    void writeAndParseChunksEntries(KernelVersion version) throws IOException {
        Path path = this.directory.createFile("a");
        StoreChannel storeChannel = this.fs.write(path);
        LogFormat logFormat = LogFormat.fromKernelVersion((KernelVersion)version);
        LogHeader logHeader = logFormat.newHeader(1L, 2L, -1L, StoreId.UNKNOWN, logFormat.getDefaultSegmentBlockSize(), -559063315, version);
        LogFormat.writeLogHeader((StoreChannel)storeChannel, (LogHeader)logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, logHeader, path, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL);
             PhysicalFlushableLogPositionAwareChannel writeChannel = new PhysicalFlushableLogPositionAwareChannel((LogVersionedStoreChannel)versionedStoreChannel, logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            LogEntryWriter entryWriter = new LogEntryWriter((WritableChannel)writeChannel, LatestVersions.BINARY_VERSIONS);
            entryWriter.writeStartEntry(version, 1L, 2L, 3L, 4, ArrayUtils.EMPTY_BYTE_ARRAY);
            entryWriter.writeChunkEndEntry(version, 17L, 13L);
            entryWriter.writeChunkStartEntry(version, 11L, 13L, 4L, 15L);
            entryWriter.writeCommitEntry(version, 7L, 8L);
        }
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.BINARY_VERSIONS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (ReadableLogChannel readChannel = ReadAheadUtils.newChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), 1L, logFormat, path, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL), (LogVersionBridge)LogVersionBridge.NO_MORE_CHANNELS, (LogHeader)logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            readChannel.position(logHeader.getStartPosition().getByteOffset());
            LogEntry startEntry = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
            LogEntry chunkEnd = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
            LogEntry chunkStart = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
            LogEntry commitEnd = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
            Assertions.assertThat((Object)startEntry).isInstanceOf(LogEntryStart.class);
            Assertions.assertThat((Object)commitEnd).isInstanceOf(LogEntryCommit.class);
            Assertions.assertThat((Object)chunkEnd).isInstanceOf(LogEntryChunkEnd.class);
            LogEntryChunkEnd chunkEndEntry = (LogEntryChunkEnd)chunkEnd;
            org.junit.jupiter.api.Assertions.assertEquals((long)17L, (long)chunkEndEntry.getTransactionId());
            org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)chunkEndEntry.getChunkId());
            Assertions.assertThat((Object)chunkStart).isInstanceOf(LogEntryChunkStart.class);
            LogEntryChunkStart chunkStartEntry = (LogEntryChunkStart)chunkStart;
            org.junit.jupiter.api.Assertions.assertEquals((long)11L, (long)chunkStartEntry.getTimeWritten());
            org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)chunkStartEntry.getChunkId());
        }
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="4.2")
    void parseStartEntry(KernelVersion version) throws IOException {
        LogEntryStart start = LogEntryFactory.newStartEntry((KernelVersion)version, (long)1L, (long)2L, (long)3L, (int)4, (byte[])new byte[]{4});
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        if (start instanceof LogEntryStartV4_2) {
            LogEntryStartV4_2 v42 = (LogEntryStartV4_2)start;
            channel.putInt(v42.getPreviousChecksum());
        } else if (start instanceof LogEntryStartV5_20) {
            LogEntryStartV5_20 v520 = (LogEntryStartV5_20)start;
            channel.putInt(v520.getPreviousChecksum());
        }
        if (version.isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED)) {
            channel.putLong(start.getAppendIndex());
        }
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        channel.getCurrentLogPosition(this.marker);
        LogEntrySerializer parser = LogEntrySerializationSets.serializationSet((KernelVersion)version, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)1);
        LogEntry logEntry = parser.parse(version, (ReadableChannel)channel, this.marker, this.commandReader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)start, (Object)logEntry);
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="4.2")
    void parseCorruptedStartEntry(KernelVersion version) throws IOException {
        LogEntryStart start = LogEntryFactory.newStartEntry((KernelVersion)version, (long)1L, (long)2L, (long)3L, (int)4, (byte[])new byte[]{4});
        try (InMemoryClosableChannel channel = new InMemoryClosableChannel();){
            channel.putLong(start.getTimeWritten());
            channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
            if (start instanceof LogEntryStartV4_2) {
                LogEntryStartV4_2 v42 = (LogEntryStartV4_2)start;
                channel.putInt(v42.getPreviousChecksum());
            } else if (start instanceof LogEntryStartV5_20) {
                LogEntryStartV5_20 v520 = (LogEntryStartV5_20)start;
                channel.putInt(v520.getPreviousChecksum());
            }
            if (version.isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED)) {
                channel.putLong(start.getAppendIndex());
            }
            channel.putInt(Integer.MAX_VALUE);
            channel.getCurrentLogPosition(this.marker);
            LogEntrySerializer parser = LogEntrySerializationSets.serializationSet((KernelVersion)version, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)1);
            Assertions.assertThatThrownBy(() -> parser.parse(version, (ReadableChannel)channel, this.marker, this.commandReader, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isInstanceOf(IOException.class);
        }
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="4.2")
    void parseCommitEntry(KernelVersion version) throws IOException {
        HashMap<KernelVersion, Integer> expectedChecksums = new HashMap<KernelVersion, Integer>();
        expectedChecksums.put(KernelVersion.V4_2, -852558083);
        expectedChecksums.put(KernelVersion.V4_3_D4, -1832246622);
        expectedChecksums.put(KernelVersion.V4_4, 144196046);
        expectedChecksums.put(KernelVersion.V5_0, 1467784593);
        expectedChecksums.put(KernelVersion.V5_7, -1219364496);
        expectedChecksums.put(KernelVersion.V5_8, -390781649);
        expectedChecksums.put(KernelVersion.V5_9, -2045163175);
        expectedChecksums.put(KernelVersion.V5_10, -637692666);
        expectedChecksums.put(KernelVersion.V5_11, 969994727);
        expectedChecksums.put(KernelVersion.V5_12, 1714695608);
        expectedChecksums.put(KernelVersion.V5_13, -60404012);
        expectedChecksums.put(KernelVersion.V5_14, -1551723893);
        expectedChecksums.put(KernelVersion.V5_15, 1135605354);
        expectedChecksums.put(KernelVersion.V5_18, 474688053);
        expectedChecksums.put(KernelVersion.V5_19, -1627967866);
        expectedChecksums.put(KernelVersion.V5_20, -1055657255);
        expectedChecksums.put(KernelVersion.V5_22, 557749816);
        expectedChecksums.put(KernelVersion.V5_23, 2128235111);
        expectedChecksums.put(KernelVersion.V5_25, -460838645);
        expectedChecksums.put(KernelVersion.V2025_04, -1150487212);
        expectedChecksums.put(KernelVersion.V2025_05, 1531023797);
        if (version.isAtLeast(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_GUARANTEED)) {
            expectedChecksums.put(KernelVersion.V2025_07, -361070784);
        } else {
            expectedChecksums.put(KernelVersion.V2025_07, 77942250);
        }
        LogEntryCommit commit = LogEntryFactory.newCommitEntry((KernelVersion)version, (long)42L, (long)21L, (int)((Integer)expectedChecksums.get(version)));
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.beginChecksumForWriting();
        channel.putVersion(version.version());
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.putChecksum();
        channel.getCurrentLogPosition(this.marker);
        byte readVersion = channel.getVersion();
        LogEntrySerializer parser = LogEntrySerializationSets.serializationSet((KernelVersion)version, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)5);
        LogEntry logEntry = parser.parse(version, (ReadableChannel)channel, this.marker, this.commandReader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertEquals((byte)version.version(), (byte)readVersion);
        org.junit.jupiter.api.Assertions.assertEquals((Object)commit, (Object)logEntry);
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="4.2")
    void shouldParserCommandsUsingAGivenFactory(KernelVersion version) throws IOException {
        TestCommand testCommand = new TestCommand(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        LogEntryCommand command = new LogEntryCommand((StorageCommand)testCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        testCommand.serialize((WritableChannel)channel);
        channel.getCurrentLogPosition(this.marker);
        LogEntrySerializer parser = LogEntrySerializationSets.serializationSet((KernelVersion)version, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)3);
        LogEntry logEntry = parser.parse(version, (ReadableChannel)channel, this.marker, this.commandReader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertEquals((Object)command, (Object)logEntry);
    }

    @ParameterizedTest
    @EnumSource
    void shouldThrowWhenParsingUnknownEntry(KernelVersion version) {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> LogEntrySerializationSets.serializationSet((KernelVersion)version, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)42));
    }
}

