/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collections;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.Subject;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.transaction.log.CompleteCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.FileLogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@DbmsExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogFileIT {
    private static final StoreId STORE_ID = new StoreId(1L, 2L, "engine-1", "format-1", 3, 4);
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    @Inject
    private LogVersionRepository logVersionRepository;
    @Inject
    private MetadataProvider metadataProvider;

    TransactionLogFileIT() {
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void doNotScanDirectoryOnRotate() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER, (LogFormatVersionProvider)LatestVersions.LATEST_LOG_FORMAT_PROVIDER).withTransactionIdStore((TransactionIdStore)this.metadataProvider).withAppendIndexProvider((AppendIndexProvider)this.metadataProvider).withLogVersionRepository(this.logVersionRepository).withStoreId(STORE_ID).build();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        final MutableLong rotationObservedVersion = new MutableLong();
        LogRotation logRotation = FileLogRotation.transactionLogRotation((LogFile)logFiles.getLogFile(), (Clock)Clock.systemUTC(), (Panic)new DatabaseHealth(HealthEventGenerator.NO_OP, (InternalLog)NullLog.getInstance()), (LogRotationMonitor)new LogRotationMonitorAdapter(this){

            public void startRotation(LogRotationMonitor.LogType type, long currentLogVersion) {
                rotationObservedVersion.setValue(currentLogVersion);
            }
        }, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER);
        for (int i = 0; i < 6; ++i) {
            for (Path path : logFiles.logFiles()) {
                FileUtils.deleteFile((Path)path);
            }
            logRotation.rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (Long)rotationObservedVersion.getValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)6L, (long)logFiles.getLogFile().getCurrentLogVersion());
    }

    @Test
    void rotateUsesCorrectAppendIndexAndChecksum() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER, (LogFormatVersionProvider)LatestVersions.LATEST_LOG_FORMAT_PROVIDER).withTransactionIdStore((TransactionIdStore)this.metadataProvider).withAppendIndexProvider((AppendIndexProvider)this.metadataProvider).withLogVersionRepository(this.logVersionRepository).withStoreId(STORE_ID).build();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        long appendIndex = this.metadataProvider.nextAppendIndex();
        TransactionLogWriter writer = logFiles.getLogFile().getTransactionLogWriter();
        CompleteCommandBatch simpleTransaction = new CompleteCommandBatch(Collections.singletonList(new TestCommand(LatestVersions.LATEST_KERNEL_VERSION)), -1L, -1L, -1L, -1L, -1, LatestVersions.LATEST_KERNEL_VERSION, Subject.AUTH_DISABLED);
        int checksum = writer.append((CommandBatch)simpleTransaction, appendIndex, 0L, appendIndex, -1, 0L, LogAppendEvent.NULL);
        final MutableLong rotationObservedVersion = new MutableLong();
        LogRotation logRotation = FileLogRotation.transactionLogRotation((LogFile)logFiles.getLogFile(), (Clock)Clock.systemUTC(), (Panic)new DatabaseHealth(HealthEventGenerator.NO_OP, (InternalLog)NullLog.getInstance()), (LogRotationMonitor)new LogRotationMonitorAdapter(this){

            public void startRotation(LogRotationMonitor.LogType type, long currentLogVersion) {
                rotationObservedVersion.setValue(currentLogVersion);
            }
        }, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER);
        logRotation.rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
        LogHeader header = logFiles.getLogFile().extractHeader(logFiles.getLogFile().getCurrentLogVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)this.metadataProvider.getLastAppendIndex(), (long)header.getLastAppendIndex());
        if (header.getLogFormatVersion().usesSegments()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)checksum, (int)header.getPreviousLogFileChecksum());
        }
        long testAppendIndex = this.metadataProvider.getLastAppendIndex() + 101L;
        int testCRC = 789;
        logRotation.rotateLogFile((LogRotateEvents)LogAppendEvent.NULL, testAppendIndex, testCRC);
        LogHeader header2 = logFiles.getLogFile().extractHeader(logFiles.getLogFile().getCurrentLogVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)testAppendIndex, (long)header2.getLastAppendIndex());
        if (header2.getLogFormatVersion().usesSegments()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)testCRC, (int)header2.getPreviousLogFileChecksum());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void trackTransactionLogFileMemory() throws IOException {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (KernelVersionProvider)LatestVersions.LATEST_KERNEL_VERSION_PROVIDER, (LogFormatVersionProvider)LatestVersions.LATEST_LOG_FORMAT_PROVIDER).withTransactionIdStore((TransactionIdStore)this.metadataProvider).withLogVersionRepository(this.logVersionRepository).withAppendIndexProvider((AppendIndexProvider)this.metadataProvider).withStoreId(STORE_ID).withMemoryTracker((MemoryTracker)memoryTracker).build();
        life.add((Lifecycle)logFiles);
        try {
            life.start();
            Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isZero();
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isGreaterThan(0L);
        }
        finally {
            life.stop();
            life.shutdown();
        }
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
        Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isZero();
    }
}

