/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFileVersionTracker;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SkipOnSpd;

@DbmsExtension(configurationCallback="addVersionTracker")
@SkipOnSpd(reason="Collides with CDC service on enterprise edition")
class LogPruningIT {
    private static final SimpleTriggerInfo triggerInfo = new SimpleTriggerInfo("forced trigger");
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private LogFiles logFiles;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private Config config;
    private final TestVersionTracker versionTracker = TestVersionTracker.create();

    LogPruningIT() {
    }

    @ExtensionCallback
    void addVersionTracker(TestDatabaseManagementServiceBuilder builder) {
        builder.addExtension((ExtensionFactory)new TestVersionTrackerExtensionFactory(this.versionTracker));
    }

    @Test
    void pruningStrategyShouldBeDynamic() throws IOException {
        this.writeTransactionsAndRotateTwice();
        this.checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        Assertions.assertThat((int)LogPruningIT.countTransactionLogs(this.logFiles)).isEqualTo(4);
        this.config.setDynamic(GraphDatabaseSettings.keep_logical_logs, (Object)"false", "LogPruningIT");
        this.checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        Assertions.assertThat((int)LogPruningIT.countTransactionLogs(this.logFiles)).isEqualTo(2);
        ((AbstractLongArrayAssert)Assertions.assertThat((long[])this.versionTracker.rotations.toArray()).as("should have tracked the 2 log rotations", new Object[0])).containsExactly(new long[]{0L, 1L});
        ((AbstractLongArrayAssert)Assertions.assertThat((long[])this.versionTracker.deletions.toArray()).as("should have tracked the 2 log prunes", new Object[0])).containsExactly(new long[]{0L, 1L});
    }

    @Test
    void entryCountThresholdShouldKeepTheSpecifiedNumberOfEntries() throws IOException {
        this.writeTransactionsAndRotateTwice();
        this.writeTransactionsAndRotateTwice();
        this.config.setDynamic(GraphDatabaseSettings.keep_logical_logs, (Object)"6 entries", "LogPruningIT");
        this.checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        Assertions.assertThat((int)this.logFiles.getLogFile().getMatchedFiles().length).isEqualTo(3);
        ((AbstractLongArrayAssert)Assertions.assertThat((long[])this.versionTracker.rotations.toArray()).as("should have tracked the 4 log rotations", new Object[0])).containsExactly(new long[]{0L, 1L, 2L, 3L});
        ((AbstractLongArrayAssert)Assertions.assertThat((long[])this.versionTracker.deletions.toArray()).as("should have tracked the 2 log prunes", new Object[0])).containsExactly(new long[]{0L, 1L});
    }

    private void writeTransactionsAndRotateTwice() throws IOException {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.logFiles.getLogFile().getLogRotation().rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.logFiles.getLogFile().getLogRotation().rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.createNode();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static int countTransactionLogs(LogFiles logFiles) throws IOException {
        return logFiles.logFiles().length;
    }

    private record TestVersionTracker(MutableLongList deletions, MutableLongList rotations) implements LogFileVersionTracker
    {
        static TestVersionTracker create() {
            return new TestVersionTracker(LongLists.mutable.empty().asSynchronized(), LongLists.mutable.empty().asSynchronized());
        }

        public void logDeleted(long version) {
            this.deletions.add(version);
        }

        public void logCompleted(LogPosition endLogPosition) {
            this.rotations.add(endLogPosition.getLogVersion());
        }
    }

    private static class TestVersionTrackerExtensionFactory
    extends ExtensionFactory<Dependencies> {
        private final TestVersionTracker versionTracker;

        TestVersionTrackerExtensionFactory(TestVersionTracker versionTracker) {
            super(ExtensionType.DATABASE, "versionTrackerExtension");
            this.versionTracker = versionTracker;
        }

        public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
            context.dependencySatisfier().satisfyDependency((Object)this.versionTracker);
            return new LifeSupport();
        }

        static interface Dependencies {
        }
    }
}

