/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.StoreFileListing;
import org.neo4j.kernel.impl.store.StoreFileProvider;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.utils.TestDirectory;

@DbmsExtension
class StoreFileListingTest {
    private final Predicate<Path> DEFAULT_FILENAME_FILTER = IOUtils.uncheckedPredicate(TransactionLogFiles.DEFAULT_FILENAME_FILTER::accept);
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction filesystem;
    @Inject
    private Database database;

    StoreFileListingTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.createIndexDbFile();
    }

    @Test
    void shouldCloseIndexSnapshots() throws Exception {
        String indexDir = "indexes";
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        DatabaseLayout databaseLayout = (DatabaseLayout)Mockito.mock(DatabaseLayout.class);
        Mockito.when((Object)databaseLayout.pathForStore((CommonDatabaseStores)ArgumentMatchers.eq((Object)CommonDatabaseStores.METADATA))).thenReturn((Object)((Path)Mockito.mock(Path.class)));
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        StoreFileListing fileListing = new StoreFileListing(databaseLayout, logFiles, indexingService, storageEngine);
        ResourceIterator<Path> indexSnapshot = StoreFileListingTest.indexFilesAre(indexingService, new String[]{indexDir + "/mock/my.index"});
        ResourceIterator result = fileListing.builder().excludeLogFiles().build();
        result.close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    @Test
    void shouldListMetaDataStoreLast() throws Exception {
        Path fileMetadata = (Path)Iterators.last((Iterator)this.database.listStoreFiles(false));
        org.junit.jupiter.api.Assertions.assertEquals((Object)fileMetadata, (Object)this.database.getDatabaseLayout().pathForStore(CommonDatabaseStores.METADATA));
    }

    @Test
    void shouldListMetaDataStoreLastWithTxLogs() throws Exception {
        Path fileMetadata = (Path)Iterators.last((Iterator)this.database.listStoreFiles(true));
        org.junit.jupiter.api.Assertions.assertEquals((Object)fileMetadata, (Object)this.database.getDatabaseLayout().pathForStore(CommonDatabaseStores.METADATA));
    }

    @Test
    void shouldListTxLogFiles() throws Exception {
        try (ResourceIterator storeFiles = this.database.listStoreFiles(true);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)storeFiles.stream().map(Path::getFileName).anyMatch(this.DEFAULT_FILENAME_FILTER));
        }
    }

    @Test
    void shouldNotListTxLogFiles() throws Exception {
        try (ResourceIterator storeFiles = this.database.listStoreFiles(false);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)storeFiles.stream().map(Path::getFileName).noneMatch(this.DEFAULT_FILENAME_FILTER));
        }
    }

    @Test
    void shouldListStoreFiles() throws Exception {
        DatabaseLayout layout = this.database.getDatabaseLayout();
        StoreFileListing.Builder fileListingBuilder = this.database.getStoreFileListing().builder();
        fileListingBuilder.excludeIdFiles();
        fileListingBuilder.excludeLogFiles();
        fileListingBuilder.excludeSchemaIndexStoreFiles();
        try (ResourceIterator storeFiles = fileListingBuilder.build();){
            HashSet<Path> files = new HashSet<Path>();
            while (storeFiles.hasNext()) {
                files.add((Path)storeFiles.next());
            }
            Assertions.assertThat(files).contains((Object[])new Path[]{layout.metadataStore()});
            Assertions.assertThat((int)files.size()).isGreaterThan(1);
        }
    }

    @Test
    void shouldListIdFiles() throws Exception {
        DatabaseLayout layout = this.database.getDatabaseLayout();
        StoreFileListing.Builder fileListingBuilder = this.database.getStoreFileListing().builder();
        fileListingBuilder.excludeAll();
        fileListingBuilder.includeIdFiles();
        try (ResourceIterator storeFiles = fileListingBuilder.build();){
            Assertions.assertThat((Iterator)storeFiles).hasNext();
        }
    }

    @Test
    void doNotListFilesFromAdditionalProviderThatRegisterTwice() throws IOException {
        StoreFileListing storeFileListing = this.database.getStoreFileListing();
        MarkerFileProvider provider = new MarkerFileProvider();
        storeFileListing.registerStoreFileProvider((StoreFileProvider)provider);
        storeFileListing.registerStoreFileProvider((StoreFileProvider)provider);
        try (ResourceIterator storeFiles = storeFileListing.builder().build();){
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)storeFiles.stream().filter(metadata -> "marker".equals(metadata.getFileName().toString())).count());
        }
    }

    private static ResourceIterator<Path> indexFilesAre(IndexingService indexingService, String[] fileNames) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        StoreFileListingTest.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)indexingService.snapshotIndexFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void createIndexDbFile() throws IOException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        Path indexFile = databaseLayout.file(Path.of("index.db", new String[0]));
        this.filesystem.write(indexFile).close();
    }

    private static void mockFiles(String[] filenames, List<Path> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            Path path = (Path)Mockito.mock(Path.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            Mockito.when((Object)path.toFile()).thenReturn((Object)file);
            files.add(path);
        }
    }

    private static class MarkerFileProvider
    implements StoreFileProvider {
        private MarkerFileProvider() {
        }

        public Resource addFilesTo(Collection<Path> fileMetadataCollection) {
            fileMetadataCollection.add(Path.of("marker", new String[0]));
            return Resource.EMPTY;
        }
    }
}

