/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.PageCacheTracerAssertions;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class FullScanStoreViewTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LockService lockService;
    @Inject
    private StorageEngine storageEngine;
    @Inject
    private JobScheduler jobScheduler;

    FullScanStoreViewTracingIT() {
    }

    @Test
    void tracePageCacheAccess() {
        int nodeCount = 1000;
        Label label = Label.label((String)"marker");
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)10));
            }
            tx.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        FullScanStoreView indexStoreView = new FullScanStoreView(this.lockService, (ReadableStorageEngine)this.storageEngine, Config.defaults(), this.jobScheduler);
        try (StoreScan storeScan = indexStoreView.visitNodes(ArrayUtils.EMPTY_INT_ARRAY, PropertySelection.ALL_PROPERTIES, null, (TokenScanConsumer)new TestTokenScanConsumer(), true, true, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        }
        PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.database).record(PageCacheTracerAssertions.pins((long)103L).noFaults()).block(PageCacheTracerAssertions.pins((long)128L).noFaults()).spd(PageCacheTracerAssertions.pins((long)114L).noFaults()).matches((PageCacheCounters)pageCacheTracer);
    }
}

