/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.transaction.state.storeview.TokenIndexScanIdIterator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TokenIndexScanIdIteratorTest {
    @Inject
    GraphDatabaseAPI db;
    @Inject
    IndexingService indexingService;

    TokenIndexScanIdIteratorTest() {
    }

    @Test
    void shouldFindNodesWithAnyOfGivenLabels() throws Exception {
        IndexDescriptor index;
        int labelId1 = 3;
        int labelId2 = 5;
        int labelId3 = 13;
        try (Transaction tx = this.db.beginTx();){
            index = ((IndexDefinitionImpl)Iterables.stream((Iterable)tx.schema().getIndexes()).filter(IndexDefinition::isNodeIndex).findFirst().get()).getIndexReference();
        }
        IndexProxy indexProxy = this.indexingService.getIndexProxy(index);
        try (IndexUpdater indexUpdater = indexProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, false);){
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)2L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId1, labelId2}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)1L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId1}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)4L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId1, labelId3}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)5L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId1, labelId2, labelId3}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)3L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId1}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)7L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId2}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)8L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId3}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)6L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId2}));
            indexUpdater.process((IndexEntryUpdate)TokenIndexEntryUpdate.tokenChange((long)9L, (IndexDescriptor)index, (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{labelId3}));
        }
        try (TokenIndexReader indexReader = indexProxy.newTokenReader();){
            Assertions.assertThat((long[])TokenIndexScanIdIteratorTest.findAllWithTokens(indexReader, new int[]{labelId1, labelId2})).isEqualTo((Object)new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L});
            Assertions.assertThat((long[])TokenIndexScanIdIteratorTest.findAllWithTokens(indexReader, new int[]{labelId1, labelId3})).isEqualTo((Object)new long[]{1L, 2L, 3L, 4L, 5L, 8L, 9L});
            Assertions.assertThat((long[])TokenIndexScanIdIteratorTest.findAllWithTokens(indexReader, new int[]{labelId1, labelId2, labelId3})).isEqualTo((Object)new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        }
    }

    private static long[] findAllWithTokens(TokenIndexReader indexReader, int[] tokens) {
        TokenIndexScanIdIterator iter = new TokenIndexScanIdIterator(indexReader, tokens, CursorContext.NULL_CONTEXT);
        MutableLongList found = LongLists.mutable.empty();
        while (iter.hasNext()) {
            found.add(iter.next());
        }
        return found.toArray(new long[0]);
    }
}

