/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SkipOnSpd;

@ImpermanentDbmsExtension(configurationCallback="configuration")
public class OutOfDiskSpaceMonitoringIT {
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private DatabaseEventContext eventContext;
    @Inject
    private DatabaseHealth databaseHealth;
    @Inject
    private GraphDatabaseService db;
    @Inject
    private DatabaseManagementService dbms;

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
        DatabaseEventListenerAdapter listener = new DatabaseEventListenerAdapter(){

            public void databaseOutOfDiskSpace(DatabaseEventContext event) {
                OutOfDiskSpaceMonitoringIT.this.eventContext = event;
            }
        };
        builder.addDatabaseListener((DatabaseEventListener)listener);
        builder.setInternalLogProvider((InternalLogProvider)this.logProvider);
    }

    @Test
    @SkipOnSpd(reason="ODP uses config-based readonly which is disabled on SPD")
    void shouldPropagateOutOfDiskSpaceEventToRegisteredListener() {
        this.databaseHealth.outOfDiskSpace((Throwable)new RuntimeException("Leeeroooy!"));
        Assertions.assertThat((Object)this.eventContext).isNotNull();
        Assertions.assertThat((String)this.eventContext.getDatabaseName()).isEqualTo("neo4j");
    }

    @Test
    @SkipOnSpd(reason="ODP uses config-based readonly which is disabled on SPD")
    void shouldPutDatabaseIntoReadOnlyState() {
        this.databaseHealth.outOfDiskSpace((Throwable)new RuntimeException("C'mon Leroy, it's not funny!"));
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThatThrownBy(() -> ((Transaction)tx).createNode()).hasMessageContaining("No write operations are allowed on this database. The database is in read-only mode on this Neo4j instance.");
            tx.commit();
        }
    }

    @Test
    void shouldLogAboutOutOfDiskSpace() {
        RuntimeException cause = new RuntimeException("Again Leroy?!");
        this.databaseHealth.outOfDiskSpace((Throwable)cause);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Database out of disk space: "}).containsMessages(new String[]{"The database was unable to allocate enough disk space."}).containsException((Throwable)cause);
    }

    @Test
    void shouldLogAboutReadOnly() {
        RuntimeException cause = new RuntimeException("Leroy, please...");
        this.databaseHealth.outOfDiskSpace((Throwable)cause);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"As a result of the database failing to allocate enough disk space, it has been put into read-only mode to protect from system failure and ensure data integrity. ", "Please free up more disk space before changing access mode for database back to read-write state. ", "Making database writable again can be done by:", "    CALL dbms.listConfig(\"" + GraphDatabaseSettings.read_only_databases.name() + "\") YIELD value", "    WITH value", "    CALL dbms.setConfigValue(\"" + GraphDatabaseSettings.read_only_databases.name() + "\", replace(value, \"<databaseName>\", \"\"))"});
    }

    @Test
    void outOfDiskSpaceOnSystemDbShouldNotAffectReadOnly() {
        RuntimeException cause = new RuntimeException("System db exception");
        GraphDatabaseAPI system = (GraphDatabaseAPI)this.dbms.database("system");
        DatabaseHealth systemHealth = (DatabaseHealth)system.getDependencyResolver().resolveDependency(DatabaseHealth.class);
        systemHealth.outOfDiskSpace((Throwable)cause);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Database out of disk space: "}).containsMessages(new String[]{"The database was unable to allocate enough disk space."}).containsException((Throwable)cause).doesNotContainMessage("has been put into read-only mode");
        try (Transaction tx = system.beginTx();){
            Assertions.assertThatNoException().isThrownBy(() -> ((Transaction)tx).createNode());
            tx.commit();
        }
    }
}

