/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Subject;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleAppendIndexProvider;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.CompleteCommandBatch;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadAheadUtils;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v522.DetachedCheckpointLogEntrySerializerV5_22;
import org.neo4j.kernel.impl.transaction.log.enveloped.InvalidLogEnvelopeReadException;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.VersionedFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.SkipOnSpd;

@SkipOnSpd(reason="Assertions are quite specific tx log characteristic of a single db and starting db on failed recovery throws explicit exception in SPD setup, not in single-db setup")
@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class RecoveryCorruptedTransactionLogIT {
    private int CHECKPOINT_RECORD_SIZE;
    private LogCommandSerialization LATEST_LOG_SERIALIZATION;
    private BinarySupportedKernelVersions BINARY_VERSIONS;
    private Config CONFIG;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomSupport random;
    private static final int HEADER_OFFSET = LatestVersions.LATEST_LOG_FORMAT.getHeaderSize();
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private final RecoveryMonitor recoveryMonitor = new RecoveryMonitor();
    private final CorruptedCheckpointMonitor corruptedFilesMonitor = new CorruptedCheckpointMonitor();
    private final Monitors monitors = new Monitors();
    private LogFiles logFiles;
    private TestDatabaseManagementServiceBuilder databaseFactory;
    private StorageEngineFactory storageEngineFactory;
    private long txOffsetAfterStart;

    RecoveryCorruptedTransactionLogIT() {
    }

    @BeforeEach
    void setUp() {
        this.CHECKPOINT_RECORD_SIZE = this.checkpointRecordSize();
        this.LATEST_LOG_SERIALIZATION = RecordStorageCommandReaderFactory.INSTANCE.get(this.kernelVersion());
        this.CONFIG = Config.defaults(this.additionalConfig());
        this.BINARY_VERSIONS = new BinarySupportedKernelVersions(this.CONFIG);
        this.monitors.addMonitorListener((Object)this.recoveryMonitor, new String[0]);
        this.monitors.addMonitorListener((Object)this.corruptedFilesMonitor, new String[0]);
        this.databaseFactory = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setConfig(this.additionalConfig()).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)25).setInternalLogProvider((InternalLogProvider)this.logProvider).setMonitors(this.monitors).setFileSystem((FileSystemAbstraction)this.fileSystem);
        this.txOffsetAfterStart = this.startStopDatabaseAndGetTxOffset();
    }

    protected int checkpointRecordSize() {
        return DetachedCheckpointLogEntrySerializerV5_22.checkPointRecordSizeDependingOnVersion((boolean)false);
    }

    protected KernelVersion kernelVersion() {
        return LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES;
    }

    protected Map<Setting<?>, Object> additionalConfig() {
        return Map.of(GraphDatabaseInternalSettings.latest_kernel_version, LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES.version(), GraphDatabaseInternalSettings.latest_runtime_version, LatestVersions.LATEST_RUNTIME_VERSION_WITHOUT_ENVELOPES.getVersion(), GraphDatabaseInternalSettings.allow_new_log_format_on_upgrade_or_create, false);
    }

    @Test
    void recoverFromLastCorruptedNotFullyWrittenCheckpointRecord() throws IOException {
        for (int iteration = 0; iteration < 10; ++iteration) {
            int bytesToTrim = this.random.nextInt(1, this.CHECKPOINT_RECORD_SIZE);
            DatabaseManagementService managementService = this.databaseFactory.build();
            GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
            this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
            TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
            LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
            long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
            for (int i = 0; i < 10; ++i) {
                RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            }
            long numberOfClosedTransactions = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database).getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
            databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 1L, this.kernelVersion(), logOffsetBeforeTestTransactions, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
            managementService.shutdown();
            this.truncateBytesFromLastCheckpointLogFile(bytesToTrim);
            this.startStopDbRecoveryOfCorruptedLogs();
            Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).hasSize(1);
            Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
            this.removeDatabaseDirectories();
        }
    }

    protected int minimumBytesToConsiderARecordBroken() {
        return 3;
    }

    @Test
    void recoverFromLastCorruptedBrokenCheckpointRecord() throws IOException {
        for (int iteration = 0; iteration < 10; ++iteration) {
            int bytesToAdd = this.random.nextInt(this.minimumBytesToConsiderARecordBroken(), this.CHECKPOINT_RECORD_SIZE + 1);
            DatabaseManagementService managementService = this.databaseFactory.build();
            GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
            this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
            TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
            LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
            long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
            for (int i = 0; i < 10; ++i) {
                RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            }
            long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
            databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 1L, this.kernelVersion(), logOffsetBeforeTestTransactions, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
            managementService.shutdown();
            this.removeLastCheckpointRecordFromLastLogFile();
            this.appendRandomBytesAfterLastCheckpointRecordFromLastLogFile(bytesToAdd);
            this.startStopDbRecoveryOfCorruptedLogs();
            Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            Assertions.assertEquals((int)(iteration + 1), (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
            LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).hasSize(1);
            this.removeDatabaseDirectories();
        }
    }

    @Test
    void recoverFromLastCorruptedBrokenCheckpointRecordButNotReachingEndOfFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
        databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 1L, this.kernelVersion(), logOffsetBeforeTestTransactions, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
        managementService.shutdown();
        this.replacePartOfCheckpointWithZeroes();
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).hasSize(1);
        this.removeDatabaseDirectories();
    }

    @Test
    void recoverWithNoValidCheckpoints() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        managementService.shutdown();
        this.replacePartOfFirstCheckpointAndRestOfFileWithZeroes();
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).hasSize(1);
        LogAssertions.assertThat((List)this.logFiles.getCheckpointFile().reachableCheckpoints()).hasSize(2);
        this.removeDatabaseDirectories();
    }

    @Test
    void recoverWithNoCheckpointFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        managementService.shutdown();
        this.fileSystem.deleteFile(this.logFiles.getCheckpointFile().getCurrentFile());
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).hasSize(1);
        LogAssertions.assertThat((List)this.logFiles.getCheckpointFile().reachableCheckpoints()).hasSize(2);
        this.removeDatabaseDirectories();
    }

    @Test
    void recoverWithSingleCheckpointFileWithBrokenHeader() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        managementService.shutdown();
        Path currentCheckpointFile = this.logFiles.getCheckpointFile().getLogFileForVersion(0L);
        this.fileSystem.truncate(currentCheckpointFile, 12L);
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).hasSize(1);
        LogAssertions.assertThat((List)this.logFiles.getCheckpointFile().reachableCheckpoints()).hasSize(2);
        this.removeDatabaseDirectories();
    }

    @Test
    void doNotRotateIfRecoveryIsRequiredButThereAreNoUnreadableData() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        CheckpointFile databaseCheckpointer = ((TransactionLogFiles)dependencyResolver.resolveDependency(TransactionLogFiles.class)).getCheckpointFile();
        databaseCheckpointer.getCheckpointAppender().checkPoint(LogCheckPointEvent.NULL, transactionIdStore.getLastCommittedTransaction(), transactionIdStore.getLastCommittedTransaction().id() + 7L, this.kernelVersion(), logOffsetBeforeTestTransactions, logOffsetBeforeTestTransactions, Instant.now(), "Fallback checkpoint.");
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.startStopDatabase();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((int)0, (int)this.corruptedFilesMonitor.getNumberOfCorruptedCheckpointFiles());
        LogAssertions.assertThat((Object[])this.logFiles.getCheckpointFile().getMatchedFiles()).hasSize(1);
    }

    @Test
    void evenTruncateNewerTransactionLogFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database).getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomNonZeroByte);
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void doNotTruncateNewerTransactionLogFileWhenFailOnError() throws IOException {
        DatabaseManagementService managementService1 = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService1.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        managementService1.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomInvalidVersionsBytes, Math.max(this.minimumBytesToConsiderARecordBroken(), 10));
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).rootCause().isInstanceOfAny(new Class[]{UnsupportedLogVersionException.class, InvalidLogEnvelopeReadException.class});
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void truncateNewerTransactionLogFileWhenForced() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long numberOfClosedTransactionsAfterStartup = transactionIdStore.getLastClosedTransactionId();
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long lastTxSize = 0L;
        long totalTxSize = 0L;
        for (int i = 0; i < 10; ++i) {
            long size;
            lastTxSize = size = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            totalTxSize += size;
        }
        long numberOfTransactionsToRecover = transactionIdStore.getLastClosedTransactionId() - numberOfClosedTransactionsAfterStartup;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        Supplier<Byte> randomBytesSupplier = this::randomInvalidVersionsBytes;
        BytesCaptureSupplier capturingSupplier = new BytesCaptureSupplier(randomBytesSupplier);
        this.addRandomBytesToLastLogFile(capturingSupplier, Math.max(this.minimumBytesToConsiderARecordBroken(), 10));
        Assertions.assertFalse((boolean)this.recoveryMonitor.wasRecoveryRequired());
        this.startStopDbRecoveryOfCorruptedLogs();
        try {
            Assertions.assertEquals((long)numberOfTransactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            Assertions.assertTrue((boolean)this.recoveryMonitor.wasRecoveryRequired());
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Fail to read transaction log version 0. Last valid transaction start offset is: " + (totalTxSize - lastTxSize + this.txOffsetAfterStart) + "."});
        }
        catch (Throwable t) {
            throw new RuntimeException("Generated random bytes: " + String.valueOf(capturingSupplier.getCapturedBytes()), t);
        }
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverFirstCorruptedTransactionSingleFileNoCheckpoint(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover database. Any transactional logs after position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "} can not be recovered and will be truncated."});
        this.logFiles = this.buildDefaultLogFiles(new StoreId(4L, 5L, "engine-1", "format-1", 1, 2));
        Assertions.assertEquals((long)0L, (long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion());
        if (NativeAccessProvider.getNativeAccess().isAvailable()) {
            Assertions.assertEquals((long)ByteUnit.mebiBytes((long)1L), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        } else {
            Assertions.assertEquals((long)(this.getLastFileStartPosition(this.logFiles.getLogFile()).getByteOffset() + (long)(this.CHECKPOINT_RECORD_SIZE * 4)), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        }
    }

    @Test
    void failToStartWithTransactionLogsWithDataAfterLastEntry() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 6}));
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").message().containsAnyOf(new CharSequence[]{"Failure to read transaction log file number 0. Unreadable bytes are encountered after last readable position.", "Invalid envelope type: 6"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startWithTransactionLogsWithDataAfterLastEntryAndCorruptedLogsRecoveryEnabled() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        long initialTransactionOffset = this.txOffsetAfterStart + txSize;
        Assertions.assertEquals((long)initialTransactionOffset, (long)RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(database));
        this.logFiles = this.buildDefaultLogFiles(database);
        Path transactionLogFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
        LogPosition position = this.getLastReadablePosition((Path)transactionLogFile).lastReadable;
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(transactionLogFile, position, () -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
        managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        try {
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + initialTransactionOffset + "}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").message().containsAnyOf(new CharSequence[]{"Failure to read transaction log file number 0. Unreadable bytes are encountered after last readable position.", "Envelope span segment boundary", "Unexpected data found at end of buffer at position"});
            GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertEquals((long)initialTransactionOffset, (long)RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(restartedDb));
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void failToStartWithNotLastTransactionLogHavingZerosInTheEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
            this.logFiles.getLogFile().rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has 50 unreadable bytes");
    }

    @Test
    void startWithNotLastTransactionLogHavingZerosInTheEndAndCorruptedLogRecoveryEnabled() throws IOException {
        long originalLogDataLength;
        Path firstLogFile;
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            LogFile logFile = this.logFiles.getLogFile();
            LogPosition readablePosition = this.getLastReadablePosition(logFile);
            firstLogFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
            originalLogDataLength = readablePosition.getByteOffset();
            logFile.rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(firstLogFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)originalLogDataLength, (long)this.fileSystem.getFileSize(firstLogFile));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + (txSize + this.txOffsetAfterStart) + "}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessage("Transaction log files with version 0 has 50 unreadable bytes. Was able to read upto " + (txSize + this.txOffsetAfterStart) + " but " + (txSize + 50L + this.txOffsetAfterStart) + " is available.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void restoreCheckpointLogVersionFromFileVersion() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        int rotations = 10;
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
            DetachedCheckpointAppender checkpointAppender = (DetachedCheckpointAppender)checkpointFile.getCheckpointAppender();
            for (int i = 0; i < rotations; ++i) {
                checkpointAppender.checkPoint(LogCheckPointEvent.NULL, TransactionIdStore.UNKNOWN_TRANSACTION_ID, TransactionIdStore.UNKNOWN_TRANSACTION_ID.id() + 8L, this.kernelVersion(), new LogPosition(0L, (long)HEADER_OFFSET), new LogPosition(0L, (long)HEADER_OFFSET), Instant.now(), "test" + i);
                checkpointAppender.rotate();
            }
        }
        for (int i = rotations - 1; i > 0; --i) {
            DatabaseManagementService restartedDbms = this.databaseFactory.build();
            try {
                MetadataProvider metadataProvider = (MetadataProvider)((GraphDatabaseAPI)restartedDbms.database("neo4j")).getDependencyResolver().resolveDependency(MetadataProvider.class);
                Assertions.assertEquals((long)i, (long)metadataProvider.getCheckpointLogVersion());
            }
            finally {
                restartedDbms.shutdown();
            }
            this.removeLastCheckpointRecordFromLastLogFile();
            this.removeLastCheckpointRecordFromLastLogFile();
            this.removeLastCheckpointRecordFromLastLogFile();
        }
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void detectCorruptedCheckpointFileWithDataAfterLastRecord() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        this.appendDataAfterLastCheckpointRecordFromLastLogFile();
        DatabaseManagementService dbms = this.databaseFactory.build();
        try {
            StandaloneDatabaseContext context = this.getDefaultDbContext(dbms);
            Assertions.assertFalse((boolean)context.database().isStarted());
            Assertions.assertTrue((boolean)context.isFailed());
            LogAssertions.assertThat((Throwable)context.failureCause()).rootCause().hasMessageContaining("Checkpoint log file with version 0 has some data available after last readable log entry.");
        }
        finally {
            dbms.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void detectAndStartWithCorruptedCheckpointFileWithDataAfterLastRecord() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        LogPosition logPosition = this.appendDataAfterLastCheckpointRecordFromLastLogFile();
        DatabaseManagementService dbms = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        try {
            StandaloneDatabaseContext context = this.getDefaultDbContext(dbms);
            Assertions.assertTrue((boolean)context.database().isStarted());
            LogAssertions.assertThat((long)Files.size(this.logFiles.getCheckpointFile().getLogFileForVersion(logPosition.getLogVersion()))).isEqualTo(logPosition.getByteOffset() + (long)this.CHECKPOINT_RECORD_SIZE);
        }
        finally {
            dbms.shutdown();
        }
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEndAndCorruptedLogFilesRecoveryEnabled() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruption() throws IOException {
        this.addCorruptedCommandsToLastLogFile(CorruptedLogEntryWriter::new);
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(NegativeArraySizeException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruptionVersion() throws IOException {
        this.addCorruptedCommandsToLastLogFile(CorruptedLogEntryVersionWriter::new);
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(UnsupportedLogVersionException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionSingleFileNoCheckpoint(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        long txSizes = 0L;
        for (int i = 0; i < 10; ++i) {
            txSizes += RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
        Positions positions = this.getLastReadablePosition(highestLogFile);
        long originalFileLength = positions.lastReadable.getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=0, byteOffset=" + (txSizes + this.txOffsetAfterStart) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)0L, (long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion());
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)(positions.startPosition.getByteOffset() + (long)(4 * this.CHECKPOINT_RECORD_SIZE)), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionMultipleFilesNoCheckpoints(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 3);
        long additionalTxSizes = 0L;
        for (int i = 0; i < 7; ++i) {
            additionalTxSizes += RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
        Positions positions = this.getLastReadablePosition(highestLogFile);
        long originalFileLength = positions.lastReadable.getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=3, byteOffset=" + (txSize + additionalTxSizes + positions.startPosition.getByteOffset()) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion());
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)(positions.startPosition.getByteOffset() + (long)(4 * this.CHECKPOINT_RECORD_SIZE)), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionMultipleFilesMultipleCheckpoints(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long transactionsToRecover = 7L;
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotateWithCheckpoint(database, 3);
        long additionalTxSizes = 0L;
        int i = 0;
        while ((long)i < transactionsToRecover) {
            additionalTxSizes += RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            ++i;
        }
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
        Positions positions = this.getLastReadablePosition(highestLogFile);
        long originalFileLength = positions.lastReadable.getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=3, byteOffset=" + (txSize + positions.startPosition.getByteOffset()) + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=3, byteOffset=" + (txSize + additionalTxSizes + positions.startPosition.getByteOffset()) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion());
        Assertions.assertEquals((long)transactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)(positions.startPosition.getByteOffset() + (long)(7 * this.CHECKPOINT_RECORD_SIZE)), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverFirstCorruptedTransactionAfterCheckpointInLastLogFile(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        long txSize = RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 5);
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
        Positions positions = this.getLastReadablePosition(highestLogFile);
        long originalFileLength = positions.lastReadable.getByteOffset();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 5.", "Recovery required from position LogPosition{logVersion=5, byteOffset=" + (txSize + positions.startPosition.getByteOffset()) + "}", "Fail to recover database. Any transactional logs after position LogPosition{logVersion=5, byteOffset=" + (txSize + positions.startPosition.getByteOffset()) + "} can not be recovered and will be truncated."});
        Assertions.assertEquals((long)5L, (long)this.logFiles.getLogFile().getLogRangeInfo().highestVersion());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        if (NativeAccessProvider.getNativeAccess().isAvailable()) {
            Assertions.assertEquals((long)ByteUnit.mebiBytes((long)1L), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        } else {
            Assertions.assertEquals((long)(positions.startPosition.getByteOffset() + (long)(5 * this.CHECKPOINT_RECORD_SIZE)), (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
        }
    }

    @Test
    void repetitiveRecoveryOfCorruptedLogs() throws IOException {
        DatabaseManagementService service = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)service.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 4, false);
        service.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        for (int expectedRecoveredTransactions = 7; expectedRecoveredTransactions > 0; --expectedRecoveredTransactions) {
            this.truncateBytesFromLastLogFile(1 + this.random.nextInt(10));
            this.startStopDbRecoveryOfCorruptedLogs();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            Assertions.assertEquals((int)expectedRecoveredTransactions, (int)numberOfRecoveredTransactions);
            this.removeLastCheckpointRecordFromLastLogFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void dontTruncateOnCorruptedLogsWithoutSettingForZeroByteInWrongPlace() throws IOException {
        Assumptions.assumeTrue((boolean)this.kernelVersion().isLessThan(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_GUARANTEED));
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        LogPosition logOffsetAfterTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        for (int i = 0; i < 2; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        LogFiles logFiles1 = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        TransactionLogWriter transactionLogWriter = logFiles1.getLogFile().getTransactionLogWriter();
        FlushableLogPositionAwareChannel channel = transactionLogWriter.getChannel();
        LogPositionMarker logPositionMarker = new LogPositionMarker();
        logPositionMarker.mark(logOffsetAfterTestTransactions.getLogVersion(), logOffsetAfterTestTransactions.getByteOffset());
        channel.setLogPosition(logPositionMarker);
        channel.putLong(0L);
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        managementService = this.databaseFactory.build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((String)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get()).getCause().getMessage()).contains(new CharSequence[]{"Unreadable bytes are encountered after last readable position."});
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void truncateOnCorruptedLogsWithSettingForZeroByteInWrongPlace() throws IOException {
        Assumptions.assumeTrue((boolean)this.kernelVersion().isLessThan(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_GUARANTEED));
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        LogPosition logOffsetBeforeTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        LogPosition logOffsetAfterTestTransactions = transactionIdStore.getLastClosedTransaction().logPosition();
        for (int i = 0; i < 2; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        DependencyResolver dependencyResolver = database.getDependencyResolver();
        LogFiles logFiles1 = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        TransactionLogWriter transactionLogWriter = logFiles1.getLogFile().getTransactionLogWriter();
        FlushableLogPositionAwareChannel channel = transactionLogWriter.getChannel();
        LogPositionMarker logPositionMarker = new LogPositionMarker();
        logPositionMarker.mark(logOffsetAfterTestTransactions.getLogVersion(), logOffsetAfterTestTransactions.getByteOffset());
        channel.setLogPosition(logPositionMarker);
        channel.putLong(0L);
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + logOffsetBeforeTestTransactions.getByteOffset() + "}", "Fail to recover database.", "Any transactional logs after position LogPosition{logVersion=0, byteOffset=" + logOffsetAfterTestTransactions.getByteOffset() + "} can not be recovered and will be truncated."});
    }

    @Test
    void shouldRecoverWithMalformedSchema() throws Exception {
        GraphDatabaseAPI database;
        DatabaseLayout databaseLayout;
        try (DatabaseManagementService dbms = this.databaseFactory.build();){
            Node node;
            GraphDatabaseAPI database2 = (GraphDatabaseAPI)dbms.database("neo4j");
            databaseLayout = database2.databaseLayout();
            Label person = Label.label((String)"Person");
            String name = "name";
            try (Transaction tx = database2.beginTx();){
                node = tx.createNode(new Label[]{person});
                node.setProperty(name, (Object)"John");
                tx.commit();
            }
            tx = database2.beginTx();
            try {
                tx.schema().indexFor(person).on(name).create();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = database2.beginTx();
            try {
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            ((CheckPointerImpl)database2.getDependencyResolver().resolveDependency(CheckPointerImpl.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
            tx = database2.beginTx();
            try {
                node = tx.createNode(new Label[]{person});
                node.setProperty(name, (Object)"Lisa");
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            this.logFiles = this.buildDefaultLogFiles(RecoveryCorruptedTransactionLogIT.getStoreId(database2));
        }
        this.removeLastCheckpointRecordFromLastLogFile();
        Path schemaStore = databaseLayout.pathForStore(CommonDatabaseStores.SCHEMAS);
        byte[] data = FileSystemUtils.readAllBytes((FileSystemAbstraction)this.fileSystem, (Path)schemaStore, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int numPages = data.length / 8192;
        if (numPages > 1) {
            for (int i = 0; i < data.length - 5; ++i) {
                if (!"INDEX".equals(new String(data, i, 5))) continue;
                data[i] = 105;
            }
        } else {
            Arrays.fill(data, (numPages - 1) * 8192, numPages * 8192, (byte)-1);
        }
        FileSystemUtils.writeAllBytes((FileSystemAbstraction)this.fileSystem, (Path)schemaStore, (byte[])data, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (DatabaseManagementService dbms = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.ignore_corrupt_schema, (Object)false).build();){
            database = (GraphDatabaseAPI)dbms.database("neo4j");
            LogAssertions.assertThat((boolean)database.isAvailable()).isFalse();
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Exception occurred while starting the database"});
        }
        LogAssertions.assertThat((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)databaseLayout, (Config)this.CONFIG, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isTrue();
        dbms = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.ignore_corrupt_schema, (Object)true).build();
        try {
            database = (GraphDatabaseAPI)dbms.database("neo4j");
            ((AbstractBooleanAssert)LogAssertions.assertThat((boolean)database.isAvailable()).as(() -> ((AssertableLogProvider)this.logProvider).serialize())).isTrue();
        }
        finally {
            if (dbms != null) {
                dbms.close();
            }
        }
        LogAssertions.assertThat((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)databaseLayout, (Config)this.CONFIG, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isFalse();
    }

    private static StoreId getStoreId(GraphDatabaseAPI database) {
        return ((StoreIdProvider)database.getDependencyResolver().resolveDependency(StoreIdProvider.class)).getStoreId();
    }

    private static TransactionIdStore getTransactionIdStore(GraphDatabaseAPI database) {
        return (TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private void removeLastCheckpointRecordFromLastLogFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).checkpointEntryPosition();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getLogFileForVersion(logPosition.getLogVersion()));){
                storeChannel.truncate(logPosition.getByteOffset());
            }
        }
    }

    private void replacePartOfCheckpointWithZeroes() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).checkpointEntryPosition();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getLogFileForVersion(logPosition.getLogVersion()));){
                storeChannel.position(logPosition.getByteOffset() + 15L);
                storeChannel.writeAll(ByteBuffers.allocate((int)this.CHECKPOINT_RECORD_SIZE, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            }
        }
    }

    private void replacePartOfFirstCheckpointAndRestOfFileWithZeroes() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        List checkpoints = checkpointFile.reachableCheckpoints();
        if (!checkpoints.isEmpty()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoints.get(0)).checkpointEntryPosition();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getLogFileForVersion(logPosition.getLogVersion()));){
                long corruptionPoint = logPosition.getByteOffset() + 15L;
                long lastPoint = ((CheckpointInfo)checkpoints.get(checkpoints.size() - 1)).checkpointFilePostReadPosition().getByteOffset();
                storeChannel.position(corruptionPoint);
                storeChannel.writeAll(ByteBuffers.allocate((int)((int)(lastPoint - corruptionPoint)), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            }
        }
    }

    private LogPosition appendDataAfterLastCheckpointRecordFromLastLogFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).channelPositionAfterCheckpoint();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getLogFileForVersion(logPosition.getLogVersion()));){
                storeChannel.position(logPosition.getByteOffset() + 300L);
                storeChannel.writeAll(ByteBuffer.wrap("DeaD BeaF".getBytes()));
            }
            return logPosition;
        }
        return LogPosition.UNSPECIFIED;
    }

    private void appendRandomBytesAfterLastCheckpointRecordFromLastLogFile(int bytesToAdd) throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).channelPositionAfterCheckpoint();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getLogFileForVersion(logPosition.getLogVersion()));){
                storeChannel.position(logPosition.getByteOffset());
                byte[] array = new byte[bytesToAdd];
                do {
                    this.random.nextBytes(array);
                    array[0] = (byte)this.random.nextInt((int)KernelVersion.EARLIEST.version(), LatestVersions.LATEST_KERNEL_VERSION.version() + 1);
                } while (!this.checkpointEntryLooksCorrupted(array));
                storeChannel.writeAll(ByteBuffer.wrap(array));
            }
        }
    }

    private boolean checkpointEntryLooksCorrupted(byte[] array) {
        VersionAwareLogEntryReader testReader = new VersionAwareLogEntryReader(version -> null, this.BINARY_VERSIONS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        InMemoryVersionableReadableClosablePositionAwareChannel ch = new InMemoryVersionableReadableClosablePositionAwareChannel();
        ch.putVersion(array[0]);
        ch.putAll(ByteBuffer.wrap(array).position(1));
        try {
            testReader.readLogEntry((ReadableLogPositionAwareChannel)ch);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void truncateBytesFromLastCheckpointLogFile(long bytesToTrim) throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).channelPositionAfterCheckpoint();
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getLogFileForVersion(logPosition.getLogVersion()));){
                storeChannel.truncate(logPosition.getByteOffset() - bytesToTrim);
            }
        }
    }

    private void truncateBytesFromLastLogFile(long bytesToTrim) throws IOException {
        if (this.logFiles.getLogFile().getLogRangeInfo().highestVersion() > 0L) {
            Path highestLogFile = this.logFiles.getLogFile().getLogRangeInfo().highestFile();
            long readableOffset = this.getLastReadablePosition((Path)highestLogFile).lastReadable.getByteOffset();
            if (bytesToTrim > readableOffset) {
                this.fileSystem.deleteFile(highestLogFile);
                if (this.logFiles.logFiles().length > 0) {
                    this.truncateBytesFromLastLogFile(bytesToTrim);
                }
            } else {
                this.fileSystem.truncate(highestLogFile, readableOffset - bytesToTrim);
            }
        }
    }

    private void writeRandomBytesAfterLastCommandInLastLogFile(Supplier<ByteBuffer> source) throws IOException {
        this.writeRandomBytesAfterLastCommandInLastLogFile(source, 10);
    }

    private void writeRandomBytesAfterLastCommandInLastLogFile(Supplier<ByteBuffer> source, int bytesToAdd) throws IOException {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            LogPosition position = this.getLastReadablePosition(transactionLogFile);
            try (StoreFileChannel writeChannel = this.fileSystem.write(transactionLogFile.getLogRangeInfo().highestFile());){
                writeChannel.position(position.getByteOffset());
                for (int i = 0; i < bytesToAdd; ++i) {
                    writeChannel.writeAll(source.get());
                }
            }
        }
    }

    private void writeRandomBytesAfterLastCommandInLastLogFile(Path transactionLogFile, LogPosition position, Supplier<ByteBuffer> source) throws IOException {
        int someRandomPaddingAfterEndOfDataInLogFile = this.random.nextInt(1, 10);
        try (StoreFileChannel writeChannel = this.fileSystem.write(transactionLogFile);){
            writeChannel.position(position.getByteOffset() + (long)someRandomPaddingAfterEndOfDataInLogFile);
            for (int i = 0; i < 10; ++i) {
                writeChannel.writeAll(source.get());
            }
        }
    }

    private Positions getLastReadablePosition(Path logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory(), this.BINARY_VERSIONS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        LogFile txLogFile = this.logFiles.getLogFile();
        long logVersion = txLogFile.getLogVersion(logFile);
        LogPosition startPosition = txLogFile.extractHeader(logVersion).getStartPosition();
        try (ReadableLogChannel reader = this.openTransactionFileChannel(logVersion, startPosition);){
            while (entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader) != null) {
            }
        }
        catch (IncompleteLogHeaderException e) {
            return new Positions(startPosition, new LogPosition(logVersion, 0L));
        }
        return new Positions(startPosition, entryReader.lastPosition());
    }

    private LogPosition getLastFileStartPosition(LogFile logFile) throws IOException {
        return logFile.extractHeader(this.logFiles.getLogFile().getLogRangeInfo().highestVersion()).getStartPosition();
    }

    private ReadableLogChannel openTransactionFileChannel(long logVersion, LogPosition startPosition) throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        ReadableLogChannel channel = ReadAheadUtils.newChannel((VersionedFile)logFile, (long)logVersion, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        channel.position(startPosition.getByteOffset());
        return channel;
    }

    private LogPosition getLastReadablePosition(LogFile logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory(), this.BINARY_VERSIONS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        LogPosition startPosition = logFile.extractHeader(this.logFiles.getLogFile().getLogRangeInfo().highestVersion()).getStartPosition();
        try (ReadableLogChannel reader = logFile.getReader(startPosition);){
            while (entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader) != null) {
            }
        }
        return entryReader.lastPosition();
    }

    private void addRandomBytesToLastLogFile(Supplier<Byte> byteSource) throws IOException {
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{(Byte)byteSource.get()}));
    }

    private void addRandomBytesToLastLogFile(Supplier<Byte> byteSource, int bytesToAdd) throws IOException {
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{(Byte)byteSource.get()}), bytesToAdd);
    }

    private byte randomInvalidVersionsBytes() {
        int highestVersionByte = KernelVersion.VERSIONS.stream().filter(version -> version != KernelVersion.GLORIOUS_FUTURE).mapToInt(KernelVersion::version).max().orElseThrow();
        return (byte)this.random.nextInt(highestVersionByte + 1, 127);
    }

    private byte randomNonZeroByte() {
        byte b = (byte)this.random.nextInt(-128, 127);
        if (b != 0) {
            return b;
        }
        return 127;
    }

    private void addCorruptedCommandsToLastLogFile(LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        SimpleLogVersionRepository versionRepository = new SimpleLogVersionRepository(RecoveryCorruptedTransactionLogIT.getInitialVersion(this.logFiles), 0L);
        LogFiles internalLogFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, this::kernelVersion, () -> LogFormat.fromKernelVersion((KernelVersion)this.kernelVersion())).withLogVersionRepository((LogVersionRepository)versionRepository).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withAppendIndexProvider((AppendIndexProvider)new SimpleAppendIndexProvider()).withStoreId(new StoreId(4L, 5L, "engine-1", "format-1", 1, 2)).withStorageEngineFactory(StorageEngineFactory.selectStorageEngine((Configuration)this.CONFIG)).withConfig(this.CONFIG).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{internalLogFiles});){
            LogFile transactionLogFile = internalLogFiles.getLogFile();
            LogEntryWriter realLogEntryWriter = transactionLogFile.getTransactionLogWriter().getWriter();
            LogEntryWriter wrappedLogEntryWriter = logEntryWriterWrapper.wrap(realLogEntryWriter, this.BINARY_VERSIONS);
            TransactionLogWriter writer = new TransactionLogWriter((FlushableLogPositionAwareChannel)realLogEntryWriter.getChannel(), wrappedLogEntryWriter, this::kernelVersion, LogRotation.NO_ROTATION);
            ArrayList<Object> commands = new ArrayList<Object>();
            commands.add(new Command.PropertyCommand(this.LATEST_LOG_SERIALIZATION, new PropertyRecord(1L), new PropertyRecord(2L)));
            commands.add(new Command.NodeCommand(this.LATEST_LOG_SERIALIZATION, new NodeRecord(2L), new NodeRecord(3L)));
            CompleteCommandBatch transaction = new CompleteCommandBatch(commands, -1L, 0L, 0L, 0L, 0, this.kernelVersion(), Subject.ANONYMOUS);
            writer.append((CommandBatch)transaction, 1000L, 1001L, 0L, -559063315, 0L, LogAppendEvent.NULL);
        }
    }

    private static long getInitialVersion(LogFiles logFiles) {
        return logFiles == null ? 0L : logFiles.getLogFile().getLogRangeInfo().highestVersion();
    }

    private static long getLastClosedTransactionOffset(GraphDatabaseAPI database) {
        return RecoveryCorruptedTransactionLogIT.getLastClosedTransaction(database).getByteOffset();
    }

    private static LogPosition getLastClosedTransaction(GraphDatabaseAPI database) {
        MetadataProvider metaDataStore = (MetadataProvider)database.getDependencyResolver().resolveDependency(MetadataProvider.class);
        return metaDataStore.getLastClosedTransaction().logPosition();
    }

    private LogFiles buildDefaultLogFiles(StoreId storeId) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, this::kernelVersion, () -> LogFormat.fromKernelVersion((KernelVersion)this.kernelVersion())).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withAppendIndexProvider((AppendIndexProvider)new SimpleAppendIndexProvider()).withStoreId(storeId).withLogProvider((InternalLogProvider)this.logProvider).withStorageEngineFactory(StorageEngineFactory.selectStorageEngine((Configuration)this.CONFIG)).withConfig(this.CONFIG).build();
    }

    private LogFiles buildDefaultLogFiles(GraphDatabaseAPI database) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, this::kernelVersion, () -> LogFormat.fromKernelVersion((KernelVersion)this.kernelVersion())).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withDependencies(database.getDependencyResolver()).withLogProvider((InternalLogProvider)this.logProvider).build();
    }

    private static long generateTransactionsAndRotateWithCheckpoint(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        return RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, true);
    }

    private static long generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        return RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, false);
    }

    private static long generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate, boolean checkpoint) throws IOException {
        DependencyResolver resolver = database.getDependencyResolver();
        LogFiles logFiles = (LogFiles)resolver.resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)resolver.resolveDependency(CheckPointer.class);
        long lastTxSize = -1L;
        while (logFiles.getLogFile().getLogRangeInfo().highestVersion() < (long)logFilesToGenerate) {
            logFiles.getLogFile().rotate();
            lastTxSize = RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            if (!checkpoint) continue;
            checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("testForcedCheckpoint"));
        }
        return lastTxSize;
    }

    private static long generateTransaction(GraphDatabaseAPI database) throws IOException {
        LogPosition lastTx = RecoveryCorruptedTransactionLogIT.getLastClosedTransaction(database);
        LogFiles logFiles = (LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        long initialOffset = logFile.getCurrentLogVersion() > lastTx.getLogVersion() ? logFile.extractHeader(logFile.getCurrentLogVersion()).getStartPosition().getByteOffset() : lastTx.getByteOffset();
        try (Transaction transaction = database.beginTx();){
            Node startNode = transaction.createNode(new Label[]{Label.label((String)"startNode")});
            startNode.setProperty("key", (Object)"value");
            Node endNode = transaction.createNode(new Label[]{Label.label((String)"endNode")});
            endNode.setProperty("key", (Object)"value");
            startNode.createRelationshipTo(endNode, RelationshipType.withName((String)"connects"));
            transaction.commit();
        }
        return RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(database) - initialOffset;
    }

    private void startStopDbRecoveryOfCorruptedLogs() {
        DatabaseManagementService managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        managementService.shutdown();
    }

    private void startStopDatabase() {
        DatabaseManagementService managementService = this.databaseFactory.build();
        this.storageEngineFactory = (StorageEngineFactory)((GraphDatabaseAPI)managementService.database("neo4j")).getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        managementService.shutdown();
    }

    private long startStopDatabaseAndGetTxOffset() {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.storageEngineFactory = (StorageEngineFactory)database.getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        long offset = RecoveryCorruptedTransactionLogIT.getLastClosedTransactionOffset(database);
        managementService.shutdown();
        return offset;
    }

    private void removeDatabaseDirectories() throws IOException {
        this.fileSystem.delete(this.databaseLayout.databaseDirectory());
        this.fileSystem.delete(this.databaseLayout.getTransactionLogsDirectory());
    }

    private StandaloneDatabaseContext getDefaultDbContext(DatabaseManagementService dbms) {
        return (StandaloneDatabaseContext)((DatabaseContextProvider)((GraphDatabaseAPI)dbms.database("system")).getDependencyResolver().resolveDependency(DatabaseContextProvider.class)).getDatabaseContext("neo4j").orElseThrow();
    }

    private static Stream<Arguments> corruptedLogEntryWriters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"CorruptedLogEntryWriter", CorruptedLogEntryWriter::new}), Arguments.of((Object[])new Object[]{"CorruptedLogEntryVersionWriter", CorruptedLogEntryVersionWriter::new}));
    }

    private static class RecoveryMonitor
    implements org.neo4j.kernel.recovery.RecoveryMonitor {
        private final List<Long> recoveredBatches = new ArrayList<Long>();
        private int numberOfRecoveredTransactions;
        private final AtomicBoolean recoveryRequired = new AtomicBoolean();

        private RecoveryMonitor() {
        }

        public void recoveryRequired(RecoveryStartInformation recoveryStartInfo) {
            this.recoveryRequired.set(true);
            this.numberOfRecoveredTransactions = 0;
        }

        public void batchRecovered(CommittedCommandBatchRepresentation committedBatch) {
            this.recoveredBatches.add(committedBatch.txId());
            if (committedBatch.commandBatch().isLast()) {
                ++this.numberOfRecoveredTransactions;
            }
        }

        boolean wasRecoveryRequired() {
            return this.recoveryRequired.get();
        }

        int getNumberOfRecoveredTransactions() {
            return this.numberOfRecoveredTransactions;
        }
    }

    private static class CorruptedCheckpointMonitor
    implements LogTailScannerMonitor {
        private final AtomicInteger corruptedFileCounter = new AtomicInteger();

        private CorruptedCheckpointMonitor() {
        }

        public void corruptedLogFile(long version, Throwable t) {
        }

        public void corruptedCheckpointFile(long version, Throwable t) {
            this.corruptedFileCounter.incrementAndGet();
        }

        int getNumberOfCorruptedCheckpointFiles() {
            return this.corruptedFileCounter.get();
        }
    }

    private static class BytesCaptureSupplier
    implements Supplier<Byte> {
        private final Supplier<Byte> generator;
        private final List<Byte> capturedBytes = new ArrayList<Byte>();

        BytesCaptureSupplier(Supplier<Byte> generator) {
            this.generator = generator;
        }

        @Override
        public Byte get() {
            Byte data = this.generator.get();
            this.capturedBytes.add(data);
            return data;
        }

        public List<Byte> getCapturedBytes() {
            return this.capturedBytes;
        }
    }

    @FunctionalInterface
    private static interface LogEntryWriterWrapper {
        default public <T extends WritableChannel> LogEntryWriter<T> wrap(LogEntryWriter<T> logEntryWriter, BinarySupportedKernelVersions versions) {
            return this.to(logEntryWriter.getChannel(), versions);
        }

        public <T extends WritableChannel> LogEntryWriter<T> to(T var1, BinarySupportedKernelVersions var2);
    }

    record Positions(LogPosition startPosition, LogPosition lastReadable) {
    }

    private static class CorruptedLogEntryVersionWriter<T extends WritableChannel>
    extends LogEntryWriter<T> {
        CorruptedLogEntryVersionWriter(T channel, BinarySupportedKernelVersions versions) {
            super(channel, versions);
        }

        public void writeStartEntry(KernelVersion version, long timeWritten, long latestCommittedTxWhenStarted, long appendIndex, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            byte nonExistingLogEntryVersion = (byte)(LatestVersions.LATEST_KERNEL_VERSION.version() + 10);
            this.channel.beginChecksumForWriting();
            this.channel.putVersion(nonExistingLogEntryVersion).put((byte)1);
            this.channel.putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(previousChecksum).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
        }

        public int writeCommitEntry(KernelVersion kernelVersion, long transactionId, long timeWritten) throws IOException {
            byte nonExistingLogEntryVersion = (byte)(LatestVersions.LATEST_KERNEL_VERSION.version() + 10);
            this.channel.putVersion(nonExistingLogEntryVersion).put((byte)5);
            this.channel.putLong(transactionId).putLong(timeWritten);
            return this.channel.putChecksum();
        }
    }

    private static class CorruptedLogEntryWriter<T extends WritableChannel>
    extends LogEntryWriter<T> {
        CorruptedLogEntryWriter(T channel, BinarySupportedKernelVersions versions) {
            super(channel, versions);
        }

        public void writeStartEntry(KernelVersion version, long timeWritten, long latestCommittedTxWhenStarted, long appendIndex, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            this.channel.beginChecksumForWriting();
            this.channel.putVersion(version.version()).put((byte)1);
        }
    }
}

