/*
 * Decompiled with CFR 0.152.
 */
package counts;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class RebuildCountsTest {
    private static final int ALIENS = 16;
    private static final int HUMANS = 16;
    private static final Label ALIEN = Label.label((String)"Alien");
    private static final Label HUMAN = Label.label((String)"Human");
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final InMemoryIndexProvider indexProvider = new InMemoryIndexProvider(100);
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    private GraphDatabaseService db;
    private final File storeDir = new File("store").getAbsoluteFile();

    @Test
    public void shouldRebuildMissingCountsStoreOnStart() throws IOException, TransactionFailureException {
        this.createAliensAndHumans();
        FileSystemAbstraction fs = this.shutdown();
        this.deleteCounts(fs);
        this.restart(fs);
        try (Transaction tx = ((Kernel)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            Assert.assertEquals((long)32L, (long)tx.dataRead().countsForNode(-1));
            Assert.assertEquals((long)16L, (long)tx.dataRead().countsForNode(this.labelId(ALIEN)));
            Assert.assertEquals((long)16L, (long)tx.dataRead().countsForNode(this.labelId(HUMAN)));
        }
        AssertableLogProvider.LogMatcherBuilder matcherBuilder = AssertableLogProvider.inLog(MetaDataStore.class);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{matcherBuilder.warn("Missing counts store, rebuilding it.")});
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{matcherBuilder.warn("Counts store rebuild completed.")});
    }

    @Test
    public void shouldRebuildMissingCountsStoreAfterRecovery() throws IOException, TransactionFailureException {
        this.createAliensAndHumans();
        this.rotateLog();
        this.deleteHumans();
        FileSystemAbstraction fs = this.crash();
        this.deleteCounts(fs);
        this.restart(fs);
        try (Transaction tx = ((Kernel)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            Assert.assertEquals((long)16L, (long)tx.dataRead().countsForNode(-1));
            Assert.assertEquals((long)16L, (long)tx.dataRead().countsForNode(this.labelId(ALIEN)));
            Assert.assertEquals((long)0L, (long)tx.dataRead().countsForNode(this.labelId(HUMAN)));
        }
        AssertableLogProvider.LogMatcherBuilder matcherBuilder = AssertableLogProvider.inLog(MetaDataStore.class);
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{matcherBuilder.warn("Missing counts store, rebuilding it.")});
        this.internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{matcherBuilder.warn("Counts store rebuild completed.")});
    }

    private void createAliensAndHumans() {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            int i;
            for (i = 0; i < 16; ++i) {
                this.db.createNode(new Label[]{ALIEN});
            }
            for (i = 0; i < 16; ++i) {
                this.db.createNode(new Label[]{HUMAN});
            }
            tx.success();
        }
    }

    private void deleteHumans() {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            try (ResourceIterator humans = this.db.findNodes(HUMAN);){
                while (humans.hasNext()) {
                    ((Node)humans.next()).delete();
                }
            }
            tx.success();
        }
    }

    private int labelId(Label alien) {
        ThreadToStatementContextBridge contextBridge = (ThreadToStatementContextBridge)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            int n = contextBridge.getKernelTransactionBoundToThisThread(true).tokenRead().nodeLabel(alien.name());
            return n;
        }
    }

    private void deleteCounts(FileSystemAbstraction snapshot) {
        File storeFileBase = new File(this.storeDir, "neostore.counts.db");
        File alpha = new File(storeFileBase + ".a");
        File beta = new File(storeFileBase + ".b");
        Assert.assertTrue((boolean)snapshot.deleteFile(alpha));
        Assert.assertTrue((boolean)snapshot.deleteFile(beta));
    }

    private FileSystemAbstraction shutdown() {
        this.doCleanShutdown();
        return ((EphemeralFileSystemAbstraction)this.fsRule.get()).snapshot();
    }

    private void rotateLog() throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private FileSystemAbstraction crash() {
        return ((EphemeralFileSystemAbstraction)this.fsRule.get()).snapshot();
    }

    private void restart(FileSystemAbstraction fs) throws IOException {
        if (this.db != null) {
            this.db.shutdown();
        }
        fs.mkdirs(this.storeDir);
        TestGraphDatabaseFactory dbFactory = new TestGraphDatabaseFactory();
        this.db = dbFactory.setUserLogProvider((LogProvider)this.userLogProvider).setInternalLogProvider((LogProvider)this.internalLogProvider).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fs)).setKernelExtensions(Arrays.asList(new InMemoryIndexProviderFactory((IndexProvider)this.indexProvider))).newImpermanentDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.index_background_sampling_enabled, "false").newGraphDatabase();
    }

    private void doCleanShutdown() {
        try {
            this.db.shutdown();
        }
        finally {
            this.db = null;
        }
    }

    @Before
    public void before() throws IOException {
        this.restart(this.fsRule.get());
    }

    @After
    public void after() {
        this.doCleanShutdown();
    }
}

