/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class GraphDatabaseInternalLogIT {
    private static final String INTERNAL_LOG_FILE = "debug.log";
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();

    @Test
    public void shouldWriteToInternalDiagnosticsLog() throws Exception {
        new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDir.graphDbDir()).setConfig(GraphDatabaseSettings.logs_directory, this.testDir.directory("logs").getAbsolutePath()).newGraphDatabase().shutdown();
        File internalLog = new File(this.testDir.directory("logs"), INTERNAL_LOG_FILE);
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "Database is now ready"));
        Assert.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "Database is now unavailable"));
    }

    @Test
    public void shouldNotWriteDebugToInternalDiagnosticsLogByDefault() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDir.graphDbDir()).setConfig(GraphDatabaseSettings.logs_directory, this.testDir.directory("logs").getAbsolutePath()).newGraphDatabase();
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        db.shutdown();
        File internalLog = new File(this.testDir.directory("logs"), INTERNAL_LOG_FILE);
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((long)0L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A debug entry"));
    }

    @Test
    public void shouldWriteDebugToInternalDiagnosticsLogForEnabledContexts() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDir.graphDbDir()).setConfig(GraphDatabaseSettings.store_internal_debug_contexts, this.getClass().getName() + ",java.io").setConfig(GraphDatabaseSettings.logs_directory, this.testDir.directory("logs").getAbsolutePath()).newGraphDatabase();
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        logService.getInternalLog(GraphDatabaseService.class).debug("A GDS debug entry");
        logService.getInternalLog(StringWriter.class).debug("A SW debug entry");
        db.shutdown();
        File internalLog = new File(this.testDir.directory("logs"), INTERNAL_LOG_FILE);
        MatcherAssert.assertThat((Object)internalLog.isFile(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)internalLog.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A debug entry"));
        Assert.assertEquals((long)0L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A GDS debug entry"));
        Assert.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A SW debug entry"));
    }

    private static long countOccurrences(File file, String substring) throws IOException {
        try (Stream<String> lines = Files.lines(file.toPath());){
            long l = lines.filter(line -> line.contains(substring)).count();
            return l;
        }
    }
}

