/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.labelscan.LabelScanStoreTest;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public class NativeLabelScanStoreChaosIT {
    private final DatabaseRule dbRule = new EmbeddedDatabaseRule();
    private final RandomRule randomRule = new RandomRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.randomRule).around((TestRule)this.dbRule);

    @Test
    public void shouldRebuildDeletedLabelScanStoreOnStartup() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First);
        Node node2 = this.createLabeledNode(Labels.First);
        Node node3 = this.createLabeledNode(Labels.First);
        this.deleteNode(node2);
        this.dbRule.restartDatabase(this.deleteTheLabelScanStoreIndex(), new String[0]);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node3}), this.getAllNodesWithLabel(Labels.First));
    }

    @Test
    public void rebuildCorruptedLabelScanStoreToStartup() throws Exception {
        Node node = this.createLabeledNode(Labels.First);
        this.dbRule.restartDatabase(this.corruptTheLabelScanStoreIndex(), new String[0]);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node}), this.getAllNodesWithLabel(Labels.First));
    }

    private static File storeFile(File directory) {
        return new File(directory, "neostore.labelscanstore.db");
    }

    private DatabaseRule.RestartAction corruptTheLabelScanStoreIndex() {
        return (fs, directory) -> this.scrambleFile(NativeLabelScanStoreChaosIT.storeFile(directory));
    }

    private DatabaseRule.RestartAction deleteTheLabelScanStoreIndex() {
        return (fs, directory) -> fs.deleteFile(NativeLabelScanStoreChaosIT.storeFile(directory));
    }

    private Node createLabeledNode(Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            Node node = this.dbRule.getGraphDatabaseAPI().createNode(labels);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Set<Node> getAllNodesWithLabel(Label label) {
        try (Transaction ignored = this.dbRule.getGraphDatabaseAPI().beginTx();){
            Set set = Iterators.asSet((Iterator)this.dbRule.getGraphDatabaseAPI().findNodes(label));
            return set;
        }
    }

    private void scrambleFile(File file) throws IOException {
        LabelScanStoreTest.scrambleFile((Random)this.randomRule.random(), (File)file);
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            node.delete();
            tx.success();
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second,
        Third;

    }
}

