/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.DoubleLatch;

public class ControlledPopulationIndexProvider
extends IndexProvider {
    private IndexPopulator mockedPopulator = new IndexPopulator.Adapter();
    private final IndexAccessor mockedWriter = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final CountDownLatch writerLatch = new CountDownLatch(1);
    private InternalIndexState initialIndexState = InternalIndexState.POPULATING;
    final AtomicInteger populatorCallCount = new AtomicInteger();
    final AtomicInteger writerCallCount = new AtomicInteger();
    public static final IndexProvider.Descriptor PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor("controlled-population", "1.0");

    public ControlledPopulationIndexProvider() {
        super(PROVIDER_DESCRIPTOR, 10, IndexDirectoryStructure.NONE);
        this.setInitialIndexState(this.initialIndexState);
        Mockito.when((Object)this.mockedWriter.newReader()).thenReturn((Object)IndexReader.EMPTY);
    }

    public DoubleLatch installPopulationJobCompletionLatch() {
        final DoubleLatch populationCompletionLatch = new DoubleLatch();
        this.mockedPopulator = new IndexPopulator.Adapter(){

            public void create() throws IOException {
                populationCompletionLatch.startAndWaitForAllToStartAndFinish();
                super.create();
            }

            public IndexSample sampleResult() {
                return new IndexSample();
            }
        };
        return populationCompletionLatch;
    }

    public void awaitFullyPopulated() {
        DoubleLatch.awaitLatch((CountDownLatch)this.writerLatch);
    }

    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        this.populatorCallCount.incrementAndGet();
        return this.mockedPopulator;
    }

    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor indexConfig, IndexSamplingConfig samplingConfig) {
        this.writerCallCount.incrementAndGet();
        this.writerLatch.countDown();
        return this.mockedWriter;
    }

    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        return this.initialIndexState;
    }

    public IndexCapability getCapability() {
        return IndexCapability.NO_CAPABILITY;
    }

    public void setInitialIndexState(InternalIndexState initialIndexState) {
        this.initialIndexState = initialIndexState;
    }

    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public int compareTo(IndexProvider o) {
        return 1;
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }
}

