/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class IndexIT
extends KernelIntegrationTest {
    private static final String LABEL = "Label";
    private static final String PROPERTY_KEY = "prop";
    private static final String PROPERTY_KEY2 = "prop2";
    private int labelId;
    private int propertyKeyId;
    private org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor descriptor;
    private org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor descriptor2;
    private ExecutorService executorService;

    @Before
    public void createLabelAndProperty() throws Exception {
        TokenWrite tokenWrites = this.tokenWriteInNewTransaction();
        this.labelId = tokenWrites.labelGetOrCreateForName(LABEL);
        this.propertyKeyId = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY);
        int propertyKeyId2 = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY2);
        this.descriptor = SchemaDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId});
        this.descriptor2 = SchemaDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{propertyKeyId2});
        this.commit();
        this.executorService = Executors.newCachedThreadPool();
    }

    @After
    public void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    public void createIndexForAnotherLabelWhileHoldingSharedLockOnOtherLabel() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int label2 = tokenWrite.labelGetOrCreateForName("Label2");
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, label2);
        this.schemaWriteInNewTransaction().indexCreate((SchemaDescriptor)this.descriptor);
        this.commit();
    }

    @Test(timeout=10000L)
    public void createIndexesForDifferentLabelsConcurrently() throws Throwable {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int label2 = tokenWrite.labelGetOrCreateForName("Label2");
        LabelSchemaDescriptor anotherLabelDescriptor = SchemaDescriptorFactory.forLabel((int)label2, (int[])new int[]{this.propertyKeyId});
        this.schemaWriteInNewTransaction().indexCreate((SchemaDescriptor)anotherLabelDescriptor);
        Future<?> indexFuture = this.executorService.submit(this.createIndex(this.db, Label.label((String)LABEL), PROPERTY_KEY));
        indexFuture.get();
        this.commit();
    }

    @Test
    public void addIndexRuleInATransaction() throws Exception {
        SchemaWrite schemaWriteOperations = this.schemaWriteInNewTransaction();
        IndexReference expectedRule = schemaWriteOperations.indexCreate((SchemaDescriptor)this.descriptor);
        this.commit();
        SchemaRead schemaRead = this.newTransaction().schemaRead();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexReference[]{expectedRule}), (Object)Iterators.asSet((Iterator)schemaRead.indexesGetForLabel(this.labelId)));
        Assert.assertEquals((Object)expectedRule, (Object)schemaRead.index(this.descriptor.getLabelId(), this.descriptor.getPropertyIds()));
        this.commit();
    }

    @Test
    public void committedAndTransactionalIndexRulesShouldBeMerged() throws Exception {
        SchemaWrite schemaWriteOperations = this.schemaWriteInNewTransaction();
        IndexReference existingRule = schemaWriteOperations.indexCreate((SchemaDescriptor)this.descriptor);
        this.commit();
        Transaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        IndexReference addedRule = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{10}));
        Set indexRulesInTx = Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId));
        this.commit();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexReference[]{existingRule, addedRule}), (Object)indexRulesInTx);
    }

    @Test
    public void rollBackIndexRuleShouldNotBeCommitted() throws Exception {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        schemaWrite.indexCreate((SchemaDescriptor)this.descriptor);
        this.rollback();
        Transaction transaction = this.newTransaction();
        Assert.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    public void shouldBeAbleToRemoveAConstraintIndexWithoutOwner() throws Exception {
        NodePropertyAccessor propertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, this.indexingService, propertyAccessor, (LogProvider)logProvider);
        IndexDescriptor constraintIndex = creator.createConstraintIndex((SchemaDescriptor)this.descriptor, Optional.empty());
        Transaction transaction = this.newTransaction();
        Assert.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().constraintsGetForLabel(this.labelId)));
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        schemaWrite.indexDrop((IndexReference)constraintIndex);
        this.commit();
        transaction = this.newTransaction();
        Assert.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    public void shouldDisallowDroppingIndexThatDoesNotExist() throws Exception {
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        IndexReference index = statement.indexCreate((SchemaDescriptor)this.descriptor);
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.indexDrop(index);
        this.commit();
        try {
            statement = this.schemaWriteInNewTransaction();
            statement.indexDrop(index);
            this.commit();
        }
        catch (SchemaKernelException e) {
            Assert.assertEquals((Object)("Unable to drop index on :label[" + this.labelId + "](property[" + this.propertyKeyId + "]): No such INDEX ON :label[" + this.labelId + "](property[" + this.propertyKeyId + "])."), (Object)e.getMessage());
        }
        this.commit();
    }

    @Test
    public void shouldFailToCreateIndexWhereAConstraintAlreadyExists() throws Exception {
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        statement.uniquePropertyConstraintCreate((SchemaDescriptor)this.descriptor);
        this.commit();
        try {
            statement = this.schemaWriteInNewTransaction();
            statement.indexCreate((SchemaDescriptor)this.descriptor);
            this.commit();
            Assert.fail((String)"expected exception");
        }
        catch (SchemaKernelException e) {
            Assert.assertEquals((Object)"Label 'Label' and property 'prop' have a unique constraint defined on them, so an index is already created that matches this.", (Object)e.getMessage());
        }
        this.commit();
    }

    @Test
    public void shouldListConstraintIndexesInTheBeansAPI() throws Exception {
        Transaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)transaction.tokenWrite().labelGetOrCreateForName("Label1"), (int[])new int[]{transaction.tokenWrite().propertyKeyGetOrCreateForName("property1")}));
        this.commit();
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)this.db.schema().getIndexes());
            Assert.assertEquals((long)1L, (long)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assert.assertEquals((Object)"Label1", (Object)index.getLabel().name());
            Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"property1"}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
            Assert.assertTrue((String)"index should be a constraint index", (boolean)index.isConstraintIndex());
            try {
                index.drop();
                Assert.fail((String)"expected exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)"Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void shouldListAll() throws Exception {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        IndexReference index1 = schemaWrite.indexCreate((SchemaDescriptor)this.descriptor);
        IndexDescriptor index2 = ((IndexBackedConstraintDescriptor)schemaWrite.uniquePropertyConstraintCreate((SchemaDescriptor)this.descriptor2)).ownedIndexDescriptor();
        this.commit();
        SchemaRead schemaRead = this.newTransaction().schemaRead();
        List indexes = Iterators.asList((Iterator)schemaRead.indexesGetAll());
        MatcherAssert.assertThat((Object)indexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexReference[]{index1, index2}));
        this.commit();
    }

    private Runnable createIndex(GraphDatabaseAPI db, Label label, String propertyKey) {
        return () -> {
            try (org.neo4j.graphdb.Transaction transaction = db.beginTx();){
                db.schema().indexFor(label).on(propertyKey).create();
                transaction.success();
            }
            transaction = db.beginTx();
            var4_4 = null;
            try {
                db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                transaction.success();
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var4_4 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        };
    }
}

