/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReaderTestBase;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

public class RecordStorageReaderLabelTest
extends RecordStorageReaderTestBase {
    @Test
    public void shouldBeAbleToListLabelsForNode() throws Exception {
        int labelId2;
        int labelId1;
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            nodeId = this.db.createNode(new Label[]{this.label1, this.label2}).getId();
            String labelName1 = this.label1.name();
            String labelName2 = this.label2.name();
            labelId1 = this.labelId(Label.label((String)labelName1));
            labelId2 = this.labelId(Label.label((String)labelName2));
            tx.success();
        }
        StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor();
        nodeCursor.single(nodeId);
        Assert.assertTrue((boolean)nodeCursor.next());
        Assert.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{labelId1, labelId2}), (Object)LongHashSet.newSetWith((long[])nodeCursor.labels()));
    }

    @Test
    public void labelsShouldNotLeakOutAsProperties() {
        Node node = RecordStorageReaderLabelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Node"}), this.label1);
        Assert.assertThat((Object)Neo4jMatchers.getPropertyKeys((GraphDatabaseService)this.db, (PropertyContainer)node), (Matcher)Neo4jMatchers.containsOnly((Object[])new String[]{"name"}));
    }

    @Test
    public void shouldReturnAllNodesWithLabel() {
        Node node1 = RecordStorageReaderLabelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "First", "age", 1L}), this.label1);
        Node node2 = RecordStorageReaderLabelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"type", "Node", "count", 10}), this.label1, this.label2);
        int labelId1 = this.labelId(this.label1);
        int labelId2 = this.labelId(this.label2);
        PrimitiveLongResourceIterator nodesForLabel1 = this.storageReader.nodesGetForLabel(labelId1);
        PrimitiveLongResourceIterator nodesForLabel2 = this.storageReader.nodesGetForLabel(labelId2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{node1.getId(), node2.getId()}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodesForLabel1));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{node2.getId()}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodesForLabel2));
    }
}

