/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.RotationTimeoutException;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.AdversarialPageCacheGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CountsRotationTest {
    private static final String COUNTS_STORE_BASE = "neostore.counts.db";
    private final Label A = Label.label((String)"A");
    private final Label B = Label.label((String)"B");
    private final Label C = Label.label((String)"C");
    private final PageCacheRule pcRule = new PageCacheRule();
    private final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final TestDirectory testDir = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fsRule.get());
    private final ThreadingRule threadingRule = new ThreadingRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.threadingRule).around((TestRule)this.pcRule).around((TestRule)this.fsRule).around((TestRule)this.testDir);
    private FileSystemAbstraction fs;
    private File dir;
    private GraphDatabaseBuilder dbBuilder;
    private PageCache pageCache;

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.dir = this.testDir.directory("dir").getAbsoluteFile();
        this.dbBuilder = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs)).newImpermanentDatabaseBuilder(this.dir);
        this.pageCache = this.pcRule.getPageCache(this.fs);
    }

    @Test
    public void shouldCreateEmptyCountsTrackerStoreWhenCreatingDatabase() {
        CountsTracker store;
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        db.shutdown();
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertFalse((boolean)this.fs.fileExists(this.betaStoreFile()));
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(this.pageCache));
            Assert.assertEquals((long)1L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)0L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)0L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        life = new Lifespan(new Lifecycle[0]);
        var3_3 = null;
        try {
            store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(this.pageCache));
            Assert.assertEquals((long)1L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)0L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)0L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (life != null) {
                if (var3_3 != null) {
                    try {
                        life.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    life.close();
                }
            }
        }
    }

    @Test
    public void shouldUnMapThePrestateFileWhenTimingOutOnRotationAndAllowForShutdownInTheFailedRotationState() throws Throwable {
        this.dbBuilder.newGraphDatabase().shutdown();
        CountsTracker store = this.createCountsTracker(this.pageCache, Config.defaults((Setting)GraphDatabaseSettings.counts_store_rotation_timeout, (String)"100ms"));
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{store});){
            try (CountsAccessor.Updater updater = (CountsAccessor.Updater)store.apply(2L).get();){
                updater.incrementNodeCount(0L, 1L);
            }
            try {
                store.rotate(3L);
                Assert.fail((String)"should have thrown");
            }
            catch (RotationTimeoutException rotationTimeoutException) {
                // empty catch block
            }
        }
        this.pageCache.close();
    }

    @Test
    public void rotationShouldNotCauseUnmappedFileProblem() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        DependencyResolver resolver = db.getDependencyResolver();
        RecordStorageEngine storageEngine = (RecordStorageEngine)resolver.resolveDependency(RecordStorageEngine.class);
        CountsTracker countStore = storageEngine.testAccessNeoStores().getCounts();
        AtomicBoolean workerContinueFlag = new AtomicBoolean(true);
        AtomicLong lookupsCounter = new AtomicLong();
        int rotations = 100;
        for (int i = 0; i < 5; ++i) {
            this.threadingRule.execute(CountsRotationTest.countStoreLookup(workerContinueFlag, lookupsCounter), (Object)countStore);
        }
        long startTxId = countStore.txId();
        for (int i = 1; i < rotations || lookupsCounter.get() == 0L; ++i) {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{this.B});
                tx.success();
            }
            this.checkPoint(db);
        }
        workerContinueFlag.set(false);
        Assert.assertEquals((String)"Should perform at least 100 rotations.", (long)rotations, (long)Math.min((long)rotations, countStore.txId() - startTxId));
        Assert.assertTrue((String)"Should perform more then 0 lookups without exceptions.", (lookupsCounter.get() > 0L ? 1 : 0) != 0);
        db.shutdown();
    }

    private static ThrowingFunction<CountsTracker, Void, RuntimeException> countStoreLookup(AtomicBoolean workerContinueFlag, AtomicLong lookups) {
        return countsTracker -> {
            while (workerContinueFlag.get()) {
                Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
                countsTracker.get((CountsKey)CountsKeyFactory.nodeKey((long)0L), register);
                lookups.incrementAndGet();
            }
            return null;
        };
    }

    @Test
    public void shouldRotateCountsStoreWhenClosingTheDatabase() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{this.A});
            tx.success();
        }
        db.shutdown();
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertTrue((boolean)this.fs.fileExists(this.betaStoreFile()));
        var3_3 = null;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(this.pageCache));
            Assert.assertEquals((long)3L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)2L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)2L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRotateCountsStoreWhenRotatingLog() throws IOException {
        int labelId;
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{this.B});
            tx.success();
        }
        this.checkPoint(db);
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.createNode(new Label[]{this.C});
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertTrue((boolean)this.fs.fileExists(this.betaStoreFile()));
        PageCache pageCache = (PageCache)db.getDependencyResolver().resolveDependency(PageCache.class);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(pageCache));
            Assert.assertEquals((long)3L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)2L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)2L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        CountsTracker tracker = ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getCounts();
        Assert.assertEquals((long)2L, (long)tracker.nodeCount(-1, Registers.newDoubleLongRegister()).readSecond());
        try (Transaction tx = db.beginTx();){
            KernelTransaction transaction = ((ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            labelId = transaction.tokenRead().nodeLabel(this.C.name());
        }
        Assert.assertEquals((long)1L, (long)tracker.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond());
        db.shutdown();
    }

    @Test(timeout=60000L)
    public void possibleToShutdownDbWhenItIsNotHealthyAndNotAllTransactionsAreApplied() throws Exception {
        ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, true), new Class[]{NodeStore.class});
        adversary.disable();
        GraphDatabaseService db = AdversarialPageCacheGraphDatabaseFactory.create((FileSystemAbstraction)this.fs, (Adversary)adversary).newEmbeddedDatabaseBuilder(this.dir).newGraphDatabase();
        CountDownLatch txStartLatch = new CountDownLatch(1);
        CountDownLatch txCommitLatch = new CountDownLatch(1);
        Future result = ForkJoinPool.commonPool().submit(() -> {
            try (Transaction tx = db.beginTx();){
                txStartLatch.countDown();
                db.createNode();
                CountsRotationTest.await(txCommitLatch);
                tx.success();
            }
        });
        CountsRotationTest.await(txStartLatch);
        adversary.enable();
        txCommitLatch.countDown();
        try {
            result.get();
            Assert.fail((String)"Exception expected");
        }
        catch (ExecutionException ee) {
            Assert.assertThat((Object)ee.getCause(), (Matcher)Matchers.instanceOf(TransactionFailureException.class));
        }
        adversary.disable();
        db.shutdown();
    }

    private static void await(CountDownLatch latch) {
        try {
            boolean result = latch.await(30L, TimeUnit.SECONDS);
            if (!result) {
                throw new RuntimeException("Count down did not happen. Current count: " + latch.getCount());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private CountsTracker createCountsTracker(PageCache pageCache) {
        return this.createCountsTracker(pageCache, Config.defaults());
    }

    private CountsTracker createCountsTracker(PageCache pageCache, Config config) {
        return new CountsTracker((LogProvider)NullLogProvider.getInstance(), this.fs, pageCache, config, new File(this.dir.getPath(), COUNTS_STORE_BASE), EmptyVersionContextSupplier.EMPTY);
    }

    private void checkPoint(GraphDatabaseAPI db) throws IOException {
        SimpleTriggerInfo triggerInfo = new SimpleTriggerInfo("test");
        ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)triggerInfo);
    }

    private File alphaStoreFile() {
        return new File(this.dir.getPath(), "neostore.counts.db.a");
    }

    private File betaStoreFile() {
        return new File(this.dir.getPath(), "neostore.counts.db.b");
    }

    private Collection<Pair<? extends CountsKey, Long>> allRecords(CountsVisitor.Visitable store) {
        final ArrayList<Pair<? extends CountsKey, Long>> records = new ArrayList<Pair<? extends CountsKey, Long>>();
        store.accept(new CountsVisitor(){

            public void visitNodeCount(int labelId, long count) {
                records.add(Pair.of((Object)CountsKeyFactory.nodeKey((long)labelId), (Object)count));
            }

            public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                records.add(Pair.of((Object)CountsKeyFactory.relationshipKey((long)startLabelId, (int)typeId, (long)endLabelId), (Object)count));
            }

            public void visitIndexStatistics(long indexId, long updates, long size) {
                records.add(Pair.of((Object)CountsKeyFactory.indexStatisticsKey((long)indexId), (Object)size));
            }

            public void visitIndexSample(long indexId, long unique, long size) {
                records.add(Pair.of((Object)CountsKeyFactory.indexSampleKey((long)indexId), (Object)size));
            }
        });
        return records;
    }
}

