/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.register.Registers;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;

public class CsvInputBatchImportIT {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final long seed = System.currentTimeMillis();
    private final Random random = new Random(this.seed);
    private static final Supplier<ZoneId> testDefaultTimeZone = () -> ZoneId.of("Asia/Shanghai");

    private String nameOf(InputEntity node) {
        return (String)node.properties()[1];
    }

    private int indexOf(InputEntity node) {
        return Integer.parseInt(((String)node.properties()[1]).split("\\s")[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldImportDataComingFromCsvFiles() throws Exception {
        Config dbConfig = Config.builder().withSetting(GraphDatabaseSettings.db_timezone, LogTimeZone.SYSTEM.name()).build();
        ParallelBatchImporter importer = new ParallelBatchImporter(this.directory.graphDbDir(), this.fileSystemRule.get(), null, this.smallBatchSizeConfig(), (LogService)NullLogService.getInstance(), ExecutionMonitors.invisible(), AdditionalInitialIds.EMPTY, dbConfig, RecordFormatSelector.defaultFormat(), ImportLogic.NO_MONITOR);
        List<InputEntity> nodeData = this.randomNodeData();
        List<InputEntity> relationshipData = this.randomRelationshipData(nodeData);
        boolean success = false;
        try {
            importer.doImport(CsvInputBatchImportIT.csv(this.nodeDataAsFile(nodeData), this.relationshipDataAsFile(relationshipData), IdType.STRING, CsvInputBatchImportIT.lowBufferSize(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS), Collectors.silentBadCollector((long)0L)));
            this.verifyImportedData(nodeData, relationshipData);
            success = true;
        }
        finally {
            if (!success) {
                System.err.println("Seed " + this.seed);
            }
        }
    }

    public static Input csv(File nodes, File relationships, IdType idType, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration configuration, Collector badCollector) {
        return new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (File[])new File[]{nodes})}), DataFactories.defaultFormatNodeFileHeader(testDefaultTimeZone), DataFactories.datas((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)InputEntityDecorators.NO_DECORATOR, (Charset)Charset.defaultCharset(), (File[])new File[]{relationships})}), DataFactories.defaultFormatRelationshipFileHeader(testDefaultTimeZone), idType, configuration, badCollector);
    }

    private static org.neo4j.unsafe.impl.batchimport.input.csv.Configuration lowBufferSize(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration actual) {
        return new Configuration.Overridden(actual){

            public int bufferSize() {
                return 10000;
            }
        };
    }

    private List<InputEntity> randomNodeData() {
        ArrayList<InputEntity> nodes = new ArrayList<InputEntity>();
        for (int i = 0; i < 300; ++i) {
            InputEntity node = new InputEntity();
            node.id((Object)UUID.randomUUID().toString(), Group.GLOBAL);
            node.property("name", (Object)("Node " + i));
            node.property("pointA", (Object)("\"   { x : -4.2, y : " + i + ", crs: WGS-84 } \""));
            node.property("pointB", (Object)("\" { x : -8, y : " + i + " } \""));
            node.property("date", (Object)LocalDate.of(2018, i % 12 + 1, i % 28 + 1));
            node.property("time", (Object)OffsetTime.of(1, i % 60, 0, 0, ZoneOffset.ofHours(9)));
            node.property("dateTime", (Object)ZonedDateTime.of(2011, 9, 11, 8, i % 60, 0, 0, ZoneId.of("Europe/Stockholm")));
            node.property("dateTime2", (Object)LocalDateTime.of(2011, 9, 11, 8, i % 60, 0, 0));
            node.property("localTime", (Object)LocalTime.of(1, i % 60, 0));
            node.property("localDateTime", (Object)LocalDateTime.of(2011, 9, 11, 8, i % 60));
            node.property("duration", (Object)Period.of(2, -3, i % 30));
            node.labels(this.randomLabels(this.random));
            nodes.add(node);
        }
        return nodes;
    }

    private String[] randomLabels(Random random) {
        String[] labels = new String[random.nextInt(3)];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = "Label" + random.nextInt(4);
        }
        return labels;
    }

    private Configuration smallBatchSizeConfig() {
        return new Configuration(){

            public int batchSize() {
                return 100;
            }

            public int denseNodeThreshold() {
                return 5;
            }
        };
    }

    private File relationshipDataAsFile(List<InputEntity> relationshipData) throws IOException {
        File file = this.directory.file("relationships.csv");
        try (Writer writer = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).openAsWriter(file, StandardCharsets.UTF_8, false);){
            this.println(writer, ":start_id,:end_id,:type");
            for (InputEntity relationship : relationshipData) {
                this.println(writer, relationship.startId() + "," + relationship.endId() + "," + relationship.stringType);
            }
        }
        return file;
    }

    private File nodeDataAsFile(List<InputEntity> nodeData) throws IOException {
        File file = this.directory.file("nodes.csv");
        try (Writer writer = ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).openAsWriter(file, StandardCharsets.UTF_8, false);){
            this.println(writer, "id:ID,name,pointA:Point{crs:WGS-84},pointB:Point,date:Date,time:Time,dateTime:DateTime,dateTime2:DateTime,localTime:LocalTime,localDateTime:LocalDateTime,duration:Duration,some-labels:LABEL");
            for (InputEntity node : nodeData) {
                String csvLabels = this.csvLabels(node.labels());
                StringBuilder sb = new StringBuilder(node.id() + ",");
                for (int i = 0; i < node.propertyCount(); ++i) {
                    sb.append(node.propertyValue(i) + ",");
                }
                sb.append(csvLabels != null && csvLabels.length() > 0 ? csvLabels : "");
                this.println(writer, sb.toString());
            }
        }
        return file;
    }

    private String csvLabels(String[] labels) {
        if (labels == null || labels.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(builder.length() > 0 ? ";" : "").append(label);
        }
        return builder.toString();
    }

    private void println(Writer writer, String string) throws IOException {
        writer.write(string + "\n");
    }

    private List<InputEntity> randomRelationshipData(List<InputEntity> nodeData) {
        ArrayList<InputEntity> relationships = new ArrayList<InputEntity>();
        for (int i = 0; i < 1000; ++i) {
            InputEntity relationship = new InputEntity();
            relationship.startId(nodeData.get(this.random.nextInt(nodeData.size())).id(), Group.GLOBAL);
            relationship.endId(nodeData.get(this.random.nextInt(nodeData.size())).id(), Group.GLOBAL);
            relationship.type("TYPE_" + this.random.nextInt(3));
            relationships.add(relationship);
        }
        return relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyImportedData(List<InputEntity> nodeData, List<InputEntity> relationshipData) {
        HashMap<String, InputEntity> expectedNodes = new HashMap<String, InputEntity>();
        HashMap<String, String[]> expectedNodeNames = new HashMap<String, String[]>();
        HashMap<String, Map<String, Consumer<Object>>> expectedNodePropertyVerifiers = new HashMap<String, Map<String, Consumer<Object>>>();
        AutoCreatingHashMap expectedRelationships = new AutoCreatingHashMap(AutoCreatingHashMap.nested(String.class, (Factory)AutoCreatingHashMap.nested(String.class, (Factory)AutoCreatingHashMap.values(AtomicInteger.class))));
        AutoCreatingHashMap expectedNodeCounts = new AutoCreatingHashMap(AutoCreatingHashMap.values(AtomicLong.class));
        AutoCreatingHashMap expectedRelationshipCounts = new AutoCreatingHashMap(AutoCreatingHashMap.nested(String.class, (Factory)AutoCreatingHashMap.nested(String.class, (Factory)AutoCreatingHashMap.values(AtomicLong.class))));
        this.buildUpExpectedData(nodeData, relationshipData, expectedNodes, expectedNodeNames, expectedNodePropertyVerifiers, (Map<String, Map<String, Map<String, AtomicInteger>>>)expectedRelationships, (Map<String, AtomicLong>)expectedNodeCounts, (Map<String, Map<String, Map<String, AtomicLong>>>)expectedRelationshipCounts);
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.directory.graphDbDir());
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                String name = (String)node.getProperty("name");
                Object[] objectArray = (String[])expectedNodeNames.remove(name);
                Assert.assertEquals((Object)Iterators.asSet((Object[])objectArray), this.names(node.getLabels()));
                Map expectedPropertyVerifiers = (Map)expectedNodePropertyVerifiers.remove(name);
                Map actualProperties = node.getAllProperties();
                actualProperties.remove("id");
                for (Map.Entry actualProperty : actualProperties.entrySet()) {
                    Consumer v = (Consumer)expectedPropertyVerifiers.get(actualProperty.getKey());
                    if (v == null) continue;
                    v.accept(actualProperty.getValue());
                }
            }
            Assert.assertEquals((long)0L, (long)expectedNodeNames.size());
            for (Relationship relationship : db.getAllRelationships()) {
                String startNodeName = (String)relationship.getStartNode().getProperty("name");
                Map map = (Map)expectedRelationships.get(startNodeName);
                String endNodeName = (String)relationship.getEndNode().getProperty("name");
                Map innerInner = (Map)map.get(endNodeName);
                String type = relationship.getType().name();
                int countAfterwards = ((AtomicInteger)innerInner.get(type)).decrementAndGet();
                Assert.assertThat((Object)countAfterwards, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
                if (countAfterwards != 0) continue;
                innerInner.remove(type);
                if (!innerInner.isEmpty()) continue;
                map.remove(endNodeName);
                if (!map.isEmpty()) continue;
                expectedRelationships.remove(startNodeName);
            }
            Assert.assertEquals((long)0L, (long)expectedRelationships.size());
            NeoStores neoStores = ((RecordStorageEngine)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
            Function<String, Integer> labelTranslationTable = this.translationTable((TokenStore<?>)neoStores.getLabelTokenStore(), -1);
            for (Pair pair : this.allNodeCounts(labelTranslationTable, (Map<String, AtomicLong>)expectedNodeCounts)) {
                Assert.assertEquals((String)("Label count mismatch for label " + pair.first()), (long)((Long)pair.other()), (long)neoStores.getCounts().nodeCount(((Integer)pair.first()).intValue(), Registers.newDoubleLongRegister()).readSecond());
            }
            Function<String, Integer> relationshipTypeTranslationTable = this.translationTable((TokenStore<?>)neoStores.getRelationshipTypeTokenStore(), -1);
            for (Pair<RelationshipCountKey, Long> count : this.allRelationshipCounts(labelTranslationTable, relationshipTypeTranslationTable, (Map<String, Map<String, Map<String, AtomicLong>>>)expectedRelationshipCounts)) {
                RelationshipCountKey key = (RelationshipCountKey)count.first();
                Assert.assertEquals((String)("Label count mismatch for label " + key), (long)((Long)count.other()), (long)neoStores.getCounts().relationshipCount(key.startLabel, key.type, key.endLabel, Registers.newDoubleLongRegister()).readSecond());
            }
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private Iterable<Pair<RelationshipCountKey, Long>> allRelationshipCounts(Function<String, Integer> labelTranslationTable, Function<String, Integer> relationshipTypeTranslationTable, Map<String, Map<String, Map<String, AtomicLong>>> counts) {
        ArrayList<Pair<RelationshipCountKey, Long>> result = new ArrayList<Pair<RelationshipCountKey, Long>>();
        for (Map.Entry<String, Map<String, Map<String, AtomicLong>>> startLabel : counts.entrySet()) {
            for (Map.Entry<String, Map<String, AtomicLong>> type : startLabel.getValue().entrySet()) {
                for (Map.Entry<String, AtomicLong> endLabel : type.getValue().entrySet()) {
                    RelationshipCountKey key = new RelationshipCountKey(labelTranslationTable.apply(startLabel.getKey()), relationshipTypeTranslationTable.apply(type.getKey()), labelTranslationTable.apply(endLabel.getKey()));
                    result.add((Pair<RelationshipCountKey, Long>)Pair.of((Object)key, (Object)endLabel.getValue().longValue()));
                }
            }
        }
        return result;
    }

    private Iterable<Pair<Integer, Long>> allNodeCounts(Function<String, Integer> labelTranslationTable, Map<String, AtomicLong> counts) {
        ArrayList<Pair<Integer, Long>> result = new ArrayList<Pair<Integer, Long>>();
        for (Map.Entry<String, AtomicLong> count : counts.entrySet()) {
            result.add((Pair<Integer, Long>)Pair.of((Object)labelTranslationTable.apply(count.getKey()), (Object)count.getValue().get()));
        }
        counts.put(null, new AtomicLong(counts.size()));
        return result;
    }

    private Function<String, Integer> translationTable(TokenStore<?> tokenStore, int anyValue) {
        HashMap<String, Integer> translationTable = new HashMap<String, Integer>();
        for (NamedToken token : tokenStore.getTokens()) {
            translationTable.put(token.name(), token.id());
        }
        return from -> from == null ? Integer.valueOf(anyValue) : (Integer)translationTable.get(from);
    }

    private Set<String> names(Iterable<Label> labels) {
        HashSet<String> names = new HashSet<String>();
        for (Label label : labels) {
            names.add(label.name());
        }
        return names;
    }

    private void buildUpExpectedData(List<InputEntity> nodeData, List<InputEntity> relationshipData, Map<String, InputEntity> expectedNodes, Map<String, String[]> expectedNodeNames, Map<String, Map<String, Consumer<Object>>> expectedNodePropertyVerifiers, Map<String, Map<String, Map<String, AtomicInteger>>> expectedRelationships, Map<String, AtomicLong> nodeCounts, Map<String, Map<String, Map<String, AtomicLong>>> relationshipCounts) {
        for (InputEntity node : nodeData) {
            expectedNodes.put((String)node.id(), node);
            expectedNodeNames.put(this.nameOf(node), node.labels());
            Assert.assertTrue((!node.hasIntPropertyKeyIds ? 1 : 0) != 0);
            TreeMap<String, Consumer<Object>> propertyVerifiers = new TreeMap<String, Consumer<Object>>();
            for (int i = 0; i < node.propertyCount(); ++i) {
                Consumer<Object> verify;
                Object expectedValue = node.propertyValue(i);
                if (expectedValue instanceof TemporalAmount) {
                    verify = actualValue -> {
                        LocalDateTime referenceTemporal = LocalDateTime.of(0, 1, 1, 0, 0);
                        LocalDateTime expected = referenceTemporal.plus((TemporalAmount)expectedValue);
                        LocalDateTime actual = referenceTemporal.plus((TemporalAmount)actualValue);
                        Assert.assertEquals((Object)expected, (Object)actual);
                    };
                } else if (expectedValue instanceof Temporal) {
                    LocalDate expectedDate = ((Temporal)expectedValue).query(TemporalQueries.localDate());
                    LocalTime expectedTime = ((Temporal)expectedValue).query(TemporalQueries.localTime());
                    ZoneId expectedZoneId = ((Temporal)expectedValue).query(TemporalQueries.zone());
                    verify = actualValue -> {
                        LocalDate actualDate = ((Temporal)actualValue).query(TemporalQueries.localDate());
                        LocalTime actualTime = ((Temporal)actualValue).query(TemporalQueries.localTime());
                        ZoneId actualZoneId = ((Temporal)actualValue).query(TemporalQueries.zone());
                        Assert.assertEquals((Object)expectedDate, (Object)actualDate);
                        Assert.assertEquals((Object)expectedTime, (Object)actualTime);
                        if (expectedZoneId == null) {
                            if (actualZoneId != null) {
                                Assert.assertEquals((Object)testDefaultTimeZone.get(), (Object)actualZoneId);
                            }
                        } else {
                            Assert.assertEquals((Object)expectedZoneId, (Object)actualZoneId);
                        }
                    };
                } else {
                    verify = actualValue -> Assert.assertEquals((Object)expectedValue, (Object)actualValue);
                }
                propertyVerifiers.put((String)node.propertyKey(i), verify);
            }
            Consumer<Object> verifyPointA = actualValue -> {
                PointValue v = (PointValue)actualValue;
                double actualY = (Double)((Coordinate)v.getCoordinates().get(0)).getCoordinate().get(1);
                double expectedY = this.indexOf(node);
                String message = actualValue.toString() + " does not have y=" + expectedY;
                Assert.assertEquals((String)message, (double)expectedY, (double)actualY, (double)0.1);
                message = actualValue.toString() + " does not have crs=wgs-84";
                Assert.assertEquals((String)message, (Object)CoordinateReferenceSystem.WGS84.getName(), (Object)v.getCoordinateReferenceSystem().getName());
            };
            propertyVerifiers.put("pointA", verifyPointA);
            Consumer<Object> verifyPointB = actualValue -> {
                PointValue v = (PointValue)actualValue;
                double actualY = (Double)((Coordinate)v.getCoordinates().get(0)).getCoordinate().get(1);
                double expectedY = this.indexOf(node);
                String message = actualValue.toString() + " does not have y=" + expectedY;
                Assert.assertEquals((String)message, (double)expectedY, (double)actualY, (double)0.1);
                message = actualValue.toString() + " does not have crs=cartesian";
                Assert.assertEquals((String)message, (Object)CoordinateReferenceSystem.Cartesian.getName(), (Object)v.getCoordinateReferenceSystem().getName());
            };
            propertyVerifiers.put("pointB", verifyPointB);
            expectedNodePropertyVerifiers.put(this.nameOf(node), propertyVerifiers);
            this.countNodeLabels(nodeCounts, node.labels());
        }
        for (InputEntity relationship : relationshipData) {
            InputEntity startNode = expectedNodes.get(relationship.startId());
            InputEntity endNode = expectedNodes.get(relationship.endId());
            expectedRelationships.get(this.nameOf(startNode)).get(this.nameOf(endNode)).get(relationship.stringType).incrementAndGet();
            relationshipCounts.get(null).get(null).get(null).incrementAndGet();
            relationshipCounts.get(null).get(relationship.stringType).get(null).incrementAndGet();
            for (String startNodeLabelName : Iterators.asSet((Object[])startNode.labels())) {
                Map<String, Map<String, AtomicLong>> startLabelCounts = relationshipCounts.get(startNodeLabelName);
                startLabelCounts.get(null).get(null).incrementAndGet();
                Map<String, AtomicLong> typeCounts = startLabelCounts.get(relationship.stringType);
                typeCounts.get(null).incrementAndGet();
            }
            for (String endNodeLabelName : Iterators.asSet((Object[])endNode.labels())) {
                relationshipCounts.get(null).get(null).get(endNodeLabelName).incrementAndGet();
                relationshipCounts.get(null).get(relationship.stringType).get(endNodeLabelName).incrementAndGet();
            }
        }
    }

    private void countNodeLabels(Map<String, AtomicLong> nodeCounts, String[] labels) {
        HashSet<String> seen = new HashSet<String>();
        for (String labelName : labels) {
            if (!seen.add(labelName)) continue;
            nodeCounts.get(labelName).incrementAndGet();
        }
    }

    private static class RelationshipCountKey {
        private final int startLabel;
        private final int type;
        private final int endLabel;

        RelationshipCountKey(int startLabel, int type, int endLabel) {
            this.startLabel = startLabel;
            this.type = type;
            this.endLabel = endLabel;
        }

        public String toString() {
            return String.format("[start:%d, type:%d, end:%d]", this.startLabel, this.type, this.endLabel);
        }
    }
}

