/*
 * Decompiled with CFR 0.152.
 */
package recovery;

import java.io.IOException;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CountsStoreRecoveryTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private GraphDatabaseService db;
    private final InMemoryIndexProvider indexProvider = new InMemoryIndexProvider(100);

    @Test
    public void shouldRecoverTheCountsStoreEvenWhenIfNeoStoreDoesNotNeedRecovery() throws Exception {
        this.createNode("A");
        this.checkPoint();
        this.createNode("B");
        this.flushNeoStoreOnly();
        this.crashAndRestart();
        try (Transaction tx = ((Kernel)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            Assert.assertEquals((long)1L, (long)tx.dataRead().countsForNode(tx.tokenRead().nodeLabel("A")));
            Assert.assertEquals((long)1L, (long)tx.dataRead().countsForNode(tx.tokenRead().nodeLabel("B")));
            Assert.assertEquals((long)2L, (long)tx.dataRead().countsForNode(-1));
        }
    }

    private void flushNeoStoreOnly() {
        NeoStores neoStores = ((RecordStorageEngine)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        metaDataStore.flush();
    }

    private void checkPoint() throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void crashAndRestart() throws Exception {
        GraphDatabaseService db1 = this.db;
        EphemeralFileSystemAbstraction uncleanFs = this.fsRule.snapshot(() -> ((GraphDatabaseService)db1).shutdown());
        this.db = this.databaseFactory((FileSystemAbstraction)uncleanFs, this.indexProvider).newImpermanentDatabase();
    }

    private void createNode(String label) {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)label)});
            tx.success();
        }
    }

    @Before
    public void before() {
        this.db = this.databaseFactory(this.fsRule.get(), this.indexProvider).newImpermanentDatabase();
    }

    private TestGraphDatabaseFactory databaseFactory(FileSystemAbstraction fs, InMemoryIndexProvider indexProvider) {
        return new TestGraphDatabaseFactory().setFileSystem(fs).setKernelExtensions(Arrays.asList(new InMemoryIndexProviderFactory((IndexProvider)indexProvider)));
    }

    @After
    public void after() {
        this.db.shutdown();
    }
}

