/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DummyExtension;
import org.neo4j.kernel.DummyExtensionFactory;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.GlobalKernelExtensions;
import org.neo4j.kernel.extension.KernelExtensionFactoryContractTest;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public final class TestKernelExtension
extends KernelExtensionFactoryContractTest {
    public TestKernelExtension() {
        super("dummy", DummyExtensionFactory.class);
    }

    @Test
    public void shouldBeStarted() {
        GraphDatabaseAPI graphdb = this.graphDb(0);
        try {
            Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)((DummyExtension)((GlobalKernelExtensions)graphdb.getDependencyResolver().resolveDependency(GlobalKernelExtensions.class)).resolveDependency(DummyExtension.class)).getStatus());
        }
        finally {
            graphdb.shutdown();
        }
    }

    @Test
    public void dependenciesCanBeRetrieved() {
        GraphDatabaseAPI graphdb = this.graphDb(0);
        try {
            Assert.assertEquals((Object)graphdb.getDependencyResolver().resolveDependency(Config.class), (Object)((DummyExtension)((GlobalKernelExtensions)graphdb.getDependencyResolver().resolveDependency(GlobalKernelExtensions.class)).resolveDependency(DummyExtension.class)).getDependencies().getConfig());
            Assert.assertEquals((Object)graphdb.getDependencyResolver().resolveDependency(NeoStoreDataSource.class), ((DummyExtension)((GlobalKernelExtensions)graphdb.getDependencyResolver().resolveDependency(GlobalKernelExtensions.class)).resolveDependency(DummyExtension.class)).getDependencies().getNeoStoreDataSource().get());
        }
        finally {
            graphdb.shutdown();
        }
    }

    @Test
    public void shouldBeShutdown() {
        GraphDatabaseAPI graphdb = this.graphDb(0);
        graphdb.shutdown();
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)((DummyExtension)((GlobalKernelExtensions)graphdb.getDependencyResolver().resolveDependency(GlobalKernelExtensions.class)).resolveDependency(DummyExtension.class)).getStatus());
    }
}

