/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class CompositeIndexingIT {
    private static final int LABEL_ID = 1;
    @ClassRule
    public static ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)200L);
    private final IndexDescriptor index;
    private GraphDatabaseAPI graphDatabaseAPI;

    @Before
    public void setup() throws Exception {
        KernelTransaction ktx;
        this.graphDatabaseAPI = dbRule.getGraphDatabaseAPI();
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            ktx = this.ktx();
            if (this.index.type() == IndexDescriptor.Type.UNIQUE) {
                ktx.schemaWrite().uniquePropertyConstraintCreate(this.index.schema());
            } else {
                ktx.schemaWrite().indexCreate(this.index.schema());
            }
            tx.success();
        }
        var2_2 = null;
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            ktx = this.ktx();
            while (ktx.schemaRead().indexGetState((IndexReference)this.index) != InternalIndexState.ONLINE) {
                Thread.sleep(10L);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @After
    public void clean() throws Exception {
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            if (this.index.type() == IndexDescriptor.Type.UNIQUE) {
                ktx.schemaWrite().constraintDrop((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.index.schema()));
            } else {
                ktx.schemaWrite().indexDrop((IndexReference)this.index);
            }
            tx.success();
        }
        tx = this.graphDatabaseAPI.beginTx();
        var2_2 = null;
        try {
            for (Node node : this.graphDatabaseAPI.getAllNodes()) {
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Parameterized.Parameters(name="Index: {0}")
    public static Iterable<Object[]> parameterValues() {
        return Arrays.asList(Iterators.array((Object[])new IndexDescriptor[]{TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1})}), Iterators.array((Object[])new IndexDescriptor[]{TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2})}), Iterators.array((Object[])new IndexDescriptor[]{TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2, 3, 4})}), Iterators.array((Object[])new IndexDescriptor[]{TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2, 3, 4, 5, 6, 7})}), Iterators.array((Object[])new IndexDescriptor[]{TestIndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1})}), Iterators.array((Object[])new IndexDescriptor[]{TestIndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1, 2})}), Iterators.array((Object[])new IndexDescriptor[]{TestIndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1, 2, 3, 4, 5, 6, 7})}));
    }

    public CompositeIndexingIT(IndexDescriptor nodeDescriptor) {
        this.index = nodeDescriptor;
    }

    @Test
    public void shouldSeeNodeAddedByPropertyToIndexInTranslation() throws Exception {
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            Write write = ktx.dataWrite();
            long nodeID = write.nodeCreate();
            write.nodeAddLabel(nodeID, 1);
            for (int propID : this.index.schema().getPropertyIds()) {
                write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                Assert.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.nodeReference(), (Matcher)Matchers.equalTo((Object)nodeID));
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @Test
    public void shouldSeeNodeAddedToByLabelIndexInTransaction() throws Exception {
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            Write write = ktx.dataWrite();
            long nodeID = write.nodeCreate();
            for (int propID : this.index.schema().getPropertyIds()) {
                write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            write.nodeAddLabel(nodeID, 1);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                Assert.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.nodeReference(), (Matcher)Matchers.equalTo((Object)nodeID));
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @Test
    public void shouldNotSeeNodeThatWasDeletedInTransaction() throws Exception {
        long nodeID = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            ktx.dataWrite().nodeDelete(nodeID);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @Test
    public void shouldNotSeeNodeThatHasItsLabelRemovedInTransaction() throws Exception {
        long nodeID = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            ktx.dataWrite().nodeRemoveLabel(nodeID, 1);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @Test
    public void shouldNotSeeNodeThatHasAPropertyRemovedInTransaction() throws Exception {
        long nodeID = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            ktx.dataWrite().nodeRemoveProperty(nodeID, this.index.schema().getPropertyIds()[0]);
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @Test
    public void shouldSeeAllNodesAddedInTransaction() throws Exception {
        if (this.index.type() != IndexDescriptor.Type.UNIQUE) {
            try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
                long nodeID1 = this.createNode();
                long nodeID2 = this.createNode();
                long nodeID3 = this.createNode();
                KernelTransaction ktx = this.ktx();
                HashSet<Long> result = new HashSet<Long>();
                try (NodeValueIndexCursor cursor = this.seek(ktx);){
                    while (cursor.next()) {
                        result.add(cursor.nodeReference());
                    }
                }
                MatcherAssert.assertThat(result, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{nodeID1, nodeID2, nodeID3}));
            }
        }
    }

    @Test
    public void shouldSeeAllNodesAddedBeforeTransaction() throws Exception {
        if (this.index.type() != IndexDescriptor.Type.UNIQUE) {
            long nodeID1 = this.createNode();
            long nodeID2 = this.createNode();
            long nodeID3 = this.createNode();
            try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
                KernelTransaction ktx = this.ktx();
                HashSet<Long> result = new HashSet<Long>();
                try (NodeValueIndexCursor cursor = this.seek(ktx);){
                    while (cursor.next()) {
                        result.add(cursor.nodeReference());
                    }
                }
                MatcherAssert.assertThat(result, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{nodeID1, nodeID2, nodeID3}));
            }
        }
    }

    @Test
    public void shouldNotSeeNodesLackingOneProperty() throws Exception {
        long nodeID1 = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            Write write = ktx.dataWrite();
            long irrelevantNodeID = write.nodeCreate();
            write.nodeAddLabel(irrelevantNodeID, 1);
            int[] propertyIds = this.index.schema().getPropertyIds();
            for (int i = 0; i < propertyIds.length - 1; ++i) {
                int propID = propertyIds[i];
                write.nodeSetProperty(irrelevantNodeID, propID, (Value)Values.intValue((int)propID));
            }
            HashSet<Long> result = new HashSet<Long>();
            try (NodeValueIndexCursor cursor = this.seek(ktx);){
                while (cursor.next()) {
                    result.add(cursor.nodeReference());
                }
            }
            MatcherAssert.assertThat(result, (Matcher)Matchers.contains((Object[])new Long[]{nodeID1}));
        }
    }

    private long createNode() throws KernelException {
        long nodeID;
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = this.ktx();
            Write write = ktx.dataWrite();
            nodeID = write.nodeCreate();
            write.nodeAddLabel(nodeID, 1);
            for (int propID : this.index.schema().getPropertyIds()) {
                write.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            tx.success();
        }
        return nodeID;
    }

    private NodeValueIndexCursor seek(KernelTransaction transaction) throws KernelException {
        NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor();
        transaction.dataRead().nodeIndexSeek((IndexReference)this.index, cursor, IndexOrder.NONE, this.exactQuery());
        return cursor;
    }

    private IndexQuery[] exactQuery() {
        int[] propertyIds = this.index.schema().getPropertyIds();
        IndexQuery[] query = new IndexQuery[propertyIds.length];
        for (int i = 0; i < query.length; ++i) {
            int propID = propertyIds[i];
            query[i] = IndexQuery.exact((int)propID, (Object)Values.of((Object)propID));
        }
        return query;
    }

    private KernelTransaction ktx() {
        return ((ThreadToStatementContextBridge)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }
}

